/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.util.expression;

import com.google.common.base.Joiner;
import java.util.Arrays;
import org.dcache.util.expression.ExpressionEvaluator;
import org.dcache.util.expression.SymbolTable;
import org.dcache.util.expression.Token;
import org.dcache.util.expression.Type;
import org.dcache.util.expression.TypeChecker;
import org.dcache.util.expression.TypeMismatchException;
import org.dcache.util.expression.UnknownIdentifierException;
import org.parboiled.trees.ImmutableTreeNode;

public class Expression
extends ImmutableTreeNode<Expression> {
    private final double _number;
    private final String _string;
    private final Token _token;
    private Type _type = Type.UNKNOWN;

    public Expression(double number) {
        this._token = Token.NUMBER_LITERAL;
        this._number = number;
        this._string = null;
    }

    public Expression(Token token, String string) {
        this._token = token;
        this._number = 0.0;
        this._string = string;
    }

    public Expression(Token token, Expression ... operands) {
        super(Arrays.asList(operands));
        this._token = token;
        this._number = 0.0;
        this._string = null;
    }

    public Type check(SymbolTable symbols) throws TypeMismatchException, UnknownIdentifierException {
        TypeChecker checker = new TypeChecker(symbols);
        return checker.check(this);
    }

    public Object evaluate(SymbolTable symbols) {
        ExpressionEvaluator evaluator = new ExpressionEvaluator(symbols);
        return evaluator.evaluate(this);
    }

    public boolean evaluateBoolean(SymbolTable symbols) {
        ExpressionEvaluator evaluator = new ExpressionEvaluator(symbols);
        return evaluator.evaluateBoolean(this);
    }

    public double evaluateDouble(SymbolTable symbols) {
        ExpressionEvaluator evaluator = new ExpressionEvaluator(symbols);
        return evaluator.evaluateDouble(this);
    }

    public String evaluateString(SymbolTable symbols) {
        ExpressionEvaluator evaluator = new ExpressionEvaluator(symbols);
        return evaluator.evaluateString(this);
    }

    public Type getType() {
        return this._type;
    }

    public void setType(Type type) {
        this._type = type;
    }

    public double getNumber() {
        return this._number;
    }

    public String getString() {
        return this._string;
    }

    public Token getToken() {
        return this._token;
    }

    public Expression get(int child) {
        return (Expression)((Object)this.getChildren().get(child));
    }

    public String toString() {
        switch (this._token) {
            case NUMBER_LITERAL: {
                return String.valueOf(this._number);
            }
            case STRING_LITERAL: {
                return "\"" + this._string + "\"";
            }
            case IDENTIFIER: {
                return this._string;
            }
        }
        return "(" + this._token.label + " " + Joiner.on((String)" ").join((Iterable)this.getChildren()) + ")";
    }
}

