/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.util;

import java.util.concurrent.TimeUnit;
import org.dcache.util.TransferRetryPolicy;

public final class TransferRetryPolicies {
    public static final long RETRY_PERIOD = TimeUnit.SECONDS.toMillis(30L);
    public static final long MOVER_TIMEOUT = TimeUnit.SECONDS.toMillis(30L);

    private TransferRetryPolicies() {
    }

    public static TransferRetryPolicy neverFailPolicy() {
        return new TransferRetryPolicy(Integer.MAX_VALUE, RETRY_PERIOD, Long.MAX_VALUE, MOVER_TIMEOUT);
    }

    public static TransferRetryPolicy tryOncePolicy(long timeout) {
        return new TransferRetryPolicy(1, 0L, timeout, MOVER_TIMEOUT);
    }

    public static TransferRetryPolicy tryTillTimeout(long timeout) {
        return new TransferRetryPolicy(Integer.MAX_VALUE, RETRY_PERIOD, timeout, MOVER_TIMEOUT);
    }
}

