/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.util;

import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import org.globus.gsi.gssapi.SSLUtil;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.MessageProp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleGSIEngine {
    private static final Logger _logger = LoggerFactory.getLogger(SimpleGSIEngine.class);
    private static final int SSLV3_MAX_PAYLOAD_SIZE = 32768;
    private static final int SSLV2_MAX_PAYLOAD_SIZE = 16384;
    private static final int GSI_MAX_PAYLOAD_SIZE = 0x2000000;
    private GSSContext _context;
    private volatile HandshakeStatus _handshakeStatus = HandshakeStatus.CH_INITIAL;
    private volatile GSIMode _currentMode = GSIMode.SSL_MODE;

    public SimpleGSIEngine(GSSContext context) {
        this._context = context;
    }

    public void setMode(GSIMode mode) {
        this._currentMode = mode;
    }

    public GSIMode getMode() {
        return this._currentMode;
    }

    public HandshakeStatus getHandshakeStatus() {
        return this._handshakeStatus;
    }

    public GSSContext getContext() {
        return this._context;
    }

    public synchronized void close() throws GSSException {
        if (this._context != null) {
            this._context.dispose();
            this._context = null;
            this._handshakeStatus = HandshakeStatus.CH_CLOSED;
        }
    }

    public synchronized GSIEngineResult handshake(ByteBuffer src, ByteBuffer dst) throws GSSException, IOException {
        if (this._handshakeStatus == HandshakeStatus.CH_CLOSED) {
            return new GSIEngineResult(0, 0, ResultStatus.CLOSED);
        }
        if (this._context == null) {
            throw new GSSException(12);
        }
        int bytesProduced = 0;
        int bytesConsumed = 0;
        try {
            byte[] inToken = this.readToken(src);
            if (inToken == null || inToken.length == 0) {
                return new GSIEngineResult(0, 0, ResultStatus.BUFFER_UNDERFLOW);
            }
            bytesConsumed = inToken.length;
            byte[] outToken = this._context.acceptSecContext(inToken, 0, inToken.length);
            if (outToken != null) {
                byte[] handshakeToken = outToken;
                if (this._currentMode == GSIMode.GSI_MODE) {
                    handshakeToken = SimpleGSIEngine.addGSIHeader(handshakeToken);
                }
                dst.put(handshakeToken);
                bytesProduced = handshakeToken.length;
            }
            this._handshakeStatus = this._context.isEstablished() ? HandshakeStatus.CH_ESTABLISHED : HandshakeStatus.CH_NOTDONEYET;
            return new GSIEngineResult(bytesConsumed, bytesProduced);
        }
        catch (BufferUnderflowException buex) {
            return new GSIEngineResult(bytesConsumed, bytesProduced, ResultStatus.BUFFER_UNDERFLOW);
        }
        catch (BufferOverflowException boex) {
            return new GSIEngineResult(bytesConsumed, bytesProduced, ResultStatus.BUFFER_OVERFLOW);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GSIEngineResult unwrap(ByteBuffer src, ByteBuffer dst) throws GSSException, IOException {
        SimpleGSIEngine simpleGSIEngine = this;
        synchronized (simpleGSIEngine) {
            if (this._handshakeStatus == HandshakeStatus.CH_CLOSED) {
                return new GSIEngineResult(0, 0, ResultStatus.CLOSED);
            }
        }
        if (this._context == null || !this._context.isEstablished()) {
            throw new GSSException(12);
        }
        MessageProp ignoreProp = new MessageProp(true);
        int bytesConsumed = 0;
        int bytesProduced = 0;
        try {
            byte[] wrapped = this.readToken(src);
            if (wrapped == null || wrapped.length == 0) {
                return new GSIEngineResult(0, 0, ResultStatus.BUFFER_UNDERFLOW);
            }
            bytesConsumed = wrapped.length;
            byte[] result = this._context.unwrap(wrapped, 0, wrapped.length, ignoreProp);
            if (result.length == 0) {
                return new GSIEngineResult(bytesConsumed, 0);
            }
            dst.put(result);
            bytesProduced = result.length;
            return new GSIEngineResult(bytesConsumed, bytesProduced);
        }
        catch (BufferUnderflowException buex) {
            return new GSIEngineResult(bytesConsumed, bytesProduced, ResultStatus.BUFFER_UNDERFLOW);
        }
        catch (BufferOverflowException boex) {
            return new GSIEngineResult(bytesConsumed, bytesProduced, ResultStatus.BUFFER_OVERFLOW);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GSIEngineResult wrap(ByteBuffer src, ByteBuffer dst) throws GSSException, IOException {
        SimpleGSIEngine simpleGSIEngine = this;
        synchronized (simpleGSIEngine) {
            if (this._handshakeStatus == HandshakeStatus.CH_CLOSED) {
                return new GSIEngineResult(0, 0, ResultStatus.CLOSED);
            }
        }
        if (this._context == null || !this._context.isEstablished()) {
            throw new GSSException(12);
        }
        int bytesConsumed = 0;
        int bytesWritten = 0;
        try {
            MessageProp ignoreProp = new MessageProp(true);
            byte[] contents = new byte[src.remaining()];
            src.get(contents);
            bytesConsumed = contents.length;
            _logger.info("Length before wrapping {}", (Object)bytesConsumed);
            byte[] wrapped = this._context.wrap(contents, 0, contents.length, ignoreProp);
            _logger.info("Length after wrapping {}", (Object)wrapped.length);
            if (wrapped.length == 0) {
                return new GSIEngineResult(bytesConsumed, 0);
            }
            dst.put(wrapped);
            bytesWritten = wrapped.length;
            return new GSIEngineResult(bytesConsumed, bytesWritten);
        }
        catch (BufferOverflowException boex) {
            return new GSIEngineResult(bytesConsumed, bytesWritten, ResultStatus.BUFFER_OVERFLOW);
        }
        catch (BufferUnderflowException buex) {
            return new GSIEngineResult(bytesConsumed, bytesWritten, ResultStatus.BUFFER_UNDERFLOW);
        }
    }

    private synchronized byte[] readToken(ByteBuffer in) throws IOException {
        byte[] buf = null;
        byte[] header = new byte[5];
        in.mark();
        try {
            in.get(header, 0, header.length - 1);
            if (SSLUtil.isSSLv3Packet((byte[])header)) {
                _logger.debug("SimpleGSIEngine: Received SSLv3Packet");
                this.setMode(GSIMode.SSL_MODE);
                in.get(header, 4, 1);
                short len = SSLUtil.toShort((byte)header[3], (byte)header[4]);
                if (len > 32768) {
                    throw new IOException("Packet length according to header is " + len + " bytes, while SSLv3 allows a maximum of " + 32768 + " bytes.");
                }
                if (len < 0) {
                    throw new IOException("Incorrect header format!");
                }
                buf = new byte[header.length + len];
                System.arraycopy(header, 0, buf, 0, header.length);
                in.get(buf, header.length, len);
            } else if (SSLUtil.isSSLv2HelloPacket((byte[])header)) {
                _logger.debug("SimpleGSIEngine: Received SSLv2HelloPacket");
                this.setMode(GSIMode.SSL_MODE);
                int len = ((header[0] & 0x7F) << 8 | header[1] & 0xFF) - 2;
                buf = new byte[header.length - 1 + len];
                System.arraycopy(header, 0, buf, 0, header.length - 1);
                if (len > 16384) {
                    throw new IOException("Packet length according to header is " + len + " bytes, while SSLv2 allows a maximum of " + 16384 + "bytes.");
                }
                if (len < 0) {
                    throw new IOException("Incorrect header format!");
                }
                in.get(buf, header.length - 1, len);
            } else {
                _logger.debug("SimpleGSIEngine: Received GSI-packet");
                this.setMode(GSIMode.GSI_MODE);
                int len = SSLUtil.toInt((byte[])header, (int)0);
                if (len > 0x2000000) {
                    throw new IOException("Token length " + len + " > " + 0x2000000);
                }
                if (len < 0) {
                    throw new IOException("Token length " + len + " < 0");
                }
                buf = new byte[len];
                in.get(buf);
            }
        }
        catch (BufferUnderflowException buex) {
            in.reset();
            throw buex;
        }
        return buf;
    }

    private static byte[] addGSIHeader(byte[] content) {
        byte[] header = new byte[4];
        SSLUtil.writeInt((int)content.length, (byte[])header, (int)0);
        byte[] result = new byte[header.length + content.length];
        System.arraycopy(header, 0, result, 0, header.length);
        System.arraycopy(content, 0, result, header.length, content.length);
        return result;
    }

    static class GSIEngineResult {
        private int _bytesConsumed;
        private int _bytesProduced;
        private ResultStatus _status;

        public GSIEngineResult(int bytesConsumed, int bytesWritten) {
            this._bytesConsumed = bytesConsumed;
            this._bytesProduced = bytesWritten;
            this._status = ResultStatus.OK;
        }

        public GSIEngineResult(int bytesConsumed, int bytesWritten, ResultStatus status) {
            this._bytesConsumed = bytesConsumed;
            this._bytesProduced = bytesWritten;
            this._status = status;
        }

        public int getBytesConsumed() {
            return this._bytesConsumed;
        }

        public int getBytesProduced() {
            return this._bytesProduced;
        }

        public ResultStatus getStatus() {
            return this._status;
        }
    }

    public static enum GSIMode {
        SSL_MODE,
        GSI_MODE;

    }

    public static enum ResultStatus {
        OK,
        BUFFER_UNDERFLOW,
        BUFFER_OVERFLOW,
        CLOSED;

    }

    public static enum HandshakeStatus {
        CH_INITIAL,
        CH_NOTDONEYET,
        CH_ESTABLISHED,
        CH_CLOSED;

    }
}

