/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.util;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetworkInterfaceView
implements Serializable {
    private static final long serialVersionUID = 5589652882519395824L;
    private static final Logger _log = LoggerFactory.getLogger(NetworkInterfaceView.class);
    private final String _displayName;
    private final byte[] _hardwareAddress;
    private final List<InterfaceAddressView> _interfaceAddresses;
    private final List<InetAddress> _inetAddresses;
    private final int _mtu;
    private final String _name;
    private final List<NetworkInterfaceView> _children;
    private final boolean _isLoopback;
    private final boolean _isPointToPoint;
    private final boolean _isUp;
    private final boolean _isVirtual;
    private final boolean _hasMulticastSupport;
    private final NetworkInterfaceView _parent;

    public NetworkInterfaceView(NetworkInterface source) throws SocketException {
        this(source, null);
        Preconditions.checkArgument((source.getParent() == null ? 1 : 0) != 0, (String)"Cannot create NetworkInterfaceView from interface %s", (Object[])new Object[]{source.getName()});
    }

    private NetworkInterfaceView(NetworkInterface ni, NetworkInterfaceView parent) throws SocketException {
        this._displayName = ni.getDisplayName();
        this._hardwareAddress = ni.getHardwareAddress();
        this._mtu = ni.getMTU();
        this._name = ni.getName();
        this._isLoopback = ni.isLoopback();
        this._isPointToPoint = ni.isPointToPoint();
        this._isUp = ni.isUp();
        this._isVirtual = ni.isVirtual();
        this._hasMulticastSupport = ni.supportsMulticast();
        this._parent = parent;
        this._interfaceAddresses = this.viewOfInterfaceAddresses(ni);
        this._inetAddresses = this.viewOfInetAddresses(ni);
        this._children = this.viewOfChildren(ni);
    }

    private List<InterfaceAddressView> viewOfInterfaceAddresses(NetworkInterface ni) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (InterfaceAddress address : ni.getInterfaceAddresses()) {
            builder.add((Object)new InterfaceAddressView(address));
        }
        return builder.build();
    }

    private List<InetAddress> viewOfInetAddresses(NetworkInterface ni) {
        ImmutableList.Builder builder = ImmutableList.builder();
        Enumeration<InetAddress> addresses = ni.getInetAddresses();
        while (addresses.hasMoreElements()) {
            InetAddress address = addresses.nextElement();
            builder.add((Object)address);
        }
        return builder.build();
    }

    private List<NetworkInterfaceView> viewOfChildren(NetworkInterface ni) {
        ImmutableList.Builder builder = ImmutableList.builder();
        Enumeration<NetworkInterface> subInterfaces = ni.getSubInterfaces();
        while (subInterfaces.hasMoreElements()) {
            NetworkInterface child = subInterfaces.nextElement();
            try {
                NetworkInterfaceView childView = new NetworkInterfaceView(child, this);
                builder.add((Object)childView);
            }
            catch (SocketException e) {
                _log.debug("Unable to add child {} of interface {}: {}", new Object[]{child.getName(), ni.getName(), e.getMessage()});
            }
        }
        return builder.build();
    }

    public List<NetworkInterfaceView> getSubInterfaces() {
        return this._children;
    }

    public Enumeration<InetAddress> getInetAddresses() {
        return Iterators.asEnumeration(this._inetAddresses.iterator());
    }

    public List<InetAddress> getInetAddressList() {
        return this._inetAddresses;
    }

    public boolean hasSubInterfaces() {
        return !this._children.isEmpty();
    }

    public String getDisplayName() {
        return this._displayName;
    }

    public byte[] getHardwareAddress() {
        return this._hardwareAddress;
    }

    public List<InterfaceAddressView> getInterfaceAddresses() {
        return this._interfaceAddresses;
    }

    public int getMTU() {
        return this._mtu;
    }

    public String getName() {
        return this._name;
    }

    public NetworkInterfaceView getParent() {
        return this._parent;
    }

    public boolean isLoopback() {
        return this._isLoopback;
    }

    public boolean isPointToPoint() {
        return this._isPointToPoint;
    }

    public boolean isUp() {
        return this._isUp;
    }

    public boolean isVirtual() {
        return this._isVirtual;
    }

    public boolean supportsMulticast() {
        return this._hasMulticastSupport;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("name:");
        if (this.getName() != null) {
            sb.append(this.getName());
        } else {
            sb.append("null");
        }
        if (this.getDisplayName() != null) {
            sb.append(" (").append(this.getDisplayName()).append(")");
        }
        List<InterfaceAddressView> addresses = this.getInterfaceAddresses();
        sb.append(" addresses:\n");
        for (InterfaceAddressView address : addresses) {
            sb.append(address.getAddress()).append(";\n");
        }
        return sb.toString();
    }

    public static class InterfaceAddressView
    implements Serializable {
        private static final long serialVersionUID = 467290761384687925L;
        private final InetAddress _address;
        private final InetAddress _broadcast;
        private final short _maskLength;

        public InterfaceAddressView(InterfaceAddress ifAddress) {
            this._address = ifAddress.getAddress();
            this._broadcast = ifAddress.getBroadcast();
            this._maskLength = ifAddress.getNetworkPrefixLength();
        }

        public InetAddress getAddress() {
            return this._address;
        }

        public InetAddress getBroadcast() {
            return this._broadcast;
        }

        public short getNetworkPrefixLength() {
            return this._maskLength;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.getNetworkPrefixLength(), this.getAddress(), this.getBroadcast()});
        }

        public boolean equals(Object rawOther) {
            if (rawOther == this) {
                return true;
            }
            if (rawOther == null) {
                return false;
            }
            if (rawOther.getClass().equals(InterfaceAddressView.class)) {
                InterfaceAddressView other = (InterfaceAddressView)rawOther;
                return this._maskLength == other.getNetworkPrefixLength() && Objects.equal((Object)this._address, (Object)other.getAddress()) && Objects.equal((Object)this._broadcast, (Object)other.getBroadcast());
            }
            return false;
        }

        public String toString() {
            return this._address.toString() + "/" + this._maskLength + " [" + this._broadcast + "]";
        }
    }
}

