/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.util;

import com.google.common.base.Preconditions;
import liquibase.logging.LogLevel;
import liquibase.logging.Logger;
import org.slf4j.LoggerFactory;

public class LiquibaseSlf4jLogger
implements Logger {
    private static final int PRIORITY = 2;
    private org.slf4j.Logger _inner;
    private LogLevel _logLevel;

    public int getPriority() {
        return 2;
    }

    private void guardInner() {
        Preconditions.checkState((this._inner != null ? 1 : 0) != 0, (Object)"logger not set; use setName");
    }

    public void debug(String message) {
        this.guardInner();
        this._inner.debug(message);
    }

    public void debug(String message, Throwable t) {
        this.guardInner();
        this._inner.debug(message, t);
    }

    public LogLevel getLogLevel() {
        return this._logLevel;
    }

    public void info(String message) {
        this.guardInner();
        this._inner.info(message);
    }

    public void info(String message, Throwable t) {
        this.guardInner();
        this._inner.info(message, t);
    }

    public void setLogLevel(String logLevel) {
        this._logLevel = LogLevel.valueOf((String)logLevel.toUpperCase());
    }

    public void setLogLevel(LogLevel logLevel) {
        this._logLevel = logLevel;
    }

    public void setLogLevel(String logLevel, String logFile) {
        this.setLogLevel(logLevel);
    }

    public void setName(String name) {
        this._inner = LoggerFactory.getLogger((String)name);
    }

    public void severe(String arg0) {
        this.guardInner();
        this._inner.error(arg0);
    }

    public void severe(String arg0, Throwable arg1) {
        this.guardInner();
        this._inner.error(arg0, arg1);
    }

    public void warning(String arg0) {
        this.guardInner();
        this._inner.warn(arg0);
    }

    public void warning(String arg0, Throwable arg1) {
        this.guardInner();
        this._inner.warn(arg0, arg1);
    }
}

