/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketAddress;
import java.security.cert.X509Certificate;
import java.util.concurrent.TimeUnit;
import org.dcache.util.Files;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.bio.SocketEndPoint;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.bio.SocketConnector;
import org.globus.gsi.GSIConstants;
import org.globus.gsi.GlobusCredential;
import org.globus.gsi.GlobusCredentialException;
import org.globus.gsi.TrustedCertificates;
import org.globus.gsi.gssapi.GSSConstants;
import org.globus.gsi.gssapi.GlobusGSSCredentialImpl;
import org.globus.gsi.gssapi.net.GssInputStream;
import org.globus.gsi.gssapi.net.GssOutputStream;
import org.globus.gsi.gssapi.net.impl.GSIGssSocket;
import org.gridforum.jgss.ExtendedGSSContext;
import org.gridforum.jgss.ExtendedGSSManager;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JettyGSIConnector
extends SocketConnector {
    private static final Logger _log = LoggerFactory.getLogger(JettyGSIConnector.class);
    protected static final String MODE_SSL = "ssl";
    protected static final String MODE_GSI = "gsi";
    private static final long DEFAULT_HOST_CERT_REFRESH_INTERVAL = TimeUnit.MILLISECONDS.convert(12L, TimeUnit.HOURS);
    private static final long DEFAULT_TRUST_ANCHOR_REFRESH_INTERVAL = TimeUnit.MILLISECONDS.convert(4L, TimeUnit.HOURS);
    private GSSCredential _credentials;
    private TrustedCertificates _trustedCerts;
    private GSSManager _manager;
    private String _serverCert;
    private String _serverKey;
    private String _serverProxy;
    private String _caCertDir;
    private boolean _encrypt;
    private long _hostCertRefreshInterval;
    private long _trustAnchorRefreshInterval;
    private long _hostCertRefreshTimestamp = 0L;
    private long _trustAnchorRefreshTimestamp = 0L;
    private volatile boolean _autoFlush;
    private volatile boolean _requireClientAuth = true;
    private volatile boolean _acceptNoClientCerts = false;
    private volatile boolean _checkContextExpiration = false;
    private volatile boolean _rejectLimitedProxy = false;
    private volatile Integer _mode = GSIConstants.MODE_SSL;
    private volatile int _handshakeTimeout = 0;

    public JettyGSIConnector() {
        this._hostCertRefreshInterval = DEFAULT_HOST_CERT_REFRESH_INTERVAL;
        this._trustAnchorRefreshInterval = DEFAULT_TRUST_ANCHOR_REFRESH_INTERVAL;
    }

    private void guardNotOpen() throws IllegalStateException {
        if (this._serverSocket != null) {
            throw new IllegalStateException("Cannot change this parameter while the connector is open");
        }
    }

    public String getHostCertificatePath() {
        return this._serverCert;
    }

    public void setHostCertificatePath(String serverCert) throws IOException {
        this.guardNotOpen();
        Files.checkFile((String)serverCert);
        this._serverCert = serverCert;
    }

    public String getHostKeyPath() {
        return this._serverKey;
    }

    public void setHostKeyPath(String serverKey) throws IOException {
        this.guardNotOpen();
        Files.checkFile((String)serverKey);
        this._serverKey = serverKey;
    }

    public String getProxy() {
        return this._serverProxy;
    }

    public void setProxy(String serverProxy) throws IOException {
        this.guardNotOpen();
        Files.checkFile((String)serverProxy);
        this._serverProxy = serverProxy;
    }

    public String getCaCertificatePath() {
        return this._caCertDir;
    }

    public void setCaCertificatePath(String caCertDir) throws IOException {
        this.guardNotOpen();
        Files.checkDirectory((String)caCertDir);
        this._caCertDir = caCertDir;
    }

    public boolean getEncrypt() {
        return this._encrypt;
    }

    public void setEncrypt(boolean encrypt) {
        this.guardNotOpen();
        this._encrypt = encrypt;
    }

    public boolean getAutoFlush() {
        return this._autoFlush;
    }

    public void setAutoFlush(boolean autoFlush) {
        this._autoFlush = autoFlush;
    }

    public String getGssMode() {
        if (GSIConstants.MODE_GSI.equals(this._mode)) {
            return MODE_GSI;
        }
        return MODE_SSL;
    }

    public void setGssMode(String s) {
        if (s == null) {
            this._mode = GSIConstants.MODE_SSL;
        } else if (s.equalsIgnoreCase(MODE_SSL)) {
            this._mode = GSIConstants.MODE_SSL;
        } else if (s.equalsIgnoreCase(MODE_GSI)) {
            this._mode = GSIConstants.MODE_GSI;
        } else {
            throw new IllegalArgumentException("Unsupported mode: " + s);
        }
    }

    public boolean getRequireClientAuth() {
        return this._requireClientAuth;
    }

    public void setRequireClientAuth(boolean requireClientAuth) {
        this._requireClientAuth = requireClientAuth;
    }

    public boolean getAcceptNoClientCerts() {
        return this._acceptNoClientCerts;
    }

    public void setAcceptNoClientCerts(boolean acceptNoClientCerts) {
        this._acceptNoClientCerts = acceptNoClientCerts;
    }

    public boolean getCheckContextExpiration() {
        return this._checkContextExpiration;
    }

    public void setCheckContextExpiration(boolean checkContextExpiration) {
        this._checkContextExpiration = checkContextExpiration;
    }

    public boolean getRejectLimitedProxy() {
        return this._rejectLimitedProxy;
    }

    public void setRejectLimitedProxy(boolean rejectLimitedProxy) {
        this._rejectLimitedProxy = rejectLimitedProxy;
    }

    public int getHandshakeTimeout() {
        return this._handshakeTimeout;
    }

    public void setHandshakeTimeout(int msec) {
        this._handshakeTimeout = msec;
    }

    protected ExtendedGSSContext createGSSContext() throws GSSException {
        ExtendedGSSContext context = (ExtendedGSSContext)this._manager.createContext(this._credentials);
        context.setOption(GSSConstants.GSS_MODE, (Object)this._mode);
        context.setOption(GSSConstants.REQUIRE_CLIENT_AUTH, (Object)this._requireClientAuth);
        context.setOption(GSSConstants.ACCEPT_NO_CLIENT_CERTS, (Object)this._acceptNoClientCerts);
        context.setOption(GSSConstants.CHECK_CONTEXT_EXPIRATION, (Object)this._checkContextExpiration);
        context.setOption(GSSConstants.REJECT_LIMITED_PROXY, (Object)this._rejectLimitedProxy);
        if (this._trustedCerts != null) {
            context.setOption(GSSConstants.TRUSTED_CERTIFICATES, (Object)this._trustedCerts);
        }
        context.requestConf(this._encrypt);
        return context;
    }

    private synchronized void loadServerCredentials() throws IOException {
        long timeSinceLastServerRefresh = System.currentTimeMillis() - this._hostCertRefreshTimestamp;
        try {
            if (this._credentials == null || this._manager == null || timeSinceLastServerRefresh >= this._hostCertRefreshInterval) {
                GlobusCredential cred;
                _log.info("Time since last server cert refresh {}", (Object)timeSinceLastServerRefresh);
                _log.info("Loading server certificates. Current refresh interval: {} ms", (Object)this._hostCertRefreshInterval);
                if (this._serverProxy != null && !this._serverProxy.equals("")) {
                    _log.info("Server Proxy: {}", (Object)this._serverProxy);
                    cred = new GlobusCredential(this._serverProxy);
                } else if (this._serverCert != null && this._serverKey != null) {
                    _log.info("Server Certificate: {}", (Object)this._serverCert);
                    _log.info("Server Key: {}", (Object)this._serverKey);
                    cred = new GlobusCredential(this._serverCert, this._serverKey);
                } else {
                    throw new IllegalStateException("Server credentialshave not been configured");
                }
                this._credentials = new GlobusGSSCredentialImpl(cred, 2);
                this._manager = ExtendedGSSManager.getInstance();
                this._hostCertRefreshTimestamp = System.currentTimeMillis();
            }
        }
        catch (GlobusCredentialException e) {
            throw new IOException("Failed to load credentials", e);
        }
        catch (GSSException e) {
            throw new IOException("Failed to load credentials", e);
        }
    }

    private synchronized void loadTrustAnchors() {
        long timeSinceLastTARefresh = System.currentTimeMillis() - this._trustAnchorRefreshTimestamp;
        if (this._caCertDir != null && (this._trustedCerts == null || timeSinceLastTARefresh >= this._trustAnchorRefreshInterval)) {
            _log.info("Time since last TA Refresh {}", (Object)timeSinceLastTARefresh);
            _log.info("Loading trust anchors. Current refresh interval: {} ms", (Object)this._trustAnchorRefreshInterval);
            _log.info("CA certificate directory: {}", (Object)this._caCertDir);
            this._trustedCerts = TrustedCertificates.load((String)this._caCertDir);
            this._trustAnchorRefreshTimestamp = System.currentTimeMillis();
        }
    }

    public void accept(int acceptorID) throws IOException, InterruptedException {
        Socket socket = this._serverSocket.accept();
        try {
            this.loadServerCredentials();
            this.loadTrustAnchors();
            this.configure(socket);
            GsiSocket gsiSocket = new GsiSocket(socket, (GSSContext)this.createGSSContext());
            gsiSocket.setUseClientMode(false);
            gsiSocket.setAuthorization(null);
            gsiSocket.setAutoFlush(this._autoFlush);
            GsiConnection connection = new GsiConnection((Socket)((Object)gsiSocket));
            connection.dispatch();
        }
        catch (GSSException e) {
            _log.warn("Failed to initialize GSS Context: " + e);
            throw new IOException("Failed to initialize GSS context", e);
        }
        catch (IOException e) {
            _log.warn("Failed to accept connection: " + e);
            throw e;
        }
    }

    public boolean isConfidential(Request request) {
        int confidentialPort = this.getConfidentialPort();
        return (confidentialPort == 0 || confidentialPort == request.getServerPort()) && this._encrypt;
    }

    public boolean isIntegral(Request request) {
        int integralPort = this.getIntegralPort();
        return (integralPort == 0 || integralPort == request.getServerPort()) && this._encrypt;
    }

    public void customize(EndPoint endpoint, Request request) throws IOException {
        super.customize(endpoint, request);
        request.setScheme("https");
        SocketEndPoint socketEndPoint = (SocketEndPoint)endpoint;
        GsiSocket gsiSocket = (GsiSocket)((Object)socketEndPoint.getTransport());
        try {
            GSSCredential delegated;
            ExtendedGSSContext context = (ExtendedGSSContext)gsiSocket.getContext();
            X509Certificate[] chain = (X509Certificate[])context.inquireByOid(GSSConstants.X509_CERT_CHAIN);
            if (chain != null) {
                request.setAttribute("javax.servlet.request.X509Certificate", (Object)chain);
            } else if (this._requireClientAuth && !this._acceptNoClientCerts) {
                throw new IllegalStateException("no client auth");
            }
            request.setAttribute("org.globus.gsi.context", (Object)context);
            String dn = ((Object)context.getSrcName()).toString();
            if (dn != null) {
                request.setAttribute("org.globus.gsi.authorized.user.dn", (Object)dn);
            }
            if ((delegated = context.getDelegCred()) != null) {
                request.setAttribute("org.globus.gsi.credentials", (Object)delegated);
            }
        }
        catch (GSSException e) {
            throw new IOException("Failed to retrieve context properties", e);
        }
    }

    public void setMillisecBetweenHostCertRefresh(int ms) {
        this._hostCertRefreshInterval = ms;
    }

    public void setMillisecBetweenTrustAnchorRefresh(int ms) {
        this._trustAnchorRefreshInterval = ms;
    }

    private static class GsiSocket
    extends GSIGssSocket {
        private InputStream _in = new GsiInputStream();
        private OutputStream _out = new GsiOutputStream();
        private boolean _autoFlush;

        public GsiSocket(Socket socket, GSSContext context) {
            super(socket, context);
        }

        public SocketAddress getRemoteSocketAddress() {
            return this.getWrappedSocket().getRemoteSocketAddress();
        }

        public OutputStream getOutputStream() throws IOException {
            return this._out;
        }

        public InputStream getInputStream() throws IOException {
            return this._in;
        }

        public void setAutoFlush(boolean autoFlush) {
            this._autoFlush = autoFlush;
        }

        public boolean getAutoFlush() {
            return this._autoFlush;
        }

        private class GsiOutputStream
        extends OutputStream {
            private GssOutputStream out;

            private GsiOutputStream() {
            }

            private GssOutputStream getOutputStream() throws IOException {
                if (this.out == null) {
                    this.out = (GssOutputStream)GsiSocket.super.getOutputStream();
                    this.out.setAutoFlush(GsiSocket.this._autoFlush);
                }
                return this.out;
            }

            @Override
            public void close() throws IOException {
                this.getOutputStream().close();
            }

            @Override
            public void flush() throws IOException {
                this.getOutputStream().flush();
            }

            @Override
            public void write(byte[] b) throws IOException {
                this.getOutputStream().write(b);
            }

            @Override
            public void write(byte[] b, int off, int len) throws IOException {
                this.getOutputStream().write(b, off, len);
            }

            @Override
            public void write(int b) throws IOException {
                this.getOutputStream().write(b);
            }
        }

        private class GsiInputStream
        extends InputStream {
            private GssInputStream in;

            private GsiInputStream() {
            }

            private GssInputStream getInputStream() throws IOException {
                if (this.in == null) {
                    this.in = (GssInputStream)GsiSocket.super.getInputStream();
                }
                return this.in;
            }

            @Override
            public int available() throws IOException {
                return this.getInputStream().available();
            }

            @Override
            public void close() throws IOException {
                this.getInputStream().close();
            }

            @Override
            public int read() throws IOException {
                return this.getInputStream().read();
            }

            @Override
            public int read(byte[] b) throws IOException {
                return this.getInputStream().read(b);
            }

            @Override
            public int read(byte[] b, int off, int len) throws IOException {
                return this.getInputStream().read(b, off, len);
            }

            @Override
            public long skip(long n) throws IOException {
                return this.getInputStream().skip(n);
            }
        }
    }

    public class GsiConnection
    extends SocketConnector.ConnectorEndPoint {
        public GsiConnection(Socket socket) throws IOException {
            super((SocketConnector)JettyGSIConnector.this, socket);
        }

        public void run() {
            try {
                int handshakeTimeout = JettyGSIConnector.this.getHandshakeTimeout();
                int oldTimeout = this._socket.getSoTimeout();
                if (handshakeTimeout > 0) {
                    this._socket.setSoTimeout(handshakeTimeout);
                }
                GsiSocket gsiSocket = (GsiSocket)((Object)this._socket);
                gsiSocket.startHandshake();
                if (handshakeTimeout > 0) {
                    this._socket.setSoTimeout(oldTimeout);
                }
                super.run();
            }
            catch (IOException e) {
                _log.warn(e.toString());
                try {
                    this.close();
                }
                catch (IOException e2) {
                    _log.warn(e2.toString());
                }
            }
        }
    }
}

