/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.util;

import java.io.IOException;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.security.cert.X509Certificate;
import java.util.concurrent.TimeUnit;
import org.dcache.util.Files;
import org.dcache.util.GSISelectChannelEndPoint;
import org.eclipse.jetty.http.HttpParser;
import org.eclipse.jetty.io.Buffer;
import org.eclipse.jetty.io.Buffers;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.ThreadLocalBuffers;
import org.eclipse.jetty.io.nio.DirectNIOBuffer;
import org.eclipse.jetty.io.nio.SelectChannelEndPoint;
import org.eclipse.jetty.io.nio.SelectorManager;
import org.eclipse.jetty.server.HttpConnection;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.nio.SelectChannelConnector;
import org.globus.gsi.GSIConstants;
import org.globus.gsi.GlobusCredential;
import org.globus.gsi.GlobusCredentialException;
import org.globus.gsi.TrustedCertificates;
import org.globus.gsi.gssapi.GSSConstants;
import org.globus.gsi.gssapi.GlobusGSSCredentialImpl;
import org.gridforum.jgss.ExtendedGSSContext;
import org.gridforum.jgss.ExtendedGSSManager;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JettyAsyncGSIConnector
extends SelectChannelConnector {
    private static Logger _logger = LoggerFactory.getLogger(JettyAsyncGSIConnector.class);
    protected static final String MODE_SSL = "ssl";
    protected static final String MODE_GSI = "gsi";
    private static final long DEFAULT_HOST_CERT_REFRESH_INTERVAL = TimeUnit.MILLISECONDS.convert(12L, TimeUnit.HOURS);
    private static final long DEFAULT_TRUST_ANCHOR_REFRESH_INTERVAL = TimeUnit.MILLISECONDS.convert(4L, TimeUnit.HOURS);
    private static GSSCredential _credentials;
    private static GSSManager _gssManager;
    private static TrustedCertificates _trustedCerts;
    private String _serverCert;
    private String _serverKey;
    private String _serverProxy;
    private String _caCertDir;
    private boolean _encrypt;
    private long _hostCertRefreshInterval;
    private long _trustAnchorRefreshInterval;
    private volatile boolean _autoFlush;
    private volatile boolean _requireClientAuth = true;
    private volatile boolean _acceptNoClientCerts = false;
    private volatile boolean _checkContextExpiration = false;
    private volatile boolean _rejectLimitedProxy = false;
    private volatile Integer _mode = GSIConstants.MODE_GSI;
    private long _hostCertRefreshTimestamp;
    private long _trustAnchorRefreshTimestamp;
    private Buffers _gsiBuffers;

    public JettyAsyncGSIConnector() {
        this._hostCertRefreshInterval = DEFAULT_HOST_CERT_REFRESH_INTERVAL;
        this._trustAnchorRefreshInterval = DEFAULT_TRUST_ANCHOR_REFRESH_INTERVAL;
    }

    public void customize(EndPoint endpoint, Request request) throws IOException {
        super.customize(endpoint, request);
        request.setScheme("https");
        GSISelectChannelEndPoint selectChannelEndpoint = (GSISelectChannelEndPoint)endpoint;
        ExtendedGSSContext context = (ExtendedGSSContext)selectChannelEndpoint.getContext();
        try {
            GSSCredential delegated;
            X509Certificate[] chain = (X509Certificate[])context.inquireByOid(GSSConstants.X509_CERT_CHAIN);
            if (chain != null) {
                request.setAttribute("javax.servlet.request.X509Certificate", (Object)chain);
            } else if (this._requireClientAuth && !this._acceptNoClientCerts) {
                throw new IllegalStateException("no client auth");
            }
            request.setAttribute("org.globus.gsi.context", (Object)context);
            String dn = ((Object)context.getSrcName()).toString();
            if (dn != null) {
                request.setAttribute("org.globus.gsi.authorized.user.dn", (Object)dn);
            }
            if ((delegated = context.getDelegCred()) != null) {
                request.setAttribute("org.globus.gsi.credentials", (Object)delegated);
            }
        }
        catch (GSSException e) {
            throw new IOException("Failed to retrieve context properties", e);
        }
    }

    private void loadServerCredentials() throws IOException {
        try {
            GlobusCredential cred;
            _logger.debug("Loading credentials");
            if (this._serverProxy != null && !this._serverProxy.equals("")) {
                _logger.info("Server Proxy: {}", (Object)this._serverProxy);
                cred = new GlobusCredential(this._serverProxy);
            } else if (this._serverCert != null && this._serverKey != null) {
                _logger.info("Server Certificate: {}", (Object)this._serverCert);
                _logger.info("Server Key: {}", (Object)this._serverKey);
                cred = new GlobusCredential(this._serverCert, this._serverKey);
            } else {
                throw new IllegalStateException("Server credentials have not been configured");
            }
            _credentials = new GlobusGSSCredentialImpl(cred, 2);
        }
        catch (GlobusCredentialException e) {
            throw new IOException("Failed to load credentials", e);
        }
        catch (GSSException e) {
            throw new IOException("Failed to load credentials", e);
        }
        _gssManager = ExtendedGSSManager.getInstance();
    }

    private void loadTrustAnchors() {
        if (this._caCertDir != null) {
            _logger.info("CA certificate directory: {}", (Object)this._caCertDir);
            _trustedCerts = TrustedCertificates.load((String)this._caCertDir);
        }
    }

    protected ExtendedGSSContext createGSSContext() throws GSSException {
        ExtendedGSSContext context = (ExtendedGSSContext)_gssManager.createContext(_credentials);
        context.setOption(GSSConstants.GSS_MODE, (Object)this._mode);
        context.setOption(GSSConstants.REQUIRE_CLIENT_AUTH, (Object)this._requireClientAuth);
        context.setOption(GSSConstants.ACCEPT_NO_CLIENT_CERTS, (Object)this._acceptNoClientCerts);
        context.setOption(GSSConstants.CHECK_CONTEXT_EXPIRATION, (Object)this._checkContextExpiration);
        context.setOption(GSSConstants.REJECT_LIMITED_PROXY, (Object)this._rejectLimitedProxy);
        if (_trustedCerts != null) {
            context.setOption(GSSConstants.TRUSTED_CERTIFICATES, (Object)_trustedCerts);
        }
        context.requestConf(this._encrypt);
        return context;
    }

    protected void doStart() throws Exception {
        ThreadLocalBuffers buffers = new ThreadLocalBuffers(){

            protected Buffer newBuffer(int size) {
                return new DirectNIOBuffer(size);
            }

            protected Buffer newHeader(int size) {
                return new DirectNIOBuffer(size);
            }

            protected boolean isHeader(Buffer buffer) {
                return true;
            }
        };
        this._gsiBuffers = buffers;
        super.doStart();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SelectChannelEndPoint newEndPoint(SocketChannel channel, SelectorManager.SelectSet selectSet, SelectionKey key) throws IOException {
        ExtendedGSSContext context;
        _logger.info("Trying to create a GSS context!");
        try {
            JettyAsyncGSIConnector jettyAsyncGSIConnector = this;
            synchronized (jettyAsyncGSIConnector) {
                long timeSinceLastServerRefresh = System.currentTimeMillis() - this._hostCertRefreshTimestamp;
                long timeSinceLastTARefresh = System.currentTimeMillis() - this._trustAnchorRefreshTimestamp;
                if (_trustedCerts == null || timeSinceLastTARefresh >= this._trustAnchorRefreshInterval) {
                    _logger.info("Time since last TA Refresh {}", (Object)timeSinceLastTARefresh);
                    _logger.info("Loading trust anchors. Current refresh interval: {} ms", (Object)this._trustAnchorRefreshInterval);
                    this.loadTrustAnchors();
                    this._trustAnchorRefreshTimestamp = System.currentTimeMillis();
                }
                if (_credentials == null || _gssManager == null || timeSinceLastServerRefresh >= this._hostCertRefreshInterval) {
                    _logger.info("Time since last server cert refresh {}", (Object)timeSinceLastServerRefresh);
                    _logger.info("Loading server certificates. Current refresh interval: {} ms", (Object)this._hostCertRefreshInterval);
                    this.loadServerCredentials();
                    this._hostCertRefreshTimestamp = System.currentTimeMillis();
                }
            }
            context = this.createGSSContext();
        }
        catch (GSSException gssex) {
            _logger.warn("Failed to initialize GSS Context: {}", (Throwable)gssex);
            throw new IOException("Failed to initialize GSS context", gssex);
        }
        GSISelectChannelEndPoint endp = new GSISelectChannelEndPoint(this._gsiBuffers, channel, selectSet, key, (GSSContext)context);
        return endp;
    }

    protected Connection newConnection(SocketChannel channel, SelectChannelEndPoint endpoint) {
        HttpConnection connection = (HttpConnection)super.newConnection(channel, endpoint);
        ((HttpParser)connection.getParser()).setForceContentBuffer(true);
        return connection;
    }

    public boolean isConfidential(Request request) {
        int confidentialPort = this.getConfidentialPort();
        return confidentialPort == 0 || confidentialPort == request.getServerPort();
    }

    public boolean isIntegral(Request request) {
        int integralPort = this.getIntegralPort();
        return integralPort == 0 || integralPort == request.getServerPort();
    }

    public void setAcceptNoClientCerts(boolean acceptNoClientCerts) {
        this._acceptNoClientCerts = acceptNoClientCerts;
    }

    public void setCheckContextExpiration(boolean checkContextExpiration) {
        this._checkContextExpiration = checkContextExpiration;
    }

    public void setRejectLimitedProxy(boolean rejectLimitedProxy) {
        this._rejectLimitedProxy = rejectLimitedProxy;
    }

    public void setRequireClientAuth(boolean requireClientAuth) {
        this._requireClientAuth = requireClientAuth;
    }

    public String getGssMode() {
        if (GSIConstants.MODE_GSI.equals(this._mode)) {
            return MODE_GSI;
        }
        return MODE_SSL;
    }

    public void setGssMode(String s) {
        if (s == null) {
            this._mode = GSIConstants.MODE_SSL;
        } else if (s.equalsIgnoreCase(MODE_SSL)) {
            this._mode = GSIConstants.MODE_SSL;
        } else if (s.equalsIgnoreCase(MODE_GSI)) {
            this._mode = GSIConstants.MODE_GSI;
        } else {
            throw new IllegalArgumentException("Unsupported mode: " + s);
        }
    }

    public String getHostCertificatePath() {
        return this._serverCert;
    }

    public void setHostCertificatePath(String serverCert) throws IOException {
        Files.checkFile((String)serverCert);
        this._serverCert = serverCert;
    }

    public String getHostKeyPath() {
        return this._serverKey;
    }

    public void setHostKeyPath(String serverKey) throws IOException {
        Files.checkFile((String)serverKey);
        this._serverKey = serverKey;
    }

    public String getProxy() {
        return this._serverProxy;
    }

    public void setProxy(String serverProxy) throws IOException {
        Files.checkFile((String)serverProxy);
        this._serverProxy = serverProxy;
    }

    public String getCaCertificatePath() {
        return this._caCertDir;
    }

    public void setCaCertificatePath(String caCertDir) throws IOException {
        Files.checkDirectory((String)caCertDir);
        this._caCertDir = caCertDir;
    }

    public boolean getEncrypt() {
        return this._encrypt;
    }

    public void setEncrypt(boolean encrypt) {
        this._encrypt = encrypt;
    }

    public boolean getAutoFlush() {
        return this._autoFlush;
    }

    public void setAutoFlush(boolean autoFlush) {
        this._autoFlush = autoFlush;
    }

    public void setMillisecBetweenHostCertRefresh(int ms) {
        this._hostCertRefreshInterval = ms;
    }

    public void setMillisecBetweenTrustAnchorRefresh(int ms) {
        this._trustAnchorRefreshInterval = ms;
    }
}

