/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.util;

import com.google.common.base.Preconditions;
import com.jolbox.bonecp.BoneCPDataSource;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Set;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcConnectionPool {
    private final String jdbcUrl;
    private final String jdbcClass;
    private final String user;
    private final String pass;
    private final DataSource dataSource;
    private static Logger _logSql = LoggerFactory.getLogger(JdbcConnectionPool.class);
    private static final Set<JdbcConnectionPool> pools = new HashSet<JdbcConnectionPool>();

    public static final synchronized DataSource getDataSource(String jdbcUrl, String jdbcClass, String user, String pass) throws SQLException {
        return JdbcConnectionPool.getPool((String)jdbcUrl, (String)jdbcClass, (String)user, (String)pass).dataSource;
    }

    public static final synchronized JdbcConnectionPool getPool(String jdbcUrl, String jdbcClass, String user, String pass) throws SQLException {
        if (pass == null) {
            pass = "";
        }
        long starttimestamp = System.currentTimeMillis();
        for (JdbcConnectionPool pool : pools) {
            if (!pool.jdbcClass.equals(jdbcClass) || !pool.jdbcUrl.equals(jdbcUrl) || !pool.pass.equals(pass) || !pool.user.equals(user)) continue;
            return pool;
        }
        JdbcConnectionPool pool = new JdbcConnectionPool(jdbcUrl, jdbcClass, user, pass);
        pools.add(pool);
        long elapsed = System.currentTimeMillis() - starttimestamp;
        if (_logSql.isDebugEnabled()) {
            _logSql.debug("getPool() took " + elapsed + " ms");
        }
        return pool;
    }

    protected JdbcConnectionPool(String jdbcUrl, String jdbcClass, String user, String pass) throws SQLException {
        Preconditions.checkNotNull((Object)jdbcUrl);
        Preconditions.checkNotNull((Object)jdbcClass);
        Preconditions.checkNotNull((Object)user);
        Preconditions.checkNotNull((Object)pass);
        try {
            Class.forName(jdbcClass);
        }
        catch (ClassNotFoundException e) {
            throw new SQLException("can not initialize jdbc driver : " + jdbcClass);
        }
        this.jdbcUrl = jdbcUrl;
        this.jdbcClass = jdbcClass;
        this.user = user;
        this.pass = pass;
        BoneCPDataSource ds = new BoneCPDataSource();
        ds.setJdbcUrl(jdbcUrl);
        ds.setUsername(user);
        ds.setPassword(pass);
        ds.setIdleConnectionTestPeriodInMinutes(60L);
        ds.setIdleMaxAgeInMinutes(240L);
        ds.setMaxConnectionsPerPartition(30);
        ds.setMaxConnectionsPerPartition(10);
        ds.setPartitionCount(3);
        ds.setAcquireIncrement(5);
        ds.setStatementsCacheSize(100);
        ds.setReleaseHelperThreads(3);
        this.dataSource = ds;
    }

    public Connection getConnection() throws SQLException {
        Connection con = this.dataSource.getConnection();
        con.setAutoCommit(false);
        return con;
    }

    public void returnFailedConnection(Connection con) {
        try {
            con.rollback();
        }
        catch (SQLException e) {
            // empty catch block
        }
        try {
            con.close();
        }
        catch (SQLException e) {
            _logSql.debug("returnFailedConnection() exception: ", (Throwable)e);
        }
    }

    public void returnConnection(Connection con) {
        try {
            con.commit();
        }
        catch (SQLException e) {
            // empty catch block
        }
        try {
            con.close();
        }
        catch (SQLException e) {
            _logSql.debug("returnConnection() exception: ", (Throwable)e);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof JdbcConnectionPool)) {
            return false;
        }
        JdbcConnectionPool pool = (JdbcConnectionPool)o;
        return pool.jdbcClass.equals(this.jdbcClass) && pool.jdbcUrl.equals(this.jdbcUrl) && pool.pass.equals(this.pass) && pool.user.equals(this.user);
    }

    public int hashCode() {
        return this.jdbcClass.hashCode() ^ this.jdbcUrl.hashCode() ^ this.pass.hashCode() ^ this.user.hashCode();
    }
}

