/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.util;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import org.dcache.util.SimpleGSIEngine;
import org.eclipse.jetty.io.Buffer;
import org.eclipse.jetty.io.Buffers;
import org.eclipse.jetty.io.EofException;
import org.eclipse.jetty.io.nio.NIOBuffer;
import org.eclipse.jetty.io.nio.SelectChannelEndPoint;
import org.eclipse.jetty.io.nio.SelectorManager;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GSISelectChannelEndPoint
extends SelectChannelEndPoint {
    private static final Logger _logger = LoggerFactory.getLogger(GSISelectChannelEndPoint.class);
    private final Buffers _buffers;
    private SimpleGSIEngine _engine;
    private volatile NIOBuffer _inNIOBuffer;
    private volatile NIOBuffer _outNIOBuffer;
    private volatile boolean _closing = false;

    public GSISelectChannelEndPoint(Buffers buffers, SocketChannel channel, SelectorManager.SelectSet selectSet, SelectionKey key, GSSContext context) throws IOException {
        super(channel, selectSet, key);
        this._engine = new SimpleGSIEngine(context);
        this._buffers = buffers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int fill(Buffer buffer) throws IOException {
        ByteBuffer byteBuffer = this.extractInputBuffer(buffer);
        int totalFilled = 0;
        ByteBuffer byteBuffer2 = byteBuffer;
        synchronized (byteBuffer2) {
            int originalLength = buffer.length();
            this.needInBuffer();
            try {
                while (true) {
                    SimpleGSIEngine.GSIEngineResult result;
                    int filled = 0;
                    if (this._inNIOBuffer.space() > 0) {
                        filled = this.fillWithEncryptedBytes();
                        if (!this._inNIOBuffer.hasContent()) return buffer.length() - originalLength;
                    }
                    ByteBuffer inBuffer = this._inNIOBuffer.getByteBuffer();
                    inBuffer.position(this._inNIOBuffer.getIndex());
                    inBuffer.limit(this._inNIOBuffer.putIndex());
                    switch (this._engine.getHandshakeStatus()) {
                        case CH_ESTABLISHED: {
                            result = this._engine.unwrap(inBuffer, byteBuffer);
                            break;
                        }
                        case CH_INITIAL: 
                        case CH_NOTDONEYET: {
                            this.needOutBuffer(inBuffer.capacity() * 2);
                            ByteBuffer outBuffer = this._outNIOBuffer.getByteBuffer();
                            result = this._engine.handshake(inBuffer, outBuffer);
                            this._outNIOBuffer.setGetIndex(0);
                            this._outNIOBuffer.setPutIndex(result.getBytesProduced());
                            this.flush();
                            this.freeOutBuffer();
                            break;
                        }
                        case CH_CLOSED: {
                            this._closing = true;
                            return buffer.length() - originalLength;
                        }
                        default: {
                            throw new IllegalStateException("Unknown handshake status " + (Object)((Object)this._engine.getHandshakeStatus()));
                        }
                    }
                    this._inNIOBuffer.setGetIndex(inBuffer.position());
                    inBuffer.clear();
                    switch (result.getStatus()) {
                        case BUFFER_UNDERFLOW: {
                            if (filled == 0) {
                                return buffer.length() - originalLength;
                            } else {
                                if (this.isOpen()) break;
                                _logger.warn("Received incomplete SSL request and channel is closed. Can not proceed.");
                                inBuffer.clear();
                                this._inNIOBuffer.clear();
                                if (this._outNIOBuffer == null) throw new EofException("Incomplete GSI request and connection is closed!");
                                this._outNIOBuffer.clear();
                                throw new EofException("Incomplete GSI request and connection is closed!");
                            }
                        }
                        case BUFFER_OVERFLOW: {
                            _logger.warn("Buffer overflow occurred when reading SSL package!");
                            throw new IOException("Problem writing back SSL package to the channel!");
                        }
                        case CLOSED: {
                            this._closing = true;
                        }
                    }
                }
            }
            catch (GSSException gssex) {
                _logger.error("Got a GSSException while filling the buffer: {}", (Object)gssex.getMessage());
                throw new IOException("Connection down due to GSSException", gssex);
            }
            finally {
                buffer.setPutIndex(byteBuffer.position());
                byteBuffer.position(0);
                this.freeInBuffer();
            }
        }
    }

    private synchronized void needOutBuffer(int size) {
        if (this._outNIOBuffer == null || this._outNIOBuffer.capacity() < size) {
            this._outNIOBuffer = null;
            _logger.debug("Getting an output buffer with size {}", (Object)size);
            this._outNIOBuffer = (NIOBuffer)this._buffers.getBuffer(size);
        }
    }

    private synchronized void needInBuffer() {
        if (this._inNIOBuffer == null) {
            this._inNIOBuffer = (NIOBuffer)this._buffers.getBuffer();
        }
    }

    public boolean isBufferingOutput() {
        NIOBuffer b = this._outNIOBuffer;
        return b == null ? false : b.hasContent();
    }

    /*
     * Unable to fully structure code
     */
    public int flush(Buffer header, Buffer buffer, Buffer trailer) throws IOException {
        block25: {
            consumed = 0;
            v0 = available = header == null ? 0 : header.length();
            if (buffer != null) {
                available += buffer.length();
            }
            outBufferSize = available + (trailer == null ? 0 : trailer.length());
            this.needOutBuffer(outBufferSize *= 2);
            try {
                block13: while (true) {
                    if (this._outNIOBuffer.length() > 0) {
                        this.flush();
                        if (this.isBufferingOutput()) break;
                    }
                    switch (1.$SwitchMap$org$dcache$util$SimpleGSIEngine$HandshakeStatus[this._engine.getHandshakeStatus().ordinal()]) {
                        case 2: 
                        case 3: {
                            this.needInBuffer();
                            outBuffer = this._outNIOBuffer.getByteBuffer();
                            inBuffer = this._inNIOBuffer.getByteBuffer();
                            result = this._engine.handshake(inBuffer, outBuffer);
                            GSISelectChannelEndPoint._logger.debug("handshake wrote {} bytes into the outbuffer", (Object)result.getBytesProduced());
                            switch (1.$SwitchMap$org$dcache$util$SimpleGSIEngine$ResultStatus[result.getStatus().ordinal()]) {
                                case 4: {
                                    this._inNIOBuffer.setGetIndex(inBuffer.position());
                                    this._outNIOBuffer.setGetIndex(0);
                                    this._outNIOBuffer.setPutIndex(result.getBytesProduced());
                                    inBuffer.clear();
                                    this.flush();
                                    this.freeInBuffer();
                                    break;
                                }
                                case 1: {
                                    this.freeInBuffer();
                                    break block13;
                                }
                                case 2: {
                                    this.freeInBuffer();
                                    throw new IOException("Problem writing back SSL handshake package to the channel!");
                                }
                                case 3: {
                                    this.freeInBuffer();
                                    this._closing = true;
                                    break block13;
                                }
                            }
                            ** GOTO lbl67
                        }
                        case 1: {
                            c = 0;
                            if (header != null && header.length() > 0) {
                                if (buffer != null && buffer.length() > 0) {
                                    c = this.wrap(header);
                                    this.flush();
                                    c += this.wrap(buffer);
                                } else {
                                    c = this.wrap(header);
                                }
                            } else if (buffer != null && buffer.length() > 0) {
                                c = this.wrap(buffer);
                            }
                            GSISelectChannelEndPoint._logger.debug("Wrapping body consumed {} bytes", (Object)c);
                            if (c <= 0) ** GOTO lbl57
                            consumed += c;
                            available -= c;
                            ** GOTO lbl67
lbl57:
                            // 1 sources

                            if (consumed == 0) {
                                consumed = -1;
                                break block13;
                            }
                            break block25;
                        }
                        case 4: {
                            if (this._closing || available == 0) {
                                if (consumed == 0) {
                                    consumed = -1;
                                    break block13;
                                }
                                break block25;
                            }
                        }
lbl67:
                        // 5 sources

                        default: {
                            this.flush();
                            if (!this.isBufferingOutput()) continue block13;
                            break block13;
                        }
                    }
                    break;
                }
            }
            catch (GSSException gssex) {
                GSISelectChannelEndPoint._logger.error("Got a GSSException while flushing the buffer: {}", (Object)gssex.getMessage());
                throw new IOException("Connection down due to GSSException.", gssex);
            }
        }
        if (this._outNIOBuffer != null) {
            this.freeOutBuffer();
        }
        return consumed;
    }

    public int flush(Buffer buffer) throws IOException {
        return this.flush(buffer, null, null);
    }

    private int fillWithEncryptedBytes() throws IOException {
        if (this._inNIOBuffer.hasContent()) {
            this._inNIOBuffer.compact();
        } else {
            this._inNIOBuffer.clear();
        }
        int totalFilled = 0;
        int lengthBeforeFill = this._inNIOBuffer.length();
        while (this._inNIOBuffer.space() > 0 && this.isOpen()) {
            try {
                int filled = super.fill((Buffer)this._inNIOBuffer);
                _logger.debug("Filled buffer with {} bytes from network", (Object)filled);
                if (filled <= 0) break;
                totalFilled += filled;
            }
            catch (IOException e) {
                if (this._inNIOBuffer.length() != lengthBeforeFill) break;
                if (this._outNIOBuffer != null) {
                    this._outNIOBuffer.clear();
                    this.freeOutBuffer();
                }
                throw e;
            }
        }
        if (totalFilled == 0 && this._inNIOBuffer.length() == lengthBeforeFill) {
            if (!this.isOpen()) {
                if (this._outNIOBuffer != null) {
                    this.freeOutBuffer();
                }
                throw new EofException();
            }
            return -1;
        }
        return totalFilled;
    }

    private ByteBuffer extractInputBuffer(Buffer buffer) throws IOException {
        if (!(buffer instanceof NIOBuffer)) {
            throw new IOException("Error extracting the input buffer!");
        }
        NIOBuffer nbuf = (NIOBuffer)buffer;
        ByteBuffer bbuf = nbuf.getByteBuffer();
        bbuf.position(buffer.putIndex());
        return bbuf;
    }

    private ByteBuffer extractOutputBuffer(Buffer buffer) {
        if (buffer.buffer() instanceof NIOBuffer) {
            return ((NIOBuffer)buffer.buffer()).getByteBuffer();
        }
        return ByteBuffer.wrap(buffer.array());
    }

    private synchronized void freeOutBuffer() {
        if (!this.isBufferingOutput()) {
            this._buffers.returnBuffer((Buffer)this._outNIOBuffer);
            this._outNIOBuffer = null;
        }
    }

    private synchronized void freeInBuffer() {
        this._buffers.returnBuffer((Buffer)this._inNIOBuffer);
        this._inNIOBuffer = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private int wrap(Buffer buffer) throws IOException, GSSException {
        ByteBuffer outBuffer;
        ByteBuffer byteBuffer;
        ByteBuffer byteBuffer2 = byteBuffer = this.extractOutputBuffer(buffer);
        // MONITORENTER : byteBuffer2
        byteBuffer.position(buffer.getIndex());
        byteBuffer.limit(buffer.putIndex());
        int consumed = 0;
        ByteBuffer byteBuffer3 = outBuffer = this._outNIOBuffer.getByteBuffer();
        // MONITORENTER : byteBuffer3
        try {
            this._outNIOBuffer.clear();
            outBuffer.position(0);
            outBuffer.limit(outBuffer.capacity());
            SimpleGSIEngine.GSIEngineResult result = this._engine.wrap(byteBuffer, outBuffer);
            switch (result.getStatus()) {
                case OK: {
                    this._outNIOBuffer.setGetIndex(0);
                    this._outNIOBuffer.setPutIndex(result.getBytesProduced());
                    consumed = result.getBytesConsumed();
                    return consumed;
                }
                case BUFFER_UNDERFLOW: {
                    return consumed;
                }
                case BUFFER_OVERFLOW: {
                    _logger.warn("Could not flush SSL packet due to a buffer overflow.Bytes consumed: " + result.getBytesConsumed() + ", bytes written: " + result.getBytesProduced());
                    throw new IOException("Tried to write a too large packet. Seems like a bug.");
                }
                case CLOSED: {
                    this._closing = true;
                    return consumed;
                }
            }
            return consumed;
        }
        finally {
            outBuffer.position(0);
            buffer.setGetIndex(byteBuffer.position());
            byteBuffer.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private int wrap(Buffer header, Buffer body) throws IOException, GSSException {
        ByteBuffer outBuffer;
        ByteBuffer byteBuffer;
        ByteBuffer headerBuffer;
        int consumed = 0;
        ByteBuffer byteBuffer2 = headerBuffer = this.extractOutputBuffer(header);
        // MONITORENTER : byteBuffer2
        headerBuffer.position(header.getIndex());
        headerBuffer.limit(header.putIndex());
        ByteBuffer byteBuffer3 = byteBuffer = this.extractOutputBuffer(body);
        // MONITORENTER : byteBuffer3
        byteBuffer.position(body.getIndex());
        byteBuffer.limit(body.putIndex());
        ByteBuffer byteBuffer4 = outBuffer = this._outNIOBuffer.getByteBuffer();
        // MONITORENTER : byteBuffer4
        try {
            this._outNIOBuffer.clear();
            outBuffer.position(0);
            outBuffer.limit(outBuffer.capacity());
            SimpleGSIEngine.GSIEngineResult result1 = this._engine.wrap(headerBuffer, outBuffer);
            SimpleGSIEngine.GSIEngineResult result2 = null;
            int bytesProduced = 0;
            if (result1.getStatus() == SimpleGSIEngine.ResultStatus.OK) {
                bytesProduced = result1.getBytesProduced();
                consumed += result1.getBytesConsumed();
                result2 = this._engine.wrap(byteBuffer, outBuffer);
            }
            SimpleGSIEngine.GSIEngineResult lastResult = result2 == null ? result1 : result2;
            switch (lastResult.getStatus()) {
                case OK: {
                    this._outNIOBuffer.setGetIndex(0);
                    this._outNIOBuffer.setPutIndex(bytesProduced += lastResult.getBytesProduced());
                    return consumed += lastResult.getBytesConsumed();
                }
                case BUFFER_OVERFLOW: {
                    _logger.warn("Could not flush SSL packet due to a buffer overflow.Bytes consumed: " + lastResult.getBytesConsumed() + ", bytes written: " + lastResult.getBytesProduced());
                    throw new IOException("Tried to write a too large packet. Seems like a bug.");
                }
                case BUFFER_UNDERFLOW: {
                    return consumed;
                }
                case CLOSED: {
                    this._closing = true;
                    return consumed;
                }
            }
            return consumed;
        }
        finally {
            outBuffer.position(0);
            header.setGetIndex(headerBuffer.position());
            headerBuffer.clear();
            body.setGetIndex(byteBuffer.position());
            byteBuffer.clear();
        }
    }

    public void flush() throws IOException {
        if (this._outNIOBuffer == null) {
            return;
        }
        if (this.isBufferingOutput()) {
            int flushed = super.flush((Buffer)this._outNIOBuffer);
            if (this.isBufferingOutput()) {
                Thread.yield();
                flushed += super.flush((Buffer)this._outNIOBuffer);
            }
            _logger.debug("Flushed {} bytes.", (Object)flushed);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        this._closing = true;
        try {
            long end = System.currentTimeMillis() + (long)((SocketChannel)this._channel).socket().getSoTimeout();
            while (this.isOpen() && System.currentTimeMillis() < end) {
                if (this.isBufferingOutput()) {
                    this.flush();
                } else {
                    if (this._engine.getHandshakeStatus() == SimpleGSIEngine.HandshakeStatus.CH_CLOSED) break;
                    this._engine.close();
                }
                Thread.sleep(100L);
            }
        }
        catch (GSSException gssex) {
            _logger.error("Could not close engine context due to: {}.", (Throwable)gssex);
        }
        catch (InterruptedException e) {
            _logger.warn("Loop waiting for channel close was interrupted.");
        }
        finally {
            _logger.debug("Closing the GSI channel finished, calling close() on super-class");
            super.close();
        }
    }

    public GSSContext getContext() {
        return this._engine.getContext();
    }
}

