/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.util;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import dmg.util.Formats;
import dmg.util.PropertiesBackedReplaceable;
import dmg.util.Replaceable;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.LineNumberReader;
import java.io.Reader;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.InvalidPropertiesFormatException;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationProperties
extends Properties {
    private static final long serialVersionUID = -5684848160314570455L;
    private static final String STORAGE_PREFIX_ANNOTATIONS = "<A>";
    private static final String STORAGE_PREFIX_ERROR_MSG = "<E>";
    private static final Pattern SINGLE_PROPERTY_EXPANSION = Pattern.compile("^\\$\\{([^}]+)\\}");
    private static final EnumSet<Annotation> OBSOLETE_FORBIDDEN = EnumSet.of(Annotation.OBSOLETE, Annotation.FORBIDDEN);
    private static final Logger _log = LoggerFactory.getLogger(ConfigurationProperties.class);
    private final PropertiesBackedReplaceable _replaceable = new PropertiesBackedReplaceable((Properties)this);
    private boolean _loading = false;
    private boolean _isService = false;
    private ProblemConsumer _problemConsumer = new DefaultProblemConsumer();

    public ConfigurationProperties() {
    }

    public ConfigurationProperties(Properties defaults) {
        super(defaults);
        if (defaults instanceof ConfigurationProperties) {
            this._problemConsumer = ((ConfigurationProperties)defaults)._problemConsumer;
        }
    }

    public void setProblemConsumer(ProblemConsumer consumer) {
        this._problemConsumer = consumer;
    }

    public ProblemConsumer getProblemConsumer() {
        return this._problemConsumer;
    }

    public void setIsService(boolean isService) {
        this._isService = isService;
    }

    public AnnotatedKey getAnnotatedKey(String name) {
        AnnotatedKey key;
        String annotations = this.getProperty(STORAGE_PREFIX_ANNOTATIONS + name);
        if (annotations != null) {
            String error = this.getProperty(STORAGE_PREFIX_ERROR_MSG + name);
            key = new AnnotatedKey(name, annotations, error);
        } else {
            key = new AnnotatedKey(name, "");
        }
        return key;
    }

    public static boolean isScoped(String name) {
        return name.indexOf(47) > -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void load(Reader reader) throws IOException {
        this._loading = true;
        try {
            super.load(reader);
        }
        finally {
            this._loading = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void load(InputStream in) throws IOException {
        this._loading = true;
        try {
            super.load(in);
        }
        finally {
            this._loading = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void loadFromXML(InputStream in) throws IOException, InvalidPropertiesFormatException {
        this._loading = true;
        try {
            super.loadFromXML(in);
        }
        finally {
            this._loading = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadFile(File file) throws IOException {
        FileReader reader = new FileReader(file);
        try {
            this.load(file.getName(), 0, reader);
        }
        finally {
            ((Reader)reader).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(String source, int line, Reader reader) throws IOException {
        LineNumberReader lnr = new LineNumberReader(reader);
        lnr.setLineNumber(line);
        this._problemConsumer.setFilename(source);
        this._problemConsumer.setLineNumberReader(lnr);
        try {
            this.load(new ConfigurationParserAwareReader(lnr));
        }
        finally {
            this._problemConsumer.setFilename(null);
        }
    }

    @Override
    public synchronized Object put(Object rawKey, Object value) {
        Preconditions.checkNotNull((Object)rawKey, (Object)"A propery key must not be null");
        Preconditions.checkNotNull((Object)value, (Object)"A propery value must not be null");
        AnnotatedKey key = new AnnotatedKey(rawKey, value);
        String name = key.getPropertyName();
        if (this._loading && this.containsKey(name)) {
            this._problemConsumer.error(name + " is already defined");
            return null;
        }
        this.checkIsAllowed(key, (String)value);
        if (key.hasAnnotations()) {
            this.store(key);
        }
        return key.hasAnyOf(OBSOLETE_FORBIDDEN) ? null : super.put(name, value);
    }

    protected void checkIsAllowed(AnnotatedKey key, String value) {
        String name = key.getPropertyName();
        AnnotatedKey existingKey = this.getAnnotatedKey(name);
        this.checkKeyValid(existingKey, key);
        this.checkDataValid(key, value);
        this.checkDataValid(existingKey, value);
    }

    private void checkKeyValid(AnnotatedKey existingKey, AnnotatedKey key) {
        String name = key.getPropertyName();
        if (existingKey.hasAnnotations() && key.hasAnnotations()) {
            this._problemConsumer.error("Property " + name + ": " + "remove \"" + key.getAnnotationDeclaration() + "\"; " + "annotated assignments are not allowed");
        }
        if (existingKey.hasAnnotation(Annotation.IMMUTABLE)) {
            this._problemConsumer.error(this.immutableErrorMessageFor(existingKey));
        }
        if (existingKey.hasAnnotation(Annotation.FORBIDDEN)) {
            this._problemConsumer.error(this.forbiddenErrorMessageFor(existingKey));
        }
        if (existingKey.hasAnnotation(Annotation.OBSOLETE)) {
            this._problemConsumer.warning(this.obsoleteErrorMessageFor(existingKey));
        }
        if (existingKey.hasAnnotation(Annotation.DEPRECATED)) {
            this._problemConsumer.warning("Property " + name + ": " + this.deprecatedWarningInstructionsFor(name) + "; support for " + name + " will be removed in the future");
        }
        if (this._isService && existingKey.hasAnnotation(Annotation.NOT_FOR_SERVICES)) {
            this._problemConsumer.warning("Property " + name + ": consider moving to a domain scope; it has no effect here");
        }
    }

    private void checkDataValid(AnnotatedKey key, String value) {
        String oneOfParameter;
        ImmutableSet validValues;
        if (key.hasAnnotation(Annotation.ONE_OF) && !(validValues = ImmutableSet.copyOf((Object[])(oneOfParameter = key.getParameter(Annotation.ONE_OF)).split("\\|"))).contains(value)) {
            String validValuesList = "\"" + Joiner.on((String)"\", \"").join((Iterable)validValues) + "\"";
            this._problemConsumer.error("Property " + key.getPropertyName() + ": \"" + value + "\" is not a valid value.  Must be one of " + validValuesList);
        }
    }

    private String deprecatedWarningInstructionsFor(String propertyName) {
        String synonym = this.findSynonymOf(propertyName);
        if (synonym != null) {
            return "use \"" + synonym + "\" instead";
        }
        return "please review configuration";
    }

    private String findSynonymOf(String propertyName) {
        String propertyValue = this.getProperty(propertyName);
        Matcher m = SINGLE_PROPERTY_EXPANSION.matcher(propertyValue);
        if (m.matches()) {
            return m.group(1);
        }
        String synonym = null;
        String simpleReference = "${" + propertyName + "}";
        for (String name : this.stringPropertyNames()) {
            String value = this.getProperty(name);
            if (!value.equals(simpleReference)) continue;
            if (synonym != null) {
                return null;
            }
            synonym = name;
        }
        return synonym;
    }

    private String forbiddenErrorMessageFor(AnnotatedKey key) {
        String customError = key.getError();
        String suffix = customError.isEmpty() ? "this property no longer affects dCache" : customError;
        return "Property " + key.getPropertyName() + ": may not be adjusted; " + suffix;
    }

    private String immutableErrorMessageFor(AnnotatedKey key) {
        return "Property " + key.getPropertyName() + ": may not be adjusted as it is marked 'immutable'";
    }

    private String obsoleteErrorMessageFor(AnnotatedKey key) {
        String customError = key.getError();
        String suffix = customError.isEmpty() ? "it has no effect" : customError;
        return "Property " + key.getPropertyName() + ": please remove this assignment; " + suffix;
    }

    @Override
    public synchronized Enumeration<?> propertyNames() {
        return Collections.enumeration(this.stringPropertyNames());
    }

    @Override
    public synchronized Set<String> stringPropertyNames() {
        HashSet<String> names = new HashSet<String>();
        for (String name : super.stringPropertyNames()) {
            if (name.startsWith(STORAGE_PREFIX_ANNOTATIONS) || name.startsWith(STORAGE_PREFIX_ERROR_MSG)) continue;
            names.add(name);
        }
        return names;
    }

    public String replaceKeywords(String s) {
        return Formats.replaceKeywords((String)s, (Replaceable)this._replaceable);
    }

    public String getValue(String name) {
        String value = this.getProperty(name);
        return value == null ? null : this.replaceKeywords(value);
    }

    private void store(AnnotatedKey key) {
        String name = key.getPropertyName();
        this.setProperty(STORAGE_PREFIX_ANNOTATIONS + name, key.getAnnotationDeclaration());
        this.setProperty(STORAGE_PREFIX_ERROR_MSG + name, key.getError());
    }

    public static class ConfigurationParserAwareReader
    extends Reader {
        private final BufferedReader _inner;
        private boolean _shouldInjectBlankLine;
        private String _remaining = "";

        public ConfigurationParserAwareReader(BufferedReader reader) {
            this._inner = reader;
        }

        @Override
        public int read(char[] cbuf, int off, int len) throws IOException {
            String data = this.getDataForParser();
            if (data == null) {
                return -1;
            }
            int count = Math.min(len, data.length());
            System.arraycopy(data.toCharArray(), 0, cbuf, off, count);
            this._remaining = data.substring(count);
            if (this._remaining.isEmpty()) {
                this._shouldInjectBlankLine = this._shouldInjectBlankLine ? false : !data.endsWith("\\\n");
            }
            return count;
        }

        private String getDataForParser() throws IOException {
            if (!this._remaining.isEmpty()) {
                return this._remaining;
            }
            if (this._shouldInjectBlankLine) {
                return "\n";
            }
            String data = this._inner.readLine();
            return data == null ? null : data + "\n";
        }

        @Override
        public void close() throws IOException {
            this._inner.close();
        }
    }

    public static class DefaultProblemConsumer
    implements ProblemConsumer {
        private String _filename;
        private LineNumberReader _reader;

        protected String addContextTo(String message) {
            if (this._filename == null || this._reader == null) {
                return message;
            }
            return this._filename + ":" + this._reader.getLineNumber() + ": " + message;
        }

        @Override
        public void error(String message) {
            throw new IllegalArgumentException(this.addContextTo(message));
        }

        @Override
        public void warning(String message) {
            _log.warn(this.addContextTo(message));
        }

        @Override
        public void setFilename(String name) {
            this._filename = name;
        }

        @Override
        public void setLineNumberReader(LineNumberReader reader) {
            this._reader = reader;
        }
    }

    public static interface ProblemConsumer {
        public void setFilename(String var1);

        public void setLineNumberReader(LineNumberReader var1);

        public void error(String var1);

        public void warning(String var1);
    }

    public static enum Annotation {
        FORBIDDEN("forbidden"),
        OBSOLETE("obsolete"),
        ONE_OF("one-of", true),
        DEPRECATED("deprecated"),
        NOT_FOR_SERVICES("not-for-services"),
        IMMUTABLE("immutable");

        private static final Map<String, Annotation> ANNOTATION_LABELS;
        private final String _label;
        private final boolean _isParameterRequired;

        public static Annotation forLabel(String label) {
            Preconditions.checkArgument((boolean)ANNOTATION_LABELS.containsKey(label), (Object)("Unknown annotation: " + label));
            return ANNOTATION_LABELS.get(label);
        }

        private Annotation(String label) {
            this(label, false);
        }

        private Annotation(String label, boolean isParameterRequired) {
            this._label = label;
            this._isParameterRequired = isParameterRequired;
        }

        public boolean isParameterRequired() {
            return this._isParameterRequired;
        }

        static {
            ANNOTATION_LABELS = new HashMap<String, Annotation>();
            for (Annotation annotation : Annotation.values()) {
                ANNOTATION_LABELS.put(annotation._label, annotation);
            }
        }
    }

    public static class AnnotatedKey {
        private static final String RE_ATTRIBUTE = "[^),]+";
        private static final String RE_SEPARATOR = ",";
        private static final String RE_ANNOTATION_DECLARATION = "(\\(([^),]+(?:,[^),]+)*)\\))";
        private static final String RE_KEY_DECLARATION = "(\\(([^),]+(?:,[^),]+)*)\\))(.*)";
        private static final Pattern PATTERN_ANNOTATION_DECLARATION = Pattern.compile("(\\(([^),]+(?:,[^),]+)*)\\))");
        private static final Pattern PATTERN_KEY_DECLARATION = Pattern.compile("(\\(([^),]+(?:,[^),]+)*)\\))(.*)");
        private static final Pattern PATTERN_SEPARATOR = Pattern.compile(",");
        private static final Set<Annotation> FORBIDDEN_OBSOLETE_DEPRECATED = EnumSet.of(Annotation.FORBIDDEN, Annotation.OBSOLETE, Annotation.DEPRECATED);
        private static final EnumSet<Annotation> FORBIDDEN_OBSOLETE = EnumSet.of(Annotation.FORBIDDEN, Annotation.OBSOLETE);
        private final String _name;
        private final String _annotationDeclaration;
        private final Map<Annotation, String> _annotations = new EnumMap<Annotation, String>(Annotation.class);
        private final String _error;

        public AnnotatedKey(String name, String annotationDeclaration, String error) {
            this._name = name;
            this._error = error;
            this._annotationDeclaration = annotationDeclaration;
            Matcher m = PATTERN_ANNOTATION_DECLARATION.matcher(annotationDeclaration);
            if (!m.matches()) {
                throw new IllegalStateException("Cannot match stored annotation declaration");
            }
            for (String annotation : PATTERN_SEPARATOR.split(m.group(2))) {
                this.addAnnotation(annotation);
            }
        }

        public AnnotatedKey(Object propertyKey, Object propertyValue) {
            String key = propertyKey.toString();
            Matcher m = PATTERN_KEY_DECLARATION.matcher(key);
            if (m.matches()) {
                this._annotationDeclaration = m.group(1);
                for (String annotation : PATTERN_SEPARATOR.split(m.group(2))) {
                    this.addAnnotation(annotation);
                }
                this._name = m.group(3);
                if (this.countDeclaredAnnotationsFrom(FORBIDDEN_OBSOLETE_DEPRECATED) > 1) {
                    throw new IllegalArgumentException("At most one of forbidden, obsolete and deprecated may be specified.");
                }
            } else {
                this._annotationDeclaration = "";
                this._name = key;
            }
            this._error = this.hasAnyOf(FORBIDDEN_OBSOLETE) ? propertyValue.toString() : "";
        }

        private void addAnnotation(String declaration) {
            int idx = declaration.indexOf(63);
            String label = idx != -1 ? declaration.substring(0, idx) : declaration;
            Annotation annotation = Annotation.forLabel(label);
            Preconditions.checkArgument((!annotation.isParameterRequired() || idx != -1 ? 1 : 0) != 0, (Object)("Annotation " + label + " declared without parameter"));
            Preconditions.checkArgument((annotation.isParameterRequired() || idx == -1 ? 1 : 0) != 0, (Object)("Annotation " + label + " declared with parameter"));
            if (annotation.isParameterRequired()) {
                String parameter = declaration.substring(idx + 1, declaration.length());
                this._annotations.put(annotation, parameter);
            } else {
                this._annotations.put(annotation, null);
            }
        }

        private int countDeclaredAnnotationsFrom(Set<Annotation> items) {
            EnumSet<Annotation> a = EnumSet.copyOf(items);
            a.retainAll(this._annotations.keySet());
            return a.size();
        }

        public boolean hasAnnotation(Annotation annotation) {
            return this._annotations.keySet().contains((Object)annotation);
        }

        public final boolean hasAnyOf(EnumSet<Annotation> annotations) {
            return this.countDeclaredAnnotationsFrom(annotations) > 0;
        }

        public boolean hasAnnotations() {
            return !this._annotations.isEmpty();
        }

        public String getAnnotationDeclaration() {
            return this._annotationDeclaration;
        }

        public String getPropertyName() {
            return this._name;
        }

        public String getError() {
            return this._error;
        }

        public String getParameter(Annotation annotation) {
            String parameter = this._annotations.get((Object)annotation);
            if (parameter == null) {
                throw new IllegalArgumentException("No such annotation or annotation given without parameter: " + (Object)((Object)annotation));
            }
            return parameter;
        }
    }
}

