/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.util;

import diskCacheV111.util.CacheException;
import diskCacheV111.util.DiskErrorCacheException;
import diskCacheV111.util.FileExistsCacheException;
import diskCacheV111.util.FileNotFoundCacheException;
import diskCacheV111.util.FileNotInCacheException;
import diskCacheV111.util.FileNotOnlineCacheException;
import diskCacheV111.util.LockedCacheException;
import diskCacheV111.util.MissingResourceCacheException;
import diskCacheV111.util.NotDirCacheException;
import diskCacheV111.util.NotFileCacheException;
import diskCacheV111.util.NotInTrashCacheException;
import diskCacheV111.util.OutOfDateCacheException;
import diskCacheV111.util.PermissionDeniedCacheException;
import diskCacheV111.util.TimeoutCacheException;
import diskCacheV111.vehicles.Message;

public class CacheExceptionFactory {
    private CacheExceptionFactory() {
    }

    public static CacheException exceptionOf(int errorCode, String message) {
        switch (errorCode) {
            case 204: {
                return new DiskErrorCacheException(message);
            }
            case 10001: {
                return new FileNotFoundCacheException(message);
            }
            case 10019: {
                return new FileNotOnlineCacheException(message);
            }
            case 10007: {
                return new FileNotInCacheException(message);
            }
            case 10008: {
                return new FileExistsCacheException(message);
            }
            case 10010: {
                return new NotDirCacheException(message);
            }
            case 10014: {
                return new NotFileCacheException(message);
            }
            case 10017: {
                return new MissingResourceCacheException(message);
            }
            case 10018: {
                return new PermissionDeniedCacheException(message);
            }
            case 10020: {
                return new LockedCacheException(message);
            }
            case 10016: {
                return new NotInTrashCacheException(message);
            }
            case 10006: {
                return new TimeoutCacheException(message);
            }
            case 10021: {
                return new OutOfDateCacheException(message);
            }
        }
        return new CacheException(errorCode, message);
    }

    public static CacheException exceptionOf(Message message) {
        Object error = message.getErrorObject();
        if (error instanceof CacheException) {
            CacheException ce = (CacheException)error;
            return CacheExceptionFactory.exceptionOf(ce.getRc(), ce.getMessage());
        }
        return CacheExceptionFactory.exceptionOf(message.getReturnCode(), String.valueOf(error));
    }
}

