/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.util;

import dmg.cells.nucleus.CellEndpoint;
import dmg.cells.nucleus.CellMessage;
import dmg.cells.nucleus.CellPath;
import dmg.cells.nucleus.NoRouteToCellException;
import dmg.cells.services.multicaster.BroadcastRegisterMessage;
import dmg.cells.services.multicaster.BroadcastUnregisterMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BroadcastRegistrationTask
implements Runnable {
    private final CellEndpoint _cellEndpoint;
    private final String _eventClass;
    private final CellPath _target;
    private static CellPath _broadcast = new CellPath("broadcast");
    private static final Logger _logger = LoggerFactory.getLogger(BroadcastRegistrationTask.class);

    public BroadcastRegistrationTask(CellEndpoint cellEndpoint, Class<?> eventClass, CellPath target) {
        this._cellEndpoint = cellEndpoint;
        this._eventClass = eventClass.getName();
        this._target = target;
    }

    @Override
    public void run() {
        this.register();
    }

    public void register() {
        try {
            BroadcastRegisterMessage message = new BroadcastRegisterMessage(this._eventClass, this._target);
            this._cellEndpoint.sendMessage(new CellMessage(_broadcast, (Object)message));
        }
        catch (NoRouteToCellException e) {
            _logger.error("Failed to register with broadcast cell: No route to cell");
        }
    }

    public void unregister() {
        try {
            BroadcastUnregisterMessage message = new BroadcastUnregisterMessage(this._eventClass, this._target);
            this._cellEndpoint.sendMessage(new CellMessage(_broadcast, (Object)message));
        }
        catch (NoRouteToCellException e) {
            _logger.error("Failed to register with broadcast cell: No route to cell");
        }
    }
}

