/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.util;

public class Booleans {
    private static final String[] trueStrings = new String[]{"true", "yes", "on", "enable"};
    private static final String[] falseStrings = new String[]{"false", "no", "off", "disable"};

    private Booleans() {
    }

    public static String toYesNoString(boolean value) {
        return Booleans.toPredefinedString(value, "yes", "no");
    }

    public static String toOnOffString(boolean value) {
        return Booleans.toPredefinedString(value, "on", "off");
    }

    public static String toTrueFalseString(boolean value) {
        return Booleans.toPredefinedString(value, "true", "false");
    }

    public static String toEnableDisableString(boolean value) {
        return Booleans.toPredefinedString(value, "enable", "disable");
    }

    public static String toPredefinedString(boolean value, String ifTrue, String ifFalse) {
        return value ? ifTrue : ifFalse;
    }

    public static boolean of(String s) {
        if (Booleans.contains(trueStrings, s, true)) {
            return true;
        }
        if (Booleans.contains(falseStrings, s, true)) {
            return false;
        }
        throw new IllegalArgumentException();
    }

    public static boolean of(String s, boolean defaultValue) {
        if (s == null) {
            return defaultValue;
        }
        if (Booleans.contains(trueStrings, s, true)) {
            return true;
        }
        if (Booleans.contains(falseStrings, s, true)) {
            return false;
        }
        throw new IllegalArgumentException(s + " is not in supported boolean identifier");
    }

    private static boolean contains(String[] array, String value, boolean ignoreCase) {
        for (String s : array) {
            if ((!ignoreCase || !s.equalsIgnoreCase(value)) && !s.equals(value)) continue;
            return true;
        }
        return false;
    }
}

