/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.util;

import java.util.concurrent.Semaphore;

public final class AdjustableSemaphore {
    private final ResizeableSemaphore semaphore = new ResizeableSemaphore();
    private int maxPermits = 0;

    public synchronized void setMaxPermits(int newMax) {
        if (newMax < 1) {
            throw new IllegalArgumentException("Semaphore size must be at least 1, was " + newMax);
        }
        int delta = newMax - this.maxPermits;
        if (delta == 0) {
            return;
        }
        if (delta > 0) {
            this.semaphore.release(delta);
        } else {
            this.semaphore.reducePermits(delta *= -1);
        }
        this.maxPermits = newMax;
    }

    public void release() {
        this.semaphore.release();
    }

    public void acquire() throws InterruptedException {
        this.semaphore.acquire();
    }

    public boolean tryAcquire() {
        return this.semaphore.tryAcquire();
    }

    public synchronized int getMaxPermits() {
        return this.maxPermits;
    }

    public synchronized int getUsedPermits() {
        return this.maxPermits - this.semaphore.availablePermits();
    }

    private static final class ResizeableSemaphore
    extends Semaphore {
        private static final long serialVersionUID = 1L;

        ResizeableSemaphore() {
            super(0);
        }

        @Override
        protected void reducePermits(int reduction) {
            super.reducePermits(reduction);
        }
    }
}

