/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.services.topology;

import diskCacheV111.util.CacheException;
import dmg.cells.network.CellDomainNode;
import dmg.cells.nucleus.CellPath;
import dmg.cells.nucleus.CellTunnelInfo;
import java.io.Serializable;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dcache.cells.AbstractCellComponent;
import org.dcache.cells.CellStub;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractCellsTopology
extends AbstractCellComponent {
    private static final Logger _log = LoggerFactory.getLogger(AbstractCellsTopology.class);
    private CellStub _stub;

    public void setCellStub(CellStub stub) {
        this._stub = stub;
    }

    private CellTunnelInfo[] getCellTunnelInfos(String address) throws CacheException, InterruptedException {
        ArrayList<CellTunnelInfo> tunnels = new ArrayList<CellTunnelInfo>();
        _log.debug("Sending topology info request to " + address);
        CellTunnelInfo[] infos = this._stub.sendAndWait(new CellPath(address), (Serializable)((Object)"getcelltunnelinfos"), CellTunnelInfo[].class);
        _log.debug("Got reply from " + address);
        for (CellTunnelInfo info : infos) {
            if (info.getRemoteCellDomainInfo() == null) continue;
            tunnels.add(info);
        }
        return tunnels.toArray(new CellTunnelInfo[0]);
    }

    private List<CellDomainNode> getConnectedNodes(CellDomainNode node) {
        ArrayList<CellDomainNode> nodes = new ArrayList<CellDomainNode>();
        for (CellTunnelInfo info : node.getLinks()) {
            String address = node.getAddress();
            String domain = info.getRemoteCellDomainInfo().getCellDomainName();
            nodes.add(new CellDomainNode(domain, address + ":System@" + domain));
        }
        return nodes;
    }

    protected Map<String, CellDomainNode> buildTopologyMap(String domain) throws InterruptedException {
        ArrayDeque<CellDomainNode> queue = new ArrayDeque<CellDomainNode>();
        HashMap<String, CellDomainNode> map = new HashMap<String, CellDomainNode>();
        CellDomainNode node = new CellDomainNode(domain, "System@" + domain);
        queue.add(node);
        map.put(node.getName(), node);
        while ((node = (CellDomainNode)queue.poll()) != null) {
            try {
                node.setLinks(this.getCellTunnelInfos(node.getAddress()));
                for (CellDomainNode connectedNode : this.getConnectedNodes(node)) {
                    String name = connectedNode.getName();
                    if (map.containsKey(name)) continue;
                    queue.add(connectedNode);
                    map.put(name, connectedNode);
                }
            }
            catch (CacheException e) {
                _log.warn("Failed to fetch topology info from {}: {}", (Object)node.getAddress(), (Object)e.getMessage());
            }
        }
        return map;
    }
}

