/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.services.ssh2;

import com.google.common.base.Charsets;
import com.google.common.io.Files;
import diskCacheV111.util.AuthorizedKeyParser;
import diskCacheV111.util.CacheException;
import diskCacheV111.util.PermissionDeniedCacheException;
import dmg.cells.nucleus.CellEndpoint;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.Charset;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.util.List;
import javax.security.auth.Subject;
import org.apache.sshd.SshServer;
import org.apache.sshd.common.Factory;
import org.apache.sshd.common.KeyPairProvider;
import org.apache.sshd.common.keyprovider.FileKeyPairProvider;
import org.apache.sshd.server.PasswordAuthenticator;
import org.apache.sshd.server.PublickeyAuthenticator;
import org.apache.sshd.server.session.ServerSession;
import org.dcache.auth.LoginReply;
import org.dcache.auth.LoginStrategy;
import org.dcache.auth.PasswordCredential;
import org.dcache.auth.Subjects;
import org.dcache.auth.UnionLoginStrategy;
import org.dcache.cells.CellCommandListener;
import org.dcache.cells.CellLifeCycleAware;
import org.dcache.cells.CellMessageSender;
import org.dcache.services.ssh2.CommandFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Ssh2Admin
implements CellCommandListener,
CellMessageSender,
CellLifeCycleAware {
    private static final Logger _log = LoggerFactory.getLogger(Ssh2Admin.class);
    private final SshServer _server = SshServer.setUpDefaultServer();
    private String _hostKeyPrivate;
    private String _hostKeyPublic;
    private File _authorizedKeyList;
    private int _port;
    private CommandFactory _commandFactory;
    private File _historyFile;
    private LoginStrategy _loginStrategy;
    private CellEndpoint _cellEndPoint;

    public LoginStrategy getLoginStrategy() {
        return this._loginStrategy;
    }

    public void setLoginStrategy(LoginStrategy loginStrategy) {
        this._loginStrategy = loginStrategy;
    }

    public File getHistoryFile() {
        return this._historyFile;
    }

    public void setHistoryFile(File historyFile) {
        this._historyFile = historyFile;
    }

    public void setPort(int port) {
        _log.debug("Ssh2 port set to: {}", (Object)String.valueOf(port));
        this._port = port;
    }

    public int getPort() {
        return this._port;
    }

    public String getHostKeyPrivate() {
        return this._hostKeyPrivate;
    }

    public void setHostKeyPrivate(String hostKeyPrivate) {
        this._hostKeyPrivate = hostKeyPrivate;
        _log.debug("hostKeyPrivate set to: {}", (Object)this._hostKeyPrivate);
    }

    public String getHostKeyPublic() {
        return this._hostKeyPublic;
    }

    public void setHostKeyPublic(String hostKeyPublic) {
        this._hostKeyPublic = hostKeyPublic;
        _log.debug("hostKeyPublic set to: {}", (Object)this._hostKeyPublic);
    }

    public File getAuthorizedKeyList() {
        return this._authorizedKeyList;
    }

    public void setAuthorizedKeyList(File authorizedKeyList) {
        this._authorizedKeyList = authorizedKeyList;
    }

    @Override
    public void setCellEndpoint(CellEndpoint endpoint) {
        this._cellEndPoint = endpoint;
        _log.debug("CellEndpoint set to: {}", (Object)this._cellEndPoint);
    }

    public void setServerShellFactory(String userName) {
        this._commandFactory = new CommandFactory(userName, this._cellEndPoint, this._historyFile);
        this._server.setShellFactory((Factory)this._commandFactory);
    }

    public void configureAuthentication() {
        this._server.setPasswordAuthenticator((PasswordAuthenticator)new AdminPasswordAuthenticator());
        this._server.setPublickeyAuthenticator((PublickeyAuthenticator)new AdminPublickeyAuthenticator());
    }

    public boolean kpwdLogin(String userName, String passwd) {
        PasswordCredential passCredential = new PasswordCredential(userName, passwd);
        Subject subject = new Subject();
        subject.getPrivateCredentials().add(passCredential);
        try {
            _log.debug("LoginStrategy: {}, {}", this._loginStrategy.getClass(), ((UnionLoginStrategy)this._loginStrategy).getLoginStrategies());
            LoginReply loginReply = this._loginStrategy.login(subject);
            _log.debug("LoginReply: {}, name is: {}", (Object)loginReply, (Object)Subjects.getDisplayName((Subject)loginReply.getSubject()));
            this.setServerShellFactory(Subjects.getDisplayName((Subject)loginReply.getSubject()));
            return true;
        }
        catch (PermissionDeniedCacheException e) {
            _log.warn("Pwd-based login for user: {} was denied.", (Object)userName);
        }
        catch (CacheException e) {
            _log.warn("Pwd-based Login failed: {}", (Object)e.toString());
        }
        return false;
    }

    @Override
    public void afterStart() {
        this.configureAuthentication();
        String[] keyFiles = new String[]{this._hostKeyPrivate, this._hostKeyPublic};
        FileKeyPairProvider fKeyPairProvider = new FileKeyPairProvider(keyFiles);
        this._server.setKeyPairProvider((KeyPairProvider)fKeyPairProvider);
        this._server.setPort(this._port);
        try {
            this._server.start();
        }
        catch (IOException e) {
            _log.error("Ssh2 server was interrupted while starting: {}", (Object)e.getMessage());
        }
        _log.debug("Ssh2 Admin Interface started!");
    }

    @Override
    public void beforeStop() {
        try {
            this._server.stop();
        }
        catch (InterruptedException e) {
            _log.warn("Server was interupted during shutdown!");
        }
    }

    private class AdminPublickeyAuthenticator
    implements PublickeyAuthenticator {
        private AdminPublickeyAuthenticator() {
        }

        public boolean authenticate(String userName, PublicKey key, ServerSession session) {
            _log.debug("Authentication username set to: {} publicKey: {}", (Object)userName, (Object)key);
            try {
                AuthorizedKeyParser decoder = new AuthorizedKeyParser();
                List keyLines = Files.readLines((File)Ssh2Admin.this._authorizedKeyList, (Charset)Charsets.UTF_8);
                for (String keyLine : keyLines) {
                    PublicKey decodedKey = decoder.decodePublicKey(keyLine);
                    if (!decodedKey.equals(key)) continue;
                    _log.debug("Key found! Decoded Key: {}, SshReceivedKey: {}", (Object)decodedKey, (Object)key);
                    Ssh2Admin.this.setServerShellFactory(userName);
                    return true;
                }
            }
            catch (FileNotFoundException e) {
                _log.error("The authorized_keys2 file was not found. Please check if it exists in: {}", (Object)Ssh2Admin.this._authorizedKeyList);
            }
            catch (IOException e) {
                _log.error("There was an error reading lines from the authorized_keys2 file");
            }
            catch (IllegalArgumentException e) {
                _log.warn("One of the keys in {} is of an unknown type: {}", (Object)Ssh2Admin.this._authorizedKeyList, (Object)e.getMessage());
            }
            catch (InvalidKeySpecException e) {
                _log.warn("One of the keys in {} has an unknown key specification.", (Object)Ssh2Admin.this._authorizedKeyList);
            }
            catch (NoSuchAlgorithmException e) {
                _log.warn("The cryptographic algorithm of one of the keys in {} in not known.", (Object)Ssh2Admin.this._authorizedKeyList);
            }
            _log.warn("Could not find key: " + key.toString() + "in {}.", (Object)Ssh2Admin.this._authorizedKeyList);
            return false;
        }
    }

    private class AdminPasswordAuthenticator
    implements PasswordAuthenticator {
        private AdminPasswordAuthenticator() {
        }

        public boolean authenticate(String userName, String password, ServerSession session) {
            _log.debug("Authentication username set to: {}", (Object)userName);
            return Ssh2Admin.this.kpwdLogin(userName, password);
        }
    }
}

