/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.services.ssh2;

import com.google.common.base.Charsets;
import diskCacheV111.admin.UserAdminShell;
import dmg.cells.nucleus.CellEndpoint;
import dmg.cells.nucleus.NoRouteToCellException;
import dmg.cells.nucleus.SerializationException;
import dmg.util.CommandException;
import dmg.util.CommandExitException;
import dmg.util.CommandPanicException;
import dmg.util.CommandSyntaxException;
import dmg.util.CommandThrowableException;
import dmg.util.RequestTimeOutException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import jline.ANSIBuffer;
import jline.Completor;
import jline.ConsoleReader;
import jline.History;
import jline.Terminal;
import jline.UnixTerminal;
import org.apache.sshd.server.Command;
import org.apache.sshd.server.Environment;
import org.apache.sshd.server.ExitCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsoleReaderCommand
implements Command,
Runnable {
    private static final Logger _logger = LoggerFactory.getLogger(ConsoleReaderCommand.class);
    private static final int HISTORY_SIZE = 50;
    private static final String NL = "\r\n";
    private static final String CONTROL_C_ANSWER = "Got interrupt. Please issue 'logoff' from within the Admin Cell to end this session.\n";
    private static File _historyFile;
    private final UserAdminShell _userAdminShell;
    private OutputStream _err;
    private InputStream _in;
    private ExitCallback _exitCallback;
    private OutputStreamWriter _outWriter;
    private Thread _adminShellThread;
    private ConsoleReader _console;
    private History _history;
    private boolean _useColors;

    public ConsoleReaderCommand(String username, CellEndpoint cellEndpoint, File historyFile) {
        this._userAdminShell = new UserAdminShell(username, cellEndpoint, cellEndpoint.getArgs());
        if (historyFile != null && historyFile.isFile()) {
            try {
                this._history = new History(historyFile);
                this._history.setMaxSize(50);
            }
            catch (IOException e) {
                _logger.warn("History creation failed: " + e.getMessage());
            }
        }
    }

    public void destroy() {
        if (this._adminShellThread != null) {
            this._adminShellThread.interrupt();
        }
    }

    public void setErrorStream(OutputStream err) {
        this._err = err;
    }

    public void setExitCallback(ExitCallback callback) {
        this._exitCallback = callback;
    }

    public void setInputStream(InputStream in) {
        this._in = in;
    }

    public void setOutputStream(OutputStream out) {
        this._outWriter = new SshOutputStreamWriter(out);
    }

    public void start(Environment env) throws IOException {
        this._useColors = env.getEnv().containsKey("TERM");
        this._console = new ConsoleReader(this._in, (Writer)this._outWriter, null, (Terminal)new ConsoleReaderTerminal(env));
        this._adminShellThread = new Thread(this);
        this._adminShellThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.initAdminShell();
            this.runAsciiMode();
        }
        catch (IOException e) {
            _logger.warn(e.getMessage());
        }
        finally {
            this._exitCallback.onExit(0);
            try {
                this.cleanUp();
            }
            catch (IOException e) {
                _logger.warn("Something went wrong cleaning up the console: " + e.getMessage());
            }
        }
    }

    private void initAdminShell() throws IOException {
        if (this._history != null) {
            this._console.setHistory(this._history);
            this._console.setUseHistory(true);
            _logger.debug("History enabled.");
        }
        String hello = "";
        if (this._userAdminShell != null) {
            this._console.addCompletor((Completor)this._userAdminShell);
            hello = this._userAdminShell.getHello();
        }
        this._console.addTriggeredAction('\u0003', new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                try {
                    ConsoleReaderCommand.this._console.printString(ConsoleReaderCommand.CONTROL_C_ANSWER);
                    ConsoleReaderCommand.this._console.printString(ConsoleReaderCommand.NL);
                    ConsoleReaderCommand.this._console.printString("\r");
                    ConsoleReaderCommand.this._console.flushConsole();
                }
                catch (IOException e) {
                    _logger.warn("I/O failure for Ctrl-C: " + e);
                }
            }
        });
        this._console.printString(hello);
        this._console.printString(NL);
        this._console.flushConsole();
    }

    private void runAsciiMode() throws IOException {
        while (!this._adminShellThread.isInterrupted()) {
            String s;
            Object result;
            block18: {
                String prompt = new ANSIBuffer().green(this._userAdminShell.getPrompt()).toString(this._useColors);
                String str = this._console.readLine(prompt);
                try {
                    if (str == null) {
                        throw new CommandExitException();
                    }
                    result = this._userAdminShell.executeCommand(str);
                }
                catch (CommandSyntaxException e) {
                    result = e.getMessage() + " Please enter 'help' to see all commands that can be used.";
                }
                catch (IllegalArgumentException e) {
                    result = e.getMessage() + " (Please check the spelling of your command or your config file(s)!)";
                }
                catch (CommandExitException e) {
                    break;
                }
                catch (SerializationException e) {
                    result = "There is a bug here, please report to support@dcache.org";
                    _logger.error("This must be a bug, please report to support@dcache.org: {}" + e.getMessage());
                }
                catch (CommandException e) {
                    if (e instanceof CommandPanicException) {
                        result = ((Exception)((CommandPanicException)((Object)e)).getTargetException()).getMessage();
                        _logger.warn("Something went wrong during the remote execution of the command: {}" + ((CommandPanicException)((Object)e)).getTargetException());
                        return;
                    }
                    if (e instanceof CommandThrowableException) {
                        result = ((Exception)((CommandThrowableException)((Object)e)).getTargetException()).getMessage();
                        _logger.warn("Something went wrong during the remote execution of the command: {}" + ((CommandThrowableException)((Object)e)).getTargetException());
                        return;
                    }
                    result = "There is a bug here, please report to support@dcache.org: " + e.getMessage();
                    _logger.warn("Unexpected exception, please report this bug to support@dcache.org");
                }
                catch (NoRouteToCellException e) {
                    result = "Cell name does not exist or cell is not started: " + e.getMessage();
                    _logger.warn("The cell the command was sent to is no longer there: {}", (Object)e.getMessage());
                }
                catch (InterruptedException e) {
                    result = e.getMessage();
                }
                catch (RequestTimeOutException e) {
                    result = e.getMessage();
                    _logger.warn(e.getMessage());
                }
                catch (RuntimeException e) {
                    result = String.format("Command '%s' triggered bug; please located this message in log file and send an email to support@dcache.org with this line and the following stack-trace", str);
                    _logger.warn((String)result, (Throwable)e);
                }
                catch (Exception e) {
                    result = e.getMessage();
                    if (result != null) break block18;
                    result = e.getClass().getSimpleName() + ": (null)";
                }
            }
            if (result == null) continue;
            if (result instanceof CommandSyntaxException) {
                CommandSyntaxException e = (CommandSyntaxException)((Object)result);
                ANSIBuffer sb = new ANSIBuffer();
                sb.red("Syntax error: " + e.getMessage() + "\n");
                String help = e.getHelpText();
                if (help != null) {
                    sb.cyan("Help : \n");
                    sb.cyan(help);
                }
                s = sb.toString(this._useColors);
            } else {
                s = result.toString();
            }
            if (s.isEmpty()) continue;
            this._console.printString(s);
            this._console.printNewline();
        }
    }

    private void cleanUp() throws IOException {
        PrintWriter out;
        if (this._history != null && (out = this._history.getOutput()) != null) {
            out.close();
        }
        this._console.printString(NL);
        this._console.flushConsole();
        this._outWriter.close();
        this._in.close();
    }

    private static class SshOutputStreamWriter
    extends OutputStreamWriter {
        public SshOutputStreamWriter(OutputStream out) {
            super(out, Charsets.UTF_8);
        }

        @Override
        public void write(char[] c) throws IOException {
            this.write(c, 0, c.length);
        }

        @Override
        public void write(char[] c, int off, int len) throws IOException {
            for (int i = off; i < off + len; ++i) {
                this.write(c[i]);
            }
        }

        @Override
        public void write(int c) throws IOException {
            if (c == 10) {
                super.write(10);
                super.write(13);
            } else {
                super.write(c);
            }
        }

        @Override
        public void write(String str) throws IOException {
            for (int i = 0; i < str.length(); ++i) {
                this.write(str.charAt(i));
            }
        }

        @Override
        public void write(String str, int off, int len) throws IOException {
            for (int i = off; i < off + len; ++i) {
                this.write(str.charAt(i));
            }
        }
    }

    private static class ConsoleReaderTerminal
    extends UnixTerminal {
        private static final int DEFAULT_WIDTH = 80;
        private static final int DEFAULT_HEIGHT = 24;
        private final Environment _env;

        private ConsoleReaderTerminal(Environment env) {
            this._env = env;
        }

        public void initializeTerminal() throws IOException, InterruptedException {
        }

        public int readCharacter(InputStream in) throws IOException {
            int c = super.readCharacter(in);
            if (c == 127) {
                c = 8;
            }
            return c;
        }

        public int getTerminalHeight() {
            String h = (String)this._env.getEnv().get("LINES");
            if (h != null) {
                try {
                    return Integer.parseInt(h);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return 24;
        }

        public int getTerminalWidth() {
            String h = (String)this._env.getEnv().get("COLUMNS");
            if (h != null) {
                try {
                    return Integer.parseInt(h);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return 80;
        }
    }
}

