/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.services.login;

import diskCacheV111.util.CacheException;
import diskCacheV111.util.PermissionDeniedCacheException;
import diskCacheV111.util.TimeoutCacheException;
import dmg.cells.nucleus.CellMessage;
import java.security.Principal;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.dcache.auth.LoginReply;
import org.dcache.auth.LoginStrategy;
import org.dcache.cells.CellMessageReceiver;
import org.dcache.services.login.LoginMessage;
import org.dcache.services.login.MapMessage;
import org.dcache.services.login.ReverseMapMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageHandler
implements CellMessageReceiver {
    private static final Logger _log = LoggerFactory.getLogger(MessageHandler.class);
    private static final int TTL_BUFFER_MAXIMUM = 10000;
    private static final float TTL_BUFFER_FRACTION = 0.1f;
    private LoginStrategy _loginStrategy;
    private ScheduledExecutorService _executor;

    public void setLoginStrategy(LoginStrategy loginStrategy) {
        this._loginStrategy = loginStrategy;
    }

    public LoginStrategy getLoginStrategy() {
        return this._loginStrategy;
    }

    public void setTimeoutExecutor(ScheduledExecutorService executor) {
        this._executor = executor;
    }

    public ScheduledExecutorService getTimeoutExecutor() {
        return this._executor;
    }

    private long getAdjustedTtl(CellMessage envelope) {
        long ttl = envelope.getTtl();
        return ttl == Long.MAX_VALUE ? Long.MAX_VALUE : ttl - Math.min(10000L, (long)((float)ttl * 0.1f));
    }

    private void failIfTooOld(CellMessage envelope) throws TimeoutCacheException {
        if (envelope.getLocalAge() > this.getAdjustedTtl(envelope)) {
            _log.warn("Discarding " + envelope.getMessageObject().getClass().getSimpleName() + " because its time to live has been exceeded.");
            throw new TimeoutCacheException("TTL exceeded");
        }
    }

    private ScheduledFuture<?> scheduleTimeoutTask(CellMessage envelope) throws TimeoutCacheException {
        final Thread self = Thread.currentThread();
        Runnable timeoutTask = new Runnable(){

            @Override
            public void run() {
                self.interrupt();
            }
        };
        return this._executor.schedule(timeoutTask, envelope.getTtl() - envelope.getLocalAge(), TimeUnit.MILLISECONDS);
    }

    public LoginMessage messageArrived(CellMessage envelope, LoginMessage message) throws CacheException {
        this.failIfTooOld(envelope);
        ScheduledFuture<?> timeoutTask = this.scheduleTimeoutTask(envelope);
        try {
            LoginReply login = this._loginStrategy.login(message.getSubject());
            message.setSubject(login.getSubject());
            message.setLoginAttributes(login.getLoginAttributes());
        }
        catch (RuntimeException e) {
            _log.error("Login operation failed", (Throwable)e);
            throw new PermissionDeniedCacheException(e.getMessage());
        }
        finally {
            timeoutTask.cancel(false);
        }
        return message;
    }

    public MapMessage messageArrived(MapMessage message) throws CacheException {
        Principal principal;
        try {
            principal = this._loginStrategy.map(message.getPrincipal());
        }
        catch (RuntimeException e) {
            _log.error("Map operation failed", (Throwable)e);
            principal = null;
        }
        message.setMappedPrincipal(principal);
        return message;
    }

    public ReverseMapMessage messageArrived(ReverseMapMessage message) throws CacheException {
        Set<Principal> principals;
        try {
            principals = this._loginStrategy.reverseMap(message.getPrincipal());
        }
        catch (RuntimeException e) {
            _log.error("ReverseMap operation failed", (Throwable)e);
            principals = Collections.emptySet();
        }
        message.setMappedPrincipals(principals);
        return message;
    }
}

