/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.services.login;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.util.concurrent.CheckedFuture;
import com.google.common.util.concurrent.Futures;
import diskCacheV111.util.CacheException;
import java.security.Principal;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.security.auth.Subject;
import org.dcache.auth.LoginReply;
import org.dcache.auth.LoginStrategy;

public class CachingLoginStrategy
implements LoginStrategy {
    private final LoginStrategy _inner;
    private final Cache<Principal, CheckedFuture<Principal, CacheException>> _forwardCache;
    private final Cache<Principal, CheckedFuture<Set<Principal>, CacheException>> _reverseCache;
    private final Cache<Subject, CheckedFuture<LoginReply, CacheException>> _loginCache;

    public CachingLoginStrategy(LoginStrategy inner, int size, long timeout, TimeUnit unit) {
        this._inner = inner;
        this._forwardCache = CacheBuilder.newBuilder().expireAfterWrite(timeout, unit).maximumSize(size).softValues().build((CacheLoader)new ForwardFetcher());
        this._reverseCache = CacheBuilder.newBuilder().expireAfterWrite(timeout, unit).maximumSize(size).softValues().build((CacheLoader)new ReverseFetcher());
        this._loginCache = CacheBuilder.newBuilder().expireAfterWrite(timeout, unit).maximumSize(size).softValues().build((CacheLoader)new LoginFetcher());
    }

    @Override
    public LoginReply login(Subject subject) throws CacheException {
        return (LoginReply)((CheckedFuture)this._loginCache.getUnchecked((Object)subject)).checkedGet();
    }

    @Override
    public Principal map(Principal principal) throws CacheException {
        return (Principal)((CheckedFuture)this._forwardCache.getUnchecked((Object)principal)).checkedGet();
    }

    @Override
    public Set<Principal> reverseMap(Principal principal) throws CacheException {
        return (Set)((CheckedFuture)this._reverseCache.getUnchecked((Object)principal)).checkedGet();
    }

    private class LoginFetcher
    extends CacheLoader<Subject, CheckedFuture<LoginReply, CacheException>> {
        private LoginFetcher() {
        }

        public CheckedFuture<LoginReply, CacheException> load(Subject f) {
            try {
                LoginReply s = CachingLoginStrategy.this._inner.login(f);
                return Futures.immediateCheckedFuture((Object)s);
            }
            catch (CacheException e) {
                return Futures.immediateFailedCheckedFuture((Exception)e);
            }
        }
    }

    private class ReverseFetcher
    extends CacheLoader<Principal, CheckedFuture<Set<Principal>, CacheException>> {
        private ReverseFetcher() {
        }

        public CheckedFuture<Set<Principal>, CacheException> load(Principal f) {
            try {
                Set<Principal> s = CachingLoginStrategy.this._inner.reverseMap(f);
                return Futures.immediateCheckedFuture(s);
            }
            catch (CacheException e) {
                return Futures.immediateFailedCheckedFuture((Exception)e);
            }
        }
    }

    private class ForwardFetcher
    extends CacheLoader<Principal, CheckedFuture<Principal, CacheException>> {
        private ForwardFetcher() {
        }

        public CheckedFuture<Principal, CacheException> load(Principal f) {
            try {
                Principal p = CachingLoginStrategy.this._inner.map(f);
                return Futures.immediateCheckedFuture((Object)p);
            }
            catch (CacheException e) {
                return Futures.immediateFailedCheckedFuture((Exception)e);
            }
        }
    }
}

