/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.services.info.stateInfo;

import diskCacheV111.pools.PoolCostInfo;
import org.dcache.services.info.base.IntegerStateValue;
import org.dcache.services.info.base.StatePath;
import org.dcache.services.info.base.StateUpdate;

public class SpaceInfo {
    public static final String PATH_ELEMENT_TOTAL = "total";
    public static final String PATH_ELEMENT_FREE = "free";
    public static final String PATH_ELEMENT_PRECIOUS = "precious";
    public static final String PATH_ELEMENT_REMOVABLE = "removable";
    public static final String PATH_ELEMENT_USED = "used";
    private long _total;
    private long _free;
    private long _precious;
    private long _removable;
    private long _used;

    public SpaceInfo(long totalSpace, long freeSpace, long preciousSpace, long removableSpace) {
        this._total = totalSpace;
        this._free = freeSpace;
        this._precious = preciousSpace;
        this._removable = removableSpace;
        this._used = totalSpace - freeSpace;
    }

    public SpaceInfo(SpaceInfo otherInfo) {
        this(otherInfo.getTotal(), otherInfo.getFree(), otherInfo.getPrecious(), otherInfo.getRemovable());
    }

    public SpaceInfo() {
        this._used = 0L;
        this._removable = 0L;
        this._precious = 0L;
        this._free = 0L;
        this._total = 0L;
    }

    public SpaceInfo(long capacity) {
        this._free = this._total = capacity;
        this._removable = 0L;
        this._precious = 0L;
        this._used = 0L;
    }

    public SpaceInfo(PoolCostInfo.PoolSpaceInfo spaceInfo) {
        this._total = spaceInfo.getTotalSpace();
        this._free = spaceInfo.getFreeSpace();
        this._precious = spaceInfo.getPreciousSpace();
        this._removable = spaceInfo.getRemovableSpace();
        this._used = this._total - this._free;
    }

    public boolean equals(Object o) {
        if (!(o instanceof SpaceInfo)) {
            return false;
        }
        SpaceInfo info = (SpaceInfo)o;
        return info._total == this._total && info._free == this._free && info._precious == this._precious && info._removable == this._removable && info._used == this._used;
    }

    public int hashCode() {
        return (int)this._total + (int)this._free + (int)this._precious + (int)this._removable;
    }

    public void add(SpaceInfo otherSpace) {
        if (otherSpace == null) {
            return;
        }
        this._total += otherSpace._total;
        this._free += otherSpace._free;
        this._precious += otherSpace._precious;
        this._removable += otherSpace._removable;
        this._used += otherSpace._used;
    }

    public void setTotal(long totalSpace) {
        this._total = totalSpace;
    }

    public void setFree(long freeSpace) {
        this._free = freeSpace;
    }

    public void setPrecious(long preciousSpace) {
        this._precious = preciousSpace;
    }

    public void setRemovable(long removableSpace) {
        this._removable = removableSpace;
    }

    public void setUsed(long usedSpace) {
        this._used = usedSpace;
    }

    public void addToTotal(long extraTotalSpace) {
        this._total += extraTotalSpace;
    }

    public void addToFree(long extraFreeSpace) {
        this._free += extraFreeSpace;
    }

    public void addToRemovable(long extraRemovableSpace) {
        this._removable += extraRemovableSpace;
    }

    public void addToPrecious(long extraPreciousSpace) {
        this._precious += extraPreciousSpace;
    }

    public void addToUsed(long extraUsedSpace) {
        this._used += extraUsedSpace;
    }

    public void updatePrecious(long change) {
        if (change > this._free) {
            change = this._free;
        }
        if (change < -this._precious) {
            change = -this._precious;
        }
        this._precious += change;
        this.recalcFree();
    }

    public void updateRemovable(long change) {
        if (change > this._free) {
            change = this._free;
        }
        if (change < -this._removable) {
            change = -this._removable;
        }
        this._removable += change;
        this.recalcFree();
    }

    public void recalcFree() {
        this._used = this._precious + this._removable;
        this._free = this._used < this._total ? this._total - this._used : 0L;
    }

    public long getTotal() {
        return this._total;
    }

    public long getFree() {
        return this._free;
    }

    public long getPrecious() {
        return this._precious;
    }

    public long getRemovable() {
        return this._removable;
    }

    public long getUsed() {
        return this._used;
    }

    public void addMetrics(StateUpdate update, StatePath path, long duration) {
        update.appendUpdate(path.newChild(PATH_ELEMENT_TOTAL), new IntegerStateValue(this._total, duration));
        update.appendUpdate(path.newChild(PATH_ELEMENT_FREE), new IntegerStateValue(this._free, duration));
        update.appendUpdate(path.newChild(PATH_ELEMENT_PRECIOUS), new IntegerStateValue(this._precious, duration));
        update.appendUpdate(path.newChild(PATH_ELEMENT_REMOVABLE), new IntegerStateValue(this._removable, duration));
        update.appendUpdate(path.newChild(PATH_ELEMENT_USED), new IntegerStateValue(this._used, duration));
    }

    public void addMetrics(StateUpdate update, StatePath path, boolean isImmortal) {
        update.appendUpdate(path.newChild(PATH_ELEMENT_TOTAL), new IntegerStateValue(this._total, isImmortal));
        update.appendUpdate(path.newChild(PATH_ELEMENT_FREE), new IntegerStateValue(this._free, isImmortal));
        update.appendUpdate(path.newChild(PATH_ELEMENT_PRECIOUS), new IntegerStateValue(this._precious, isImmortal));
        update.appendUpdate(path.newChild(PATH_ELEMENT_REMOVABLE), new IntegerStateValue(this._removable, isImmortal));
        update.appendUpdate(path.newChild(PATH_ELEMENT_USED), new IntegerStateValue(this._used, isImmortal));
    }

    public String toString() {
        return "[SpaceInfo: total=" + this._total + ", precious=" + this._precious + ", removable=" + this._removable + ", used=" + this._used + ", free=" + this._free + "]";
    }
}

