/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.services.info.stateInfo;

import java.util.Map;
import org.dcache.services.info.base.BooleanStateValue;
import org.dcache.services.info.base.FloatingPointStateValue;
import org.dcache.services.info.base.IntegerStateValue;
import org.dcache.services.info.base.StateGuide;
import org.dcache.services.info.base.StatePath;
import org.dcache.services.info.base.StateVisitor;
import org.dcache.services.info.base.StringStateValue;
import org.dcache.services.info.base.guides.SubtreeStateGuide;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SkeletonListVisitor
implements StateVisitor {
    private static Logger _log = LoggerFactory.getLogger(SkeletonListVisitor.class);
    private final StatePath _pathToList;
    private String _thisKey;
    private final StateGuide _guide;

    protected SkeletonListVisitor(StatePath pathToList) {
        if (_log.isDebugEnabled()) {
            _log.debug("Searching on path " + pathToList);
        }
        this._pathToList = pathToList;
        this._guide = new SubtreeStateGuide(pathToList);
    }

    @Override
    public boolean isVisitable(StatePath path) {
        return this._guide.isVisitable(path);
    }

    @Override
    public void visitBoolean(StatePath path, BooleanStateValue value) {
    }

    @Override
    public void visitFloatingPoint(StatePath path, FloatingPointStateValue value) {
    }

    @Override
    public void visitInteger(StatePath path, IntegerStateValue value) {
    }

    @Override
    public void visitString(StatePath path, StringStateValue value) {
    }

    @Override
    public void visitCompositePreDescend(StatePath path, Map<String, String> metadata) {
        if (this._pathToList.isParentOf(path)) {
            if (_log.isDebugEnabled()) {
                _log.debug("Entering " + path);
            }
            this.newListItem(path.getLastElement());
        }
    }

    @Override
    public void visitCompositePostDescend(StatePath path, Map<String, String> metadata) {
        if (this._pathToList.isParentOf(path)) {
            if (_log.isDebugEnabled()) {
                _log.debug("Leaving " + path);
            }
            this.exitingListItem(path.getLastElement());
        }
    }

    protected void newListItem(String listItemName) {
        if (_log.isDebugEnabled()) {
            _log.debug("Assigning _thisKey to " + listItemName);
        }
        this._thisKey = listItemName;
    }

    protected void exitingListItem(String listItemName) {
        if (_log.isDebugEnabled()) {
            _log.debug("Resetting _thisKey to null on leaving " + listItemName);
        }
        this._thisKey = null;
    }

    protected StatePath getPathToList() {
        return this._pathToList;
    }

    protected String getKey() {
        return this._thisKey;
    }

    protected boolean isInListItem() {
        return this._thisKey != null;
    }
}

