/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.services.info.stateInfo;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.dcache.services.info.base.StateExhibitor;
import org.dcache.services.info.base.StatePath;
import org.dcache.services.info.stateInfo.SkeletonListVisitor;

public class SetMapVisitor
extends SkeletonListVisitor {
    private final StatePath _relativePathToList;
    private final Map<String, Set<String>> _map = new HashMap<String, Set<String>>();
    private StatePath _pathToSet;
    private Set<String> _thisListItemSet;

    public static Map<String, Set<String>> getDetails(StateExhibitor exhibitor, StatePath pathToMainList, StatePath pathToSecondList) {
        SetMapVisitor visitor = new SetMapVisitor(pathToMainList, pathToSecondList);
        exhibitor.visitState(visitor);
        return visitor.getMap();
    }

    public SetMapVisitor(StatePath pathToPrimaryList, StatePath relativePathToSecondList) {
        super(pathToPrimaryList);
        this._relativePathToList = relativePathToSecondList;
    }

    @Override
    protected void newListItem(String listItemName) {
        super.newListItem(listItemName);
        this._pathToSet = this.getPathToList().newChild(listItemName).newChild(this._relativePathToList);
        this._thisListItemSet = new HashSet<String>();
        this._map.put(listItemName, this._thisListItemSet);
    }

    @Override
    protected void exitingListItem(String listItemName) {
        super.exitingListItem(listItemName);
        this._pathToSet = null;
        this._thisListItemSet = null;
    }

    @Override
    public void visitCompositePreDescend(StatePath path, Map<String, String> metadata) {
        super.visitCompositePreDescend(path, metadata);
        if (this.isInListItem() && this._pathToSet.isParentOf(path)) {
            this._thisListItemSet.add(path.getLastElement());
        }
    }

    public Map<String, Set<String>> getMap() {
        return this._map;
    }
}

