/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.services.info.stateInfo;

public class ReservationInfo {
    private RetentionPolicy _rp;
    private AccessLatency _al;
    private State _state;
    private final String _id;
    private long _lifetime;
    private boolean _haveLifetime;
    private String _description;
    private long _total;
    private boolean _haveTotal;
    private long _free;
    private boolean _haveFree;
    private long _allocated;
    private boolean _haveAllocated;
    private long _used;
    private boolean _haveUsed;
    private String _vo;

    public ReservationInfo(String id) {
        this._id = id;
    }

    public void setRetentionPolicy(RetentionPolicy rp) {
        if (this.hasRetentionPolicy()) {
            throw new IllegalStateException("attempt to set RetentionPolicy twice");
        }
        this._rp = rp;
    }

    public RetentionPolicy getRetentionPolicy() {
        return this._rp;
    }

    public boolean hasRetentionPolicy() {
        return this._rp != null;
    }

    public void setAccessLatency(AccessLatency al) {
        if (this.hasAccessLatency()) {
            throw new IllegalStateException("attempt to set AccessLatency twice");
        }
        this._al = al;
    }

    public AccessLatency getAccessLatency() {
        return this._al;
    }

    public boolean hasAccessLatency() {
        return this._al != null;
    }

    public String getId() {
        return this._id;
    }

    public long getLifetime() {
        return this._lifetime;
    }

    public void setLifetime(long lifetime) {
        if (this._haveLifetime) {
            throw new IllegalStateException("attempt to set lifetime twice");
        }
        this._lifetime = lifetime;
        this._haveLifetime = true;
    }

    public boolean hasLifetime() {
        return this._haveLifetime;
    }

    public void setDescription(String description) {
        if (this.hasDescription()) {
            throw new IllegalStateException("attempt to set description of reservation " + this._id + " twice.");
        }
        this._description = description;
    }

    public String getDescription() {
        return this._description;
    }

    public boolean hasDescription() {
        return this._description != null;
    }

    public void setVo(String vo) {
        if (this.hasVo()) {
            throw new IllegalStateException("attempt to set VO name of reservation " + this._id + " twice.");
        }
        this._vo = vo;
    }

    public String getVo() {
        return this._vo;
    }

    public boolean hasVo() {
        return this._vo != null;
    }

    public void setState(State state) {
        if (this.hasState()) {
            throw new IllegalStateException("attempt to set state of reservation " + this._id + " twice.");
        }
        this._state = state;
    }

    public State getState() {
        return this._state;
    }

    public boolean hasState() {
        return this._state != null;
    }

    public long getTotal() {
        return this._total;
    }

    public boolean hasTotal() {
        return this._haveTotal;
    }

    public void setTotal(long value) {
        if (this.hasTotal()) {
            throw new IllegalStateException("attempt to set total size of reservation " + this._id + " twice.");
        }
        this._total = value;
        this._haveTotal = true;
    }

    public long getFree() {
        return this._free;
    }

    public boolean hasFree() {
        return this._haveFree;
    }

    public void setFree(long value) {
        if (this.hasFree()) {
            throw new IllegalStateException("attempt to set free size of reservation " + this._id + " twice.");
        }
        this._free = value;
        this._haveFree = true;
    }

    public long getAllocated() {
        return this._allocated;
    }

    public boolean hasAllocated() {
        return this._haveAllocated;
    }

    public void setAllocated(long value) {
        if (this.hasAllocated()) {
            throw new IllegalStateException("attempt to set allocated size of reservation " + this._id + " twice.");
        }
        this._allocated = value;
        this._haveAllocated = true;
    }

    public long getUsed() {
        return this._used;
    }

    public boolean hasUsed() {
        return this._haveUsed;
    }

    public void setUsed(long value) {
        if (this.hasUsed()) {
            throw new IllegalStateException("attempt to set used size of reservation " + this._id + " twice.");
        }
        this._used = value;
        this._haveUsed = true;
    }

    public static enum State {
        RESERVED("RESERVED", false),
        RELEASED("RELEASED", true),
        EXPIRED("EXPIRED", true);

        private final String _metricValue;
        private final boolean _isFinalState;

        private State(String metricValue, boolean isFinalState) {
            this._metricValue = metricValue;
            this._isFinalState = isFinalState;
        }

        public String getMetricValue() {
            return this._metricValue;
        }

        public boolean isFinalState() {
            return this._isFinalState;
        }

        public static State parseMetricValue(String metricValue) {
            for (State state : State.values()) {
                if (!state.getMetricValue().equals(metricValue)) continue;
                return state;
            }
            return null;
        }
    }

    public static enum RetentionPolicy {
        REPLICA("REPLICA"),
        OUTPUT("OUTPUT"),
        CUSTODIAL("CUSTODIAL");

        private final String _metricValue;

        private RetentionPolicy(String metricValue) {
            this._metricValue = metricValue;
        }

        public String getMetricValue() {
            return this._metricValue;
        }

        public static RetentionPolicy parseMetricValue(String metricValue) {
            for (RetentionPolicy rp : RetentionPolicy.values()) {
                if (!rp.getMetricValue().equals(metricValue)) continue;
                return rp;
            }
            return null;
        }
    }

    public static enum AccessLatency {
        ONLINE("ONLINE"),
        NEARLINE("NEARLINE"),
        OFFLINE("OFFLINE");

        private final String _metricValue;

        private AccessLatency(String metricValue) {
            this._metricValue = metricValue;
        }

        public String getMetricValue() {
            return this._metricValue;
        }

        public static AccessLatency parseMetricValue(String metricValue) {
            for (AccessLatency al : AccessLatency.values()) {
                if (!al.getMetricValue().equals(metricValue)) continue;
                return al;
            }
            return null;
        }
    }
}

