/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.services.info.stateInfo;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class LinkInfo {
    private final String _id;
    private final Set<String> _pools = new HashSet<String>();
    private final Set<String> _poolgroups = new HashSet<String>();
    private final Set<String> _unitgroups = new HashSet<String>();
    private final Map<UNIT_TYPE, Set<String>> _units = Collections.unmodifiableMap(new HashMap<UNIT_TYPE, Set<String>>(){
        private static final long serialVersionUID = -3626724207880413521L;
        {
            this.put(UNIT_TYPE.DCACHE, new HashSet());
            this.put(UNIT_TYPE.STORE, new HashSet());
            this.put(UNIT_TYPE.PROTOCOL, new HashSet());
            this.put(UNIT_TYPE.NETWORK, new HashSet());
        }
    });
    private final Map<OPERATION, Long> _operationPref = new ConcurrentHashMap<OPERATION, Long>();

    public LinkInfo(String id) {
        this._id = id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addPool(String poolName) {
        Set<String> set = this._pools;
        synchronized (set) {
            this._pools.add(poolName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addPoolgroup(String poolgroup) {
        Set<String> set = this._poolgroups;
        synchronized (set) {
            this._poolgroups.add(poolgroup);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addUnitgroup(String unitgroupName) {
        Set<String> set = this._unitgroups;
        synchronized (set) {
            this._unitgroups.add(unitgroupName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addUnit(UNIT_TYPE type, String unitName) {
        Set<String> units;
        Set<String> set = units = this._units.get((Object)type);
        synchronized (set) {
            units.add(unitName);
        }
    }

    protected void setOperationPref(OPERATION operation, long pref) {
        this._operationPref.put(operation, new Long(pref));
    }

    public String getId() {
        return this._id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getPools() {
        Set<String> set = this._pools;
        synchronized (set) {
            return new HashSet<String>(this._pools);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getPoolgroups() {
        Set<String> set = this._poolgroups;
        synchronized (set) {
            return new HashSet<String>(this._poolgroups);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getUnitgroups() {
        Set<String> set = this._unitgroups;
        synchronized (set) {
            return new HashSet<String>(this._unitgroups);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getUnits(UNIT_TYPE unitType) {
        Map<UNIT_TYPE, Set<String>> map = this._units;
        synchronized (map) {
            return new HashSet<String>((Collection)this._units.get((Object)unitType));
        }
    }

    public long getOperationPref(OPERATION operation) {
        Long preference = this._operationPref.get((Object)operation);
        if (preference == null) {
            return 0L;
        }
        return preference;
    }

    public boolean isAccessableFor(OPERATION operation) {
        long pref = this.getOperationPref(operation);
        if (operation == OPERATION.P2P) {
            return pref > 0L || pref == -1L && this.getOperationPref(OPERATION.READ) > 0L;
        }
        return pref > 0L;
    }

    public int hashCode() {
        return ((Object)this._pools).hashCode() ^ ((Object)this._poolgroups).hashCode() ^ ((Object)this._units).hashCode() ^ ((Object)this._operationPref).hashCode();
    }

    public boolean equals(Object otherObject) {
        if (!(otherObject instanceof LinkInfo)) {
            return false;
        }
        if (this == otherObject) {
            return true;
        }
        LinkInfo otherLink = (LinkInfo)otherObject;
        if (!((Object)this._pools).equals(otherLink._pools)) {
            return false;
        }
        if (!((Object)this._poolgroups).equals(otherLink._poolgroups)) {
            return false;
        }
        if (!((Object)this._units).equals(otherLink._units)) {
            return false;
        }
        return ((Object)this._operationPref).equals(otherLink._operationPref);
    }

    public String debugInfo() {
        StringBuffer sb = new StringBuffer();
        sb.append("=== LinkInfo for link \"" + this._id + "\" ===\n");
        if (this._pools.size() > 0) {
            sb.append("  Pools:\n");
            for (String poolName : this._pools) {
                sb.append("    " + poolName + "\n");
            }
        }
        if (this._poolgroups.size() > 0) {
            sb.append("  Poolgroups:\n");
            for (String poolgroupName : this._poolgroups) {
                sb.append("    " + poolgroupName + "\n");
            }
        }
        boolean haveOperation = false;
        for (OPERATION operation : OPERATION.values()) {
            if (!this._operationPref.containsKey((Object)operation)) continue;
            haveOperation = true;
            break;
        }
        if (haveOperation) {
            sb.append("  Preferences:\n");
            for (OPERATION operation : OPERATION.values()) {
                if (!this._operationPref.containsKey((Object)operation)) continue;
                sb.append("    " + (Object)((Object)operation) + ": " + this._operationPref.get((Object)operation) + "\n");
            }
        }
        boolean haveUnits = false;
        for (UNIT_TYPE type : UNIT_TYPE.values()) {
            if (this._units.get((Object)type).size() <= 0) continue;
            haveUnits = true;
            break;
        }
        if (haveUnits) {
            sb.append("  Units:\n");
            for (UNIT_TYPE type : UNIT_TYPE.values()) {
                Set<String> units = this._units.get((Object)type);
                if (units.size() <= 0) continue;
                sb.append("    " + (Object)((Object)type) + ":\n");
                for (String unitName : units) {
                    sb.append("        " + unitName + "\n");
                }
            }
        }
        return sb.toString();
    }

    public static enum OPERATION {
        READ("read", "R"),
        WRITE("write", "W"),
        CACHE("cache", "C"),
        P2P("p2p", "P");

        private String _pathElement;
        private String _nasNamePrefix;

        private OPERATION(String pathElement, String nasNamePrefix) {
            this._pathElement = pathElement;
            this._nasNamePrefix = nasNamePrefix;
        }

        public String getPathElement() {
            return this._pathElement;
        }

        public String getNasNamePrefix() {
            return this._nasNamePrefix;
        }
    }

    public static enum UNIT_TYPE {
        DCACHE("dcache", "D"),
        STORE("store", "S"),
        PROTOCOL("protocol", "P"),
        NETWORK("net", "N");

        private String _pathElement;
        private String _nasNamePrefix;

        private UNIT_TYPE(String pathElement, String nasNamePrefix) {
            this._pathElement = pathElement;
            this._nasNamePrefix = nasNamePrefix;
        }

        public String getPathElement() {
            return this._pathElement;
        }

        public String getNasNamePrefix() {
            return this._nasNamePrefix;
        }
    }
}

