/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.services.info.stateInfo;

import org.dcache.services.info.base.IntegerStateValue;
import org.dcache.services.info.base.StatePath;
import org.dcache.services.info.stateInfo.SkeletonListVisitor;
import org.dcache.services.info.stateInfo.SpaceInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPoolSpaceVisitor
extends SkeletonListVisitor {
    private static final StatePath POOLS_PATH = new StatePath("pools");
    private static Logger _log = LoggerFactory.getLogger(AbstractPoolSpaceVisitor.class);
    private SpaceInfo _currentPoolSpaceInfo;
    private StatePath _currentPoolSpacePath = null;
    private static final String METRIC_NAME_FREE = "free";
    private static final String METRIC_NAME_PRECIOUS = "precious";
    private static final String METRIC_NAME_TOTAL = "total";
    private static final String METRIC_NAME_REMOVABLE = "removable";
    private static final String METRIC_NAME_USED = "used";

    protected AbstractPoolSpaceVisitor() {
        super(POOLS_PATH);
    }

    protected abstract void newPool(String var1, SpaceInfo var2);

    @Override
    protected void newListItem(String itemName) {
        super.newListItem(itemName);
        if (_log.isDebugEnabled()) {
            _log.debug("Found pool " + itemName);
        }
        this._currentPoolSpaceInfo = new SpaceInfo();
        this._currentPoolSpacePath = this.getPathToList().newChild(itemName).newChild("space");
    }

    @Override
    protected void exitingListItem(String itemName) {
        super.exitingListItem(itemName);
        this.newPool(itemName, this._currentPoolSpaceInfo);
    }

    @Override
    public void visitInteger(StatePath path, IntegerStateValue value) {
        if (this._currentPoolSpacePath == null || !this._currentPoolSpacePath.isParentOf(path)) {
            return;
        }
        String metricName = path.getLastElement();
        if (_log.isDebugEnabled()) {
            _log.debug("Found metric " + path.getLastElement() + " = " + value.getValue());
        }
        if (metricName.equals(METRIC_NAME_REMOVABLE)) {
            this._currentPoolSpaceInfo.setRemovable(value.getValue());
        } else if (metricName.equals(METRIC_NAME_FREE)) {
            this._currentPoolSpaceInfo.setFree(value.getValue());
        } else if (metricName.equals(METRIC_NAME_TOTAL)) {
            this._currentPoolSpaceInfo.setTotal(value.getValue());
        } else if (metricName.equals(METRIC_NAME_PRECIOUS)) {
            this._currentPoolSpaceInfo.setPrecious(value.getValue());
        } else if (metricName.equals(METRIC_NAME_USED)) {
            this._currentPoolSpaceInfo.setUsed(value.getValue());
        }
    }
}

