/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.services.info.serialisation;

import java.util.Map;
import org.dcache.services.info.base.BooleanStateValue;
import org.dcache.services.info.base.FloatingPointStateValue;
import org.dcache.services.info.base.IntegerStateValue;
import org.dcache.services.info.base.StateExhibitor;
import org.dcache.services.info.base.StatePath;
import org.dcache.services.info.base.StringStateValue;
import org.dcache.services.info.serialisation.StateSerialiser;
import org.dcache.services.info.serialisation.SubtreeVisitor;

public class XmlSerialiser
extends SubtreeVisitor
implements StateSerialiser {
    public static final String NAME = "xml";
    private static final String _newline = "\n";
    private static final String _xmlns = "http://www.dcache.org/2008/01/Info";
    private StringBuilder _out;
    private int _indentationLevel = 0;
    private String _indentationPrefix = "";
    private boolean _isTopBranch;
    private StatePath _lastBranchPath;
    private String _lastBranchElementName;
    private String _lastBranchIdName;
    private boolean _haveLastBranch;
    private final StateExhibitor _exhibitor;

    public XmlSerialiser(StateExhibitor exhibitor) {
        this._exhibitor = exhibitor;
    }

    @Override
    public String serialise() {
        return this.serialise(null);
    }

    @Override
    public String serialise(StatePath start) {
        this._out = new StringBuilder();
        this._isTopBranch = true;
        this._haveLastBranch = false;
        this._indentationLevel = 0;
        this.updateIndentPrefix();
        if (start != null) {
            this.setVisitScopeToSubtree(start);
        } else {
            this.setVisitScopeToEverything();
        }
        this.addElement("<?xml version=\"1.0\"?>");
        this._exhibitor.visitState(this);
        if (this._isTopBranch) {
            this._haveLastBranch = true;
            this._lastBranchElementName = this.getBranchLabel(null);
            this.emitLastBeginElement(true);
        }
        return this._out.toString();
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void visitCompositePreDescend(StatePath path, Map<String, String> metadata) {
        this.enteringBranch(path, metadata);
    }

    @Override
    public void visitCompositePostDescend(StatePath path, Map<String, String> metadata) {
        this.exitingBranch(path, metadata);
    }

    @Override
    public void visitInteger(StatePath path, IntegerStateValue value) {
        this.emitLastBeginElement(false);
        this.addElement(this.buildMetricElement(path.getLastElement(), value.getTypeName(), value.toString()));
    }

    @Override
    public void visitString(StatePath path, StringStateValue value) {
        this.emitLastBeginElement(false);
        this.addElement(this.buildMetricElement(path.getLastElement(), value.getTypeName(), this.xmlTextMarkup(value.toString())));
    }

    @Override
    public void visitBoolean(StatePath path, BooleanStateValue value) {
        this.emitLastBeginElement(false);
        this.addElement(this.buildMetricElement(path.getLastElement(), value.getTypeName(), value.toString()));
    }

    @Override
    public void visitFloatingPoint(StatePath path, FloatingPointStateValue value) {
        this.emitLastBeginElement(false);
        this.addElement(this.buildMetricElement(path.getLastElement(), value.getTypeName(), value.toString()));
    }

    private void enteringBranch(StatePath path, Map<String, String> metadata) {
        this.emitLastBeginElement(false);
        this._lastBranchPath = path;
        String branchClass = null;
        if (metadata != null) {
            branchClass = metadata.get("branch");
        }
        if (branchClass != null) {
            this._lastBranchElementName = branchClass;
            this._lastBranchIdName = metadata.get("id");
        } else {
            this._lastBranchElementName = this.getBranchLabel(path);
            this._lastBranchIdName = null;
        }
        this._haveLastBranch = true;
    }

    private void exitingBranch(StatePath path, Map<String, String> metadata) {
        if (this._haveLastBranch && (path == null && this._lastBranchPath == null || path != null && path.equals(this._lastBranchPath))) {
            this.emitLastBeginElement(true);
            return;
        }
        this.emitLastBeginElement(false);
        --this._indentationLevel;
        this.updateIndentPrefix();
        String branchClass = metadata != null ? metadata.get("branch") : null;
        String label = branchClass != null ? branchClass : this.getBranchLabel(path);
        this.addElement(this.endElement(label));
    }

    private void emitLastBeginElement(boolean isEmpty) {
        if (!this._haveLastBranch) {
            return;
        }
        this._haveLastBranch = false;
        Attribute[] attrs = null;
        if (this._isTopBranch) {
            attrs = new Attribute[]{new Attribute("xmlns", _xmlns)};
            this._isTopBranch = false;
        } else if (this._lastBranchIdName != null) {
            attrs = new Attribute[]{new Attribute(this._lastBranchIdName, this.getBranchLabel(this._lastBranchPath))};
        }
        this.addElement(this.beginElement(this._lastBranchElementName, attrs, isEmpty));
        if (!isEmpty) {
            ++this._indentationLevel;
            this.updateIndentPrefix();
        }
    }

    private void addElement(String element) {
        this._out.append(this._indentationPrefix);
        this._out.append(element);
        this._out.append(_newline);
    }

    private String buildMetricElement(String name, String type, String value) {
        StringBuilder sb = new StringBuilder();
        Attribute[] attr = new Attribute[]{new Attribute("name", name), new Attribute("type", type)};
        sb.append(this.beginElement("metric", attr, false));
        sb.append(value);
        sb.append(this.endElement("metric"));
        return sb.toString();
    }

    private String beginElement(String name, Attribute[] attr, boolean isEmpty) {
        StringBuilder sb = new StringBuilder();
        sb.append("<" + name);
        if (attr != null) {
            for (int i = 0; i < attr.length; ++i) {
                sb.append(" ");
                sb.append(attr[i].name);
                sb.append("=\"");
                sb.append(this.xmlTextMarkup(attr[i].value));
                sb.append("\"");
            }
        }
        if (isEmpty) {
            sb.append("/");
        }
        sb.append(">");
        return sb.toString();
    }

    private String endElement(String name) {
        return "</" + name + ">";
    }

    private String xmlTextMarkup(String value) {
        return value.replaceAll("&", "&amp;").replaceAll("<", "&lt;").replaceAll(">", "&gt;").replaceAll("\"", "&quot;").replaceAll("'", "&apos;");
    }

    private void updateIndentPrefix() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this._indentationLevel; ++i) {
            sb.append("  ");
        }
        this._indentationPrefix = sb.toString();
    }

    private String getBranchLabel(StatePath path) {
        return path != null ? path.getLastElement() : "dCache";
    }

    private static class Attribute {
        final String name;
        final String value;

        Attribute(String iName, String iValue) {
            this.name = iName;
            this.value = iValue;
        }
    }
}

