/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.services.info.serialisation;

import java.util.Map;
import org.dcache.services.info.base.BooleanStateValue;
import org.dcache.services.info.base.FloatingPointStateValue;
import org.dcache.services.info.base.IntegerStateValue;
import org.dcache.services.info.base.StateExhibitor;
import org.dcache.services.info.base.StatePath;
import org.dcache.services.info.base.StringStateValue;
import org.dcache.services.info.serialisation.StateSerialiser;
import org.dcache.services.info.serialisation.SubtreeVisitor;

public class SimpleTextSerialiser
extends SubtreeVisitor
implements StateSerialiser {
    public static final String NAME = "simple";
    private static final String LIST_TYPE = "List item";
    private StringBuilder _result = new StringBuilder();
    private StatePath _lastStateComponentPath = null;
    private StatePath _startPath;
    private final StateExhibitor _exhibitor;

    public SimpleTextSerialiser(StateExhibitor exhibitor) {
        this._exhibitor = exhibitor;
    }

    @Override
    public String serialise(StatePath start) {
        this._result = new StringBuilder();
        this._startPath = start;
        if (start != null) {
            this.setVisitScopeToSubtree(start);
        } else {
            this.setVisitScopeToEverything();
        }
        if (start != null) {
            this._result.append(start.toString());
            this._result.append(">\n");
        }
        this._exhibitor.visitState(this);
        return this._result.toString();
    }

    @Override
    public String serialise() {
        return this.serialise(null);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void visitBoolean(StatePath path, BooleanStateValue value) {
        this.outputMetric(path, value.toString(), value.getTypeName());
        this._lastStateComponentPath = path;
    }

    @Override
    public void visitFloatingPoint(StatePath path, FloatingPointStateValue value) {
        this.outputMetric(path, value.toString(), value.getTypeName());
        this._lastStateComponentPath = path;
    }

    @Override
    public void visitInteger(StatePath path, IntegerStateValue value) {
        this.outputMetric(path, value.toString(), value.getTypeName());
        this._lastStateComponentPath = path;
    }

    @Override
    public void visitString(StatePath path, StringStateValue value) {
        this.outputMetric(path, "\"" + value + "\"", value.getTypeName());
        this._lastStateComponentPath = path;
    }

    @Override
    public void visitCompositePreDescend(StatePath path, Map<String, String> metadata) {
        if (!this.isInsideScope(path)) {
            return;
        }
        this._lastStateComponentPath = path;
    }

    @Override
    public void visitCompositePostDescend(StatePath path, Map<String, String> metadata) {
        if (!this.isInsideScope(path)) {
            return;
        }
        if (path != null && path.equals(this._lastStateComponentPath) && !path.isSimplePath()) {
            String className;
            String type = LIST_TYPE;
            if (metadata != null && (className = metadata.get("branch")) != null) {
                type = className;
            }
            this.outputMetric(path, "", type);
        }
    }

    private void outputMetric(StatePath path, String metricValue, String metricType) {
        if (this._startPath != null) {
            this._result.append("  ");
        }
        if (path != null) {
            this._result.append(path.toString(this._startPath));
        }
        this._result.append(":  ");
        this._result.append(metricValue);
        this._result.append(" [");
        this._result.append(metricType);
        this._result.append("]\n");
    }
}

