/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.services.info.serialisation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.dcache.services.info.base.BooleanStateValue;
import org.dcache.services.info.base.FloatingPointStateValue;
import org.dcache.services.info.base.IntegerStateValue;
import org.dcache.services.info.base.StateExhibitor;
import org.dcache.services.info.base.StatePath;
import org.dcache.services.info.base.StateValue;
import org.dcache.services.info.base.StringStateValue;
import org.dcache.services.info.serialisation.StateSerialiser;
import org.dcache.services.info.serialisation.SubtreeVisitor;

public class PrettyPrintTextSerialiser
extends SubtreeVisitor
implements StateSerialiser {
    private static final String ROOT_ELEMENT_LABEL = "dCache";
    private final StateExhibitor _exhibitor;
    private final Stack<Chunk> _lastChunkStack = new Stack();
    private final List<Chunk> _pendingChunks = new ArrayList<Chunk>();
    private StatePath _topMostElement;
    private StringBuilder _out;
    private boolean _foundSomething;
    private boolean _nextChunkHasStalk;

    public PrettyPrintTextSerialiser(StateExhibitor exhibitor) {
        this._exhibitor = exhibitor;
    }

    @Override
    public String getName() {
        return "pretty-print";
    }

    @Override
    public String serialise(StatePath path) {
        this.clearState();
        this._topMostElement = path;
        this.setVisitScopeToSubtree(path);
        this._exhibitor.visitState(this);
        String output = "";
        if (this._foundSomething) {
            String header = this.buildHeader(path.toString());
            this._out.append(header + "\n");
            this.flushPendingChunks();
            output = this._out.toString();
        }
        return output;
    }

    @Override
    public String serialise() {
        this.clearState();
        this._topMostElement = null;
        this.setVisitScopeToEverything();
        this._exhibitor.visitState(this);
        String header = this.buildHeader(null);
        this._out.append(header + "\n");
        this.flushPendingChunks();
        return this._out.toString();
    }

    public String buildHeader(String path) {
        StringBuilder sb = new StringBuilder();
        sb.append("[dCache");
        if (path != null) {
            sb.append("." + path);
        }
        sb.append("]");
        return sb.toString();
    }

    private void flushPendingChunks() {
        for (Chunk chunk : this._pendingChunks) {
            String chunkOutput = chunk.getOutput();
            this._out.append(chunkOutput);
        }
    }

    private void clearState() {
        this._out = new StringBuilder();
        this._pendingChunks.clear();
        this._foundSomething = false;
        this._nextChunkHasStalk = true;
        this._lastChunkStack.clear();
        this._lastChunkStack.add(new Chunk());
    }

    private boolean arePathsSame(StatePath p1, StatePath p2) {
        if (p1 == null && p2 == null) {
            return true;
        }
        return p1 == null ? false : p1.equals(p2);
    }

    @Override
    public void visitCompositePreDescend(StatePath path, Map<String, String> metadata) {
        if (!this.isInsideScope(path)) {
            return;
        }
        this._foundSomething = true;
        if (this.arePathsSame(path, this._topMostElement)) {
            return;
        }
        this.addBranchChunk(path.getLastElement(), metadata);
        this.descend();
        this._nextChunkHasStalk = true;
    }

    private void addBranchChunk(String name, Map<String, String> metadata) {
        String type = null;
        String idName = null;
        if (metadata != null) {
            type = metadata.get("branch");
            idName = metadata.get("id");
        }
        EndOfChunkItem item = type != null && idName != null ? new ListItem(this._nextChunkHasStalk, type, idName, name) : new BranchItem(this._nextChunkHasStalk, name);
        this.addSiblingChunk(item);
    }

    private Chunk getThisBranchLastChunk() {
        return (Chunk)this._lastChunkStack.lastElement();
    }

    private void setThisBranchLastChunk(Chunk chunk) {
        int lastItemIndex = this._lastChunkStack.size() - 1;
        this._lastChunkStack.set(lastItemIndex, chunk);
    }

    private void addSiblingChunk(EndOfChunkItem item) {
        Chunk siblingChunk = this.getThisBranchLastChunk();
        Chunk thisChunk = siblingChunk.newSiblingChunk(item);
        this._pendingChunks.add(thisChunk);
        this.setThisBranchLastChunk(thisChunk);
    }

    private void descend() {
        Chunk siblingChunk = this.getThisBranchLastChunk();
        this._lastChunkStack.add(siblingChunk.newPhantomChildChunk());
    }

    @Override
    public void visitCompositePostDescend(StatePath path, Map<String, String> metadata) {
        if (!this.isInsideScope(path)) {
            return;
        }
        Chunk lastChunk = this.getThisBranchLastChunk();
        lastChunk.setEndOfList();
        this.ascend();
    }

    private void ascend() {
        this._lastChunkStack.pop();
        this._nextChunkHasStalk = true;
    }

    @Override
    public void visitBoolean(StatePath path, BooleanStateValue value) {
        this.addMetricChunk(path, value);
    }

    @Override
    public void visitFloatingPoint(StatePath path, FloatingPointStateValue value) {
        this.addMetricChunk(path, value);
    }

    @Override
    public void visitInteger(StatePath path, IntegerStateValue value) {
        this.addMetricChunk(path, value);
    }

    @Override
    public void visitString(StatePath path, StringStateValue value) {
        this.addMetricChunk(path, value);
    }

    private void addMetricChunk(StatePath path, StateValue value) {
        String name = path.getLastElement();
        MetricItem item = new MetricItem(this._nextChunkHasStalk, name, value);
        this.addSiblingChunk(item);
        this._nextChunkHasStalk = false;
    }

    private static class ListItem
    extends EndOfChunkItem {
        private final String _label;

        public ListItem(boolean hasStalk, String type, String idName, String name) {
            super(hasStalk);
            this._label = "[" + type + ", " + idName + "=\"" + name + "\"]";
        }

        @Override
        String getItemLabel() {
            return this._label;
        }
    }

    private static class BranchItem
    extends EndOfChunkItem {
        private final String _label;

        public BranchItem(boolean hasStalk, String name) {
            super(hasStalk);
            this._label = "[" + name + "]";
        }

        @Override
        String getItemLabel() {
            return this._label;
        }
    }

    private static class MetricItem
    extends EndOfChunkItem {
        private final String _label;

        public MetricItem(boolean hasStalk, String name, StateValue metric) {
            super(hasStalk);
            String value = this.getValueOfMetric(metric);
            String type = metric.getTypeName();
            this._label = "-" + name + ": " + value + "  [" + type + "]";
        }

        private String getValueOfMetric(StateValue metricValue) {
            String value = metricValue instanceof StringStateValue ? "\"" + metricValue.toString() + "\"" : metricValue.toString();
            return value;
        }

        @Override
        String getItemLabel() {
            return this._label;
        }
    }

    private static abstract class EndOfChunkItem {
        private final boolean _hasStalk;

        public EndOfChunkItem(boolean hasStalk) {
            this._hasStalk = hasStalk;
        }

        public List<String> getOutput() {
            ArrayList<String> output = new ArrayList<String>();
            if (this._hasStalk) {
                output.add(" | \n");
            }
            output.add(" +-" + this.getItemLabel() + "\n");
            return output;
        }

        abstract String getItemLabel();
    }

    private static class Stem {
        public static final String STEM_ITEM = " | ";
        public static final String BLANK_ITEM = "   ";
        private boolean _visable = true;

        private Stem() {
        }

        public void setInvisable() {
            this._visable = false;
        }

        public String getOutput() {
            return this._visable ? STEM_ITEM : BLANK_ITEM;
        }
    }

    private static class Chunk {
        private static final EndOfChunkItem END_ITEM_FOR_PHANTOM_CHUNK = null;
        private final List<Stem> _stems = new ArrayList<Stem>();
        private final EndOfChunkItem _endItem;
        private Stem _stemForChild = null;

        public Chunk() {
            this(END_ITEM_FOR_PHANTOM_CHUNK, Collections.EMPTY_LIST);
        }

        public Chunk(List<Stem> stems) {
            this(END_ITEM_FOR_PHANTOM_CHUNK, stems);
        }

        public Chunk(EndOfChunkItem item, List<Stem> stems) {
            this._endItem = item;
            this._stems.addAll(stems);
        }

        public boolean isPhantom() {
            return this._endItem == END_ITEM_FOR_PHANTOM_CHUNK;
        }

        private Stem addNewEndStem() {
            Stem newStem = new Stem();
            this._stems.add(newStem);
            return newStem;
        }

        public String getOutput() {
            return this.isPhantom() ? "" : this.getNonPhantomOutput();
        }

        private String getNonPhantomOutput() {
            StringBuilder sb = new StringBuilder();
            String stemsPrefix = this.buildStemsPrefix();
            for (String endItemLine : this._endItem.getOutput()) {
                sb.append(stemsPrefix);
                sb.append(endItemLine);
            }
            return sb.toString();
        }

        private String buildStemsPrefix() {
            StringBuilder sb = new StringBuilder();
            for (Stem stem : this._stems) {
                sb.append(stem.getOutput());
            }
            return sb.toString();
        }

        public Chunk newSiblingChunk(EndOfChunkItem item) {
            return new Chunk(item, this._stems);
        }

        public Chunk newPhantomChildChunk() {
            Chunk childChunk = new Chunk(this._stems);
            this._stemForChild = childChunk.addNewEndStem();
            return childChunk;
        }

        public void setEndOfList() {
            if (this._stemForChild != null) {
                this._stemForChild.setInvisable();
            }
        }
    }
}

