/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.services.info.secondaryInfoProviders;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.dcache.services.info.base.IntegerStateValue;
import org.dcache.services.info.base.StateComposite;
import org.dcache.services.info.base.StateExhibitor;
import org.dcache.services.info.base.StatePath;
import org.dcache.services.info.base.StateUpdate;
import org.dcache.services.info.base.StringStateValue;
import org.dcache.services.info.secondaryInfoProviders.AbstractStateWatcher;
import org.dcache.services.info.stateInfo.ReservationInfo;
import org.dcache.services.info.stateInfo.ReservationInfoVisitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReservationByDescMaintainer
extends AbstractStateWatcher {
    private static Logger _log = LoggerFactory.getLogger(ReservationByDescMaintainer.class);
    public static final String PATH_ELEMENT_BY_DESCRIPTION_BRANCH = "by-description";
    public static final String PATH_ELEMENT_VO_NAME_METRIC = "vo";
    public static final String PATH_ELEMENT_SPACE_BRANCH = "space";
    public static final String PATH_ELEMENT_TOTAL_METRIC = "total";
    public static final String PATH_ELEMENT_ALLOCATED_METRIC = "allocated";
    public static final String PATH_ELEMENT_USED_METRIC = "used";
    public static final String PATH_ELEMENT_FREE_METRIC = "free";
    public static final String PATH_ELEMENT_RESERVATIONS_BRANCH = "reservations";
    public static final StatePath RESERVATIONS_BASE_PATH = StatePath.parsePath("summary.reservations.by-VO");
    private static final String[] PREDICATE_PATHS = new String[]{"reservations.*", "reservations.*.space.*", "reservations.*.description", "reservations.*.state", "reservations.*.authorisation.group"};

    @Override
    protected String[] getPredicates() {
        return PREDICATE_PATHS;
    }

    @Override
    public void trigger(StateUpdate update, StateExhibitor currentState, StateExhibitor futureState) {
        Map<String, ReservationInfo> currentResv = ReservationInfoVisitor.getDetails(currentState);
        Map<String, ReservationInfo> futureResv = ReservationInfoVisitor.getDetails(futureState);
        Map<String, Map<String, ReservationSummaryInfo>> currentSummary = this.buildSummaryInfo(currentResv);
        Map<String, Map<String, ReservationSummaryInfo>> futureSummary = this.buildSummaryInfo(futureResv);
        this.purgeMissingSummaries(update, currentSummary, futureSummary);
        this.addMetrics(update, currentSummary, futureSummary);
    }

    private Map<String, Map<String, ReservationSummaryInfo>> buildSummaryInfo(Map<String, ReservationInfo> reservations) {
        HashMap<String, Map<String, ReservationSummaryInfo>> summary = new HashMap<String, Map<String, ReservationSummaryInfo>>();
        for (Map.Entry<String, ReservationInfo> entry : reservations.entrySet()) {
            ReservationSummaryInfo thisSummary;
            String reservationId = entry.getKey();
            ReservationInfo info = entry.getValue();
            if (!info.hasState() || info.getState().isFinalState()) {
                _log.debug("ignoring reservation " + reservationId + " as state is undefined or final");
                continue;
            }
            if (!info.hasDescription() || info.getDescription().isEmpty()) {
                _log.debug("ignoring reservation " + reservationId + " as description is undefined or empty");
                continue;
            }
            if (!info.hasVo() || info.getVo().isEmpty()) {
                _log.debug("ignoring reservation " + reservationId + " as VO is undefined or empty");
                continue;
            }
            String voName = info.getVo();
            HashMap<String, ReservationSummaryInfo> thisVoSummary = (HashMap<String, ReservationSummaryInfo>)summary.get(voName);
            if (thisVoSummary == null) {
                thisVoSummary = new HashMap<String, ReservationSummaryInfo>();
                summary.put(voName, thisVoSummary);
            }
            if ((thisSummary = (ReservationSummaryInfo)thisVoSummary.get(info.getDescription())) == null) {
                thisSummary = new ReservationSummaryInfo();
                thisVoSummary.put(info.getDescription(), thisSummary);
            }
            thisSummary.addReservationInfo(reservationId, info);
        }
        return summary;
    }

    private void purgeMissingSummaries(StateUpdate update, Map<String, Map<String, ReservationSummaryInfo>> currentVoInfo, Map<String, Map<String, ReservationSummaryInfo>> futureVoInfo) {
        for (Map.Entry<String, Map<String, ReservationSummaryInfo>> voEntry : currentVoInfo.entrySet()) {
            String voName = voEntry.getKey();
            Set<String> currentDescriptions = voEntry.getValue().keySet();
            StatePath voBasePath = ReservationByDescMaintainer.buildVoPath(voName);
            Map<String, ReservationSummaryInfo> futureDescriptions = futureVoInfo.get(voName);
            if (futureDescriptions == null) {
                update.purgeUnder(voBasePath);
                continue;
            }
            for (String thisDescription : currentDescriptions) {
                if (futureDescriptions.containsKey(thisDescription)) continue;
                update.purgeUnder(ReservationByDescMaintainer.buildDescriptionPath(voBasePath, thisDescription));
            }
        }
    }

    private void addMetrics(StateUpdate update, Map<String, Map<String, ReservationSummaryInfo>> currentSummary, Map<String, Map<String, ReservationSummaryInfo>> futureSummary) {
        for (Map.Entry<String, Map<String, ReservationSummaryInfo>> voEntry : futureSummary.entrySet()) {
            String voName = voEntry.getKey();
            if (_log.isDebugEnabled()) {
                _log.debug("Checking vo " + voName);
            }
            Map<String, ReservationSummaryInfo> futureDescriptions = voEntry.getValue();
            Map<String, ReservationSummaryInfo> currentDescriptions = currentSummary.get(voName);
            StatePath voPath = ReservationByDescMaintainer.buildVoPath(voName);
            for (Map.Entry<String, ReservationSummaryInfo> entry : futureDescriptions.entrySet()) {
                ReservationSummaryInfo currentInfo;
                String description = entry.getKey();
                ReservationSummaryInfo futureInfo = entry.getValue();
                if (futureInfo.equals(currentInfo = currentDescriptions != null ? currentDescriptions.get(description) : null)) continue;
                futureInfo.updateMetrics(update, voName, ReservationByDescMaintainer.buildDescriptionPath(voPath, description), currentInfo);
            }
        }
    }

    private static StatePath buildVoPath(String voName) {
        if (voName == null) {
            throw new IllegalArgumentException("voName is null");
        }
        return RESERVATIONS_BASE_PATH.newChild(voName);
    }

    private static StatePath buildDescriptionPath(StatePath voBasePath, String description) {
        return voBasePath.newChild(PATH_ELEMENT_BY_DESCRIPTION_BRANCH).newChild(description);
    }

    private class ReservationSummaryInfo {
        private long _total;
        private long _free;
        private long _allocated;
        private long _used;
        private final Set<String> _ids = new HashSet<String>();

        private ReservationSummaryInfo() {
        }

        public int hashCode() {
            return (int)this._total ^ (int)this._free ^ (int)this._allocated ^ (int)this._used ^ ((Object)this._ids).hashCode();
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ReservationSummaryInfo)) {
                return false;
            }
            ReservationSummaryInfo otherSummary = (ReservationSummaryInfo)other;
            if (otherSummary._total != this._total || otherSummary._free != this._free || otherSummary._allocated != this._allocated || otherSummary._used != this._used) {
                return false;
            }
            return ((Object)otherSummary._ids).equals(this._ids);
        }

        public void addReservationInfo(String reservationId, ReservationInfo info) {
            if (info.hasTotal()) {
                this._total += info.getTotal();
            }
            if (info.hasUsed()) {
                this._used += info.getUsed();
            }
            if (info.hasFree()) {
                this._free += info.getFree();
            }
            if (info.hasAllocated()) {
                this._allocated += info.getAllocated();
            }
            this._ids.add(reservationId);
        }

        public boolean hasId(String ID) {
            return this._ids.contains(ID);
        }

        public long getTotal() {
            return this._total;
        }

        public long getUsed() {
            return this._used;
        }

        public long getFree() {
            return this._free;
        }

        public long getAllocated() {
            return this._allocated;
        }

        public boolean totalNeedsUpdating(ReservationSummaryInfo oldInfo) {
            return oldInfo == null || oldInfo.getTotal() != this.getTotal();
        }

        public boolean usedNeedsUpdating(ReservationSummaryInfo oldInfo) {
            return oldInfo == null || oldInfo.getUsed() != this.getUsed();
        }

        public boolean freeNeedsUpdating(ReservationSummaryInfo oldInfo) {
            return oldInfo == null || oldInfo.getFree() != this.getFree();
        }

        public boolean allocatedNeedsUpdating(ReservationSummaryInfo oldInfo) {
            return oldInfo == null || oldInfo.getAllocated() != this.getAllocated();
        }

        public void purgeMissingIds(StateUpdate update, StatePath basePath, ReservationSummaryInfo newInfo) {
            for (String id : this._ids) {
                if (newInfo.hasId(id)) continue;
                update.purgeUnder(basePath.newChild(id));
            }
        }

        public void updateMetrics(StateUpdate update, String voName, StatePath basePath, ReservationSummaryInfo oldInfo) {
            StatePath spacePath = basePath.newChild(ReservationByDescMaintainer.PATH_ELEMENT_SPACE_BRANCH);
            if (this.totalNeedsUpdating(oldInfo)) {
                update.appendUpdate(spacePath.newChild(ReservationByDescMaintainer.PATH_ELEMENT_TOTAL_METRIC), new IntegerStateValue(this.getTotal(), true));
            }
            if (this.freeNeedsUpdating(oldInfo)) {
                update.appendUpdate(spacePath.newChild(ReservationByDescMaintainer.PATH_ELEMENT_FREE_METRIC), new IntegerStateValue(this.getFree(), true));
            }
            if (this.allocatedNeedsUpdating(oldInfo)) {
                update.appendUpdate(spacePath.newChild(ReservationByDescMaintainer.PATH_ELEMENT_ALLOCATED_METRIC), new IntegerStateValue(this.getAllocated(), true));
            }
            if (this.usedNeedsUpdating(oldInfo)) {
                update.appendUpdate(spacePath.newChild(ReservationByDescMaintainer.PATH_ELEMENT_USED_METRIC), new IntegerStateValue(this.getUsed(), true));
            }
            StatePath resvPath = basePath.newChild(ReservationByDescMaintainer.PATH_ELEMENT_RESERVATIONS_BRANCH);
            if (oldInfo != null) {
                oldInfo.purgeMissingIds(update, resvPath, this);
                for (String newId : this._ids) {
                    if (oldInfo.hasId(newId)) continue;
                    update.appendUpdate(resvPath.newChild(newId), new StateComposite(true));
                }
            } else {
                update.appendUpdate(basePath.newChild(ReservationByDescMaintainer.PATH_ELEMENT_VO_NAME_METRIC), new StringStateValue(voName, true));
                for (String id : this._ids) {
                    update.appendUpdate(resvPath.newChild(id), new StateComposite(true));
                }
            }
        }
    }
}

