/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.services.info.secondaryInfoProviders;

import org.dcache.services.info.base.StateExhibitor;
import org.dcache.services.info.base.StatePath;
import org.dcache.services.info.base.StateUpdate;
import org.dcache.services.info.secondaryInfoProviders.AbstractStateWatcher;
import org.dcache.services.info.stateInfo.PoolSummaryVisitor;
import org.dcache.services.info.stateInfo.SpaceInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PoolsSummaryMaintainer
extends AbstractStateWatcher {
    private static Logger _log = LoggerFactory.getLogger(PoolsSummaryMaintainer.class);
    private static final String[] PREDICATE_PATHS = new String[]{"pools.*.space.*"};
    private static final StatePath SUMMARY_POOLS_SPACE_PATH = StatePath.parsePath("summary.pools.space");

    @Override
    protected String[] getPredicates() {
        return PREDICATE_PATHS;
    }

    @Override
    public void trigger(StateUpdate update, StateExhibitor currentState, StateExhibitor futureState) {
        super.trigger(update, currentState, futureState);
        if (_log.isInfoEnabled()) {
            _log.info("Watcher " + this.getClass().getSimpleName() + " triggered");
        }
        SpaceInfo info = PoolSummaryVisitor.getDetails(futureState);
        if (_log.isDebugEnabled()) {
            _log.debug("got summary: " + info.toString());
        }
        info.addMetrics(update, SUMMARY_POOLS_SPACE_PATH, true);
    }
}

