/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.services.info.secondaryInfoProviders;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.dcache.services.info.base.StateExhibitor;
import org.dcache.services.info.base.StatePath;
import org.dcache.services.info.base.StateUpdate;
import org.dcache.services.info.secondaryInfoProviders.AbstractStateWatcher;
import org.dcache.services.info.stateInfo.PoolSpaceVisitor;
import org.dcache.services.info.stateInfo.SetMapVisitor;
import org.dcache.services.info.stateInfo.SpaceInfo;

public class LinkSpaceMaintainer
extends AbstractStateWatcher {
    private static final String[] PREDICATE_PATHS = new String[]{"links.*", "links.*.pools.*", "pools.*.space.*"};
    private static final StatePath LINKS_PATH = new StatePath("links");
    private static final StatePath POOL_MEMBERSHIP_REL_PATH = new StatePath("pools");

    @Override
    protected String[] getPredicates() {
        return PREDICATE_PATHS;
    }

    @Override
    public void trigger(StateUpdate update, StateExhibitor currentState, StateExhibitor futureState) {
        super.trigger(update, currentState, futureState);
        Map<String, Set<String>> futureLinksToPools = SetMapVisitor.getDetails(futureState, LINKS_PATH, POOL_MEMBERSHIP_REL_PATH);
        Map<String, SpaceInfo> futurePoolSize = PoolSpaceVisitor.getDetails(futureState);
        HashSet<String> linksToUpdate = new HashSet<String>();
        this.addLinksWhereLinkHasChanged(currentState, linksToUpdate, futureLinksToPools);
        this.addLinksWherePoolsHaveChanged(currentState, linksToUpdate, futureLinksToPools, futurePoolSize);
        if (linksToUpdate.isEmpty()) {
            return;
        }
        for (String linkName : linksToUpdate) {
            this.addUpdateInfo(update, linkName, futureLinksToPools.get(linkName), futurePoolSize);
        }
    }

    private void addLinksWhereLinkHasChanged(StateExhibitor currentState, Set<String> linksToUpdate, Map<String, Set<String>> futureLinksToPools) {
        Map<String, Set<String>> currentLinksToPools = SetMapVisitor.getDetails(currentState, LINKS_PATH, POOL_MEMBERSHIP_REL_PATH);
        if (((Object)currentLinksToPools).equals(futureLinksToPools)) {
            return;
        }
        for (Map.Entry<String, Set<String>> linkEntry : futureLinksToPools.entrySet()) {
            String thisLinkName = linkEntry.getKey();
            if (currentLinksToPools.containsKey(thisLinkName)) {
                Set<String> thisLinkPools = linkEntry.getValue();
                if (((Object)thisLinkPools).equals(currentLinksToPools.get(thisLinkName))) continue;
                linksToUpdate.add(thisLinkName);
                continue;
            }
            linksToUpdate.add(thisLinkName);
        }
    }

    private void addLinksWherePoolsHaveChanged(StateExhibitor currentState, Set<String> linksToUpdate, Map<String, Set<String>> futureLinksToPools, Map<String, SpaceInfo> futurePoolSize) {
        Map<String, SpaceInfo> currentPoolSize = PoolSpaceVisitor.getDetails(currentState);
        if (((Object)futurePoolSize).equals(currentPoolSize)) {
            return;
        }
        for (Map.Entry<String, Set<String>> linkEntry : futureLinksToPools.entrySet()) {
            String thisLinkName = linkEntry.getKey();
            Set<String> thisLinkPools = linkEntry.getValue();
            for (String poolName : thisLinkPools) {
                if (currentPoolSize.containsKey(poolName)) {
                    if (currentPoolSize.get(poolName).equals(futurePoolSize.get(poolName))) continue;
                    linksToUpdate.add(thisLinkName);
                    continue;
                }
                linksToUpdate.add(thisLinkName);
            }
        }
    }

    private void addUpdateInfo(StateUpdate update, String linkName, Set<String> futureLinkPools, Map<String, SpaceInfo> futurePoolSize) {
        SpaceInfo linkSpaceInfo = new SpaceInfo();
        StatePath linkSpacePath = LINKS_PATH.newChild(linkName).newChild("space");
        for (String poolName : futureLinkPools) {
            linkSpaceInfo.add(futurePoolSize.get(poolName));
        }
        linkSpaceInfo.addMetrics(update, linkSpacePath, false);
    }
}

