/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.services.info.gathers.topo;

import dmg.cells.network.CellDomainNode;
import dmg.cells.nucleus.UOID;
import org.dcache.services.info.base.StatePath;
import org.dcache.services.info.base.StateUpdate;
import org.dcache.services.info.base.StateUpdateManager;
import org.dcache.services.info.base.StringStateValue;
import org.dcache.services.info.gathers.CellMessageHandlerSkel;
import org.dcache.services.info.gathers.MessageMetadataRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TopoMapHandler
extends CellMessageHandlerSkel {
    private static Logger _log = LoggerFactory.getLogger(TopoMapHandler.class);
    private static final StatePath DOMAINS_PATH = new StatePath("domains");

    public TopoMapHandler(StateUpdateManager sum, MessageMetadataRepository<UOID> msgMetaRepo) {
        super(sum, msgMetaRepo);
    }

    @Override
    public void process(Object msgPayload, long metricLifetime) {
        if (msgPayload == null) {
            return;
        }
        if (!msgPayload.getClass().isArray()) {
            _log.error("received a message that isn't an array");
            return;
        }
        Class<?> arrayClass = msgPayload.getClass().getComponentType();
        if (arrayClass == null) {
            _log.error("unable to figure out what array type is.");
            return;
        }
        if (!arrayClass.equals(CellDomainNode.class)) {
            _log.error("received array is not instance of CellDomainNode[]");
            return;
        }
        StateUpdate update = new StateUpdate();
        CellDomainNode[] domains = (CellDomainNode[])msgPayload;
        for (int i = 0; i < domains.length; ++i) {
            this.addDomain(update, domains[i], metricLifetime);
        }
        this.applyUpdates(update);
    }

    private void addDomain(StateUpdate update, CellDomainNode domain, long lifetime) {
        StatePath thisDomainPath = DOMAINS_PATH.newChild(domain.getName());
        update.appendUpdate(thisDomainPath.newChild("address"), new StringStateValue(domain.getAddress(), lifetime));
    }
}

