/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.services.info.gathers.routingmanager;

import dmg.cells.nucleus.UOID;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.dcache.services.info.base.StateComposite;
import org.dcache.services.info.base.StatePath;
import org.dcache.services.info.base.StateUpdate;
import org.dcache.services.info.base.StateUpdateManager;
import org.dcache.services.info.gathers.CellMessageHandlerSkel;
import org.dcache.services.info.gathers.MessageMetadataRepository;
import org.dcache.services.info.gathers.cells.CellInfoMsgHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RoutingMgrMsgHandler
extends CellMessageHandlerSkel {
    private static Logger _log = LoggerFactory.getLogger(CellInfoMsgHandler.class);
    private static final StatePath DOMAINS_PATH = new StatePath("domains");

    public RoutingMgrMsgHandler(StateUpdateManager sum, MessageMetadataRepository<UOID> msgMetaRepo) {
        super(sum, msgMetaRepo);
    }

    @Override
    public void process(Object msgPayload, long metricLifetime) {
        _log.debug("received msg.");
        if (!msgPayload.getClass().isArray()) {
            _log.error("received a reply message that isn't an array; type is " + msgPayload.getClass().getName());
            return;
        }
        Object[] result = (Object[])msgPayload;
        String domainName = (String)result[0];
        Set localExports = (Set)result[1];
        Map domainHash = (Map)result[2];
        HashMap<String, String> wellKnownCells = new HashMap<String, String>();
        this.buildWellKnownCells(wellKnownCells, domainName, localExports, domainHash);
        if (wellKnownCells.isEmpty() && localExports.isEmpty() && domainHash.isEmpty()) {
            _log.debug("Message from domain {} with no well-known cells", (Object)domainName);
            return;
        }
        StatePath routingPath = DOMAINS_PATH.newChild(domainName).newChild("routing");
        StateUpdate update = new StateUpdate();
        this.addWellKnownCells(update, routingPath, wellKnownCells, metricLifetime);
        this.addLocalCells(update, routingPath, localExports, metricLifetime);
        this.addRemoteCells(update, routingPath, domainHash, metricLifetime);
        this.applyUpdates(update);
    }

    private void buildWellKnownCells(Map<String, String> wellKnownCells, String domainName, Set<String> localExports, Map<String, Set<String>> domainHash) {
        for (Map.Entry<String, Set<String>> entry : domainHash.entrySet()) {
            String thisDomainName = entry.getKey();
            for (String thisCellName : entry.getValue()) {
                wellKnownCells.put(thisCellName, thisDomainName);
            }
        }
        for (String cellName : localExports) {
            wellKnownCells.put(cellName, domainName);
        }
    }

    private void addWellKnownCells(StateUpdate update, StatePath routingPath, Map<String, String> wellKnownCells, long metricLifetime) {
        StatePath namedCellsPath = routingPath.newChild("named-cells");
        for (Map.Entry<String, String> entry : wellKnownCells.entrySet()) {
            String thisCellName = entry.getKey();
            String thisDomainName = entry.getValue();
            StatePath thisEntryPath = namedCellsPath.newChild(thisCellName).newChild(thisDomainName);
            update.appendUpdate(thisEntryPath, new StateComposite(metricLifetime));
        }
    }

    private void addLocalCells(StateUpdate update, StatePath routingPath, Set<String> localCells, long metricLifetime) {
        StatePath localCellsPath = routingPath.newChild("local");
        for (String cellName : localCells) {
            StatePath thisCellPath = localCellsPath.newChild(cellName);
            update.appendUpdate(thisCellPath, new StateComposite(metricLifetime));
        }
    }

    private void addRemoteCells(StateUpdate update, StatePath routingPath, Map<String, Set<String>> domainHash, long metricLifetime) {
        StatePath remoteCellsPath = routingPath.newChild("remote");
        for (Map.Entry<String, Set<String>> entry : domainHash.entrySet()) {
            StatePath domainPath = remoteCellsPath.newChild(entry.getKey());
            for (String cellName : entry.getValue()) {
                StatePath cellPath = domainPath.newChild(cellName);
                update.appendUpdate(cellPath, new StateComposite(metricLifetime));
            }
        }
    }
}

