/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.services.info.gathers.poolmanager;

import diskCacheV111.pools.PoolCostInfo;
import diskCacheV111.vehicles.CostModulePoolInfoTable;
import dmg.cells.nucleus.UOID;
import java.util.Collection;
import java.util.Map;
import org.dcache.services.info.base.FloatingPointStateValue;
import org.dcache.services.info.base.IntegerStateValue;
import org.dcache.services.info.base.StatePath;
import org.dcache.services.info.base.StateUpdate;
import org.dcache.services.info.base.StateUpdateManager;
import org.dcache.services.info.base.StringStateValue;
import org.dcache.services.info.gathers.CellMessageHandlerSkel;
import org.dcache.services.info.gathers.MessageMetadataRepository;
import org.dcache.services.info.stateInfo.SpaceInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PoolCostMsgHandler
extends CellMessageHandlerSkel {
    private static Logger _log = LoggerFactory.getLogger(PoolCostMsgHandler.class);

    public PoolCostMsgHandler(StateUpdateManager sum, MessageMetadataRepository<UOID> msgMetaRepo) {
        super(sum, msgMetaRepo);
    }

    @Override
    public void process(Object msgPayload, long msgDeliveryPeriod) {
        long metricLifetime = (long)((double)msgDeliveryPeriod * 2.5);
        if (!(msgPayload instanceof CostModulePoolInfoTable)) {
            _log.error("received non-CostModulePoolInfoTable object in message\n");
            return;
        }
        CostModulePoolInfoTable poolInfoTbl = (CostModulePoolInfoTable)msgPayload;
        Collection<PoolCostInfo> poolInfos = poolInfoTbl.poolInfos();
        if (poolInfos.size() > 0) {
            StateUpdate update = this.buildUpdate(poolInfos, metricLifetime);
            this.applyUpdates(update);
        }
    }

    private StateUpdate buildUpdate(Collection<PoolCostInfo> poolInfos, long metricLifetime) {
        StatePath poolsPath = new StatePath("pools");
        StateUpdate update = new StateUpdate();
        for (PoolCostInfo thisPoolInfo : poolInfos) {
            String poolName = thisPoolInfo.getPoolName();
            StatePath pathToThisPool = poolsPath.newChild(poolName);
            StatePath pathToQueues = pathToThisPool.newChild("queues");
            this.addQueueInfo(update, pathToQueues, "store", thisPoolInfo.getStoreQueue(), metricLifetime);
            this.addQueueInfo(update, pathToQueues, "restore", thisPoolInfo.getRestoreQueue(), metricLifetime);
            this.addQueueInfo(update, pathToQueues, "mover", thisPoolInfo.getMoverQueue(), metricLifetime);
            this.addQueueInfo(update, pathToQueues, "p2p-queue", thisPoolInfo.getP2pQueue(), metricLifetime);
            this.addQueueInfo(update, pathToQueues, "p2p-clientqueue", thisPoolInfo.getP2pClientQueue(), metricLifetime);
            this.addNamedQueues(update, pathToQueues, thisPoolInfo, metricLifetime);
            String defaultQueue = thisPoolInfo.getDefaultQueueName();
            if (defaultQueue != null) {
                update.appendUpdate(pathToQueues.newChild("default-queue"), new StringStateValue(defaultQueue, metricLifetime));
            }
            this.addSpaceInfo(update, pathToThisPool.newChild("space"), thisPoolInfo.getSpaceInfo(), metricLifetime);
        }
        return update;
    }

    private void addQueueInfo(StateUpdate stateUpdate, StatePath pathToQueues, String queueName, PoolCostInfo.PoolQueueInfo info, long lifetime) {
        StatePath queuePath = pathToQueues.newChild(queueName);
        stateUpdate.appendUpdate(queuePath.newChild("active"), new IntegerStateValue((long)info.getActive(), lifetime));
        stateUpdate.appendUpdate(queuePath.newChild("max-active"), new IntegerStateValue((long)info.getMaxActive(), lifetime));
        stateUpdate.appendUpdate(queuePath.newChild("queued"), new IntegerStateValue((long)info.getQueued(), lifetime));
    }

    private void addSpaceInfo(StateUpdate stateUpdate, StatePath pathToSpace, PoolCostInfo.PoolSpaceInfo info, long lifetime) {
        SpaceInfo si = new SpaceInfo(info);
        si.addMetrics(stateUpdate, pathToSpace, lifetime);
        stateUpdate.appendUpdate(pathToSpace.newChild("gap"), new IntegerStateValue(info.getGap(), lifetime));
        stateUpdate.appendUpdate(pathToSpace.newChild("break-even"), new FloatingPointStateValue(info.getBreakEven(), lifetime));
        stateUpdate.appendUpdate(pathToSpace.newChild("LRU-seconds"), new IntegerStateValue(info.getLRUSeconds(), lifetime));
    }

    private void addNamedQueues(StateUpdate update, StatePath pathToQueues, PoolCostInfo thisPoolInfo, long lifetime) {
        Map<String, PoolCostInfo.NamedPoolQueueInfo> namedQueuesInfo = thisPoolInfo.getExtendedMoverHash();
        if (namedQueuesInfo == null) {
            return;
        }
        StatePath pathToNamedQueues = pathToQueues.newChild("named-queues");
        for (PoolCostInfo.NamedPoolQueueInfo thisNamedQueueInfo : namedQueuesInfo.values()) {
            this.addQueueInfo(update, pathToNamedQueues, thisNamedQueueInfo.getName(), thisNamedQueueInfo, lifetime);
        }
    }
}

