/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.services.info.gathers;

import diskCacheV111.services.space.Space;
import diskCacheV111.services.space.message.GetSpaceTokensMessage;
import diskCacheV111.vehicles.Message;
import java.util.Date;
import java.util.Set;
import org.dcache.services.info.base.IntegerStateValue;
import org.dcache.services.info.base.StateComposite;
import org.dcache.services.info.base.StatePath;
import org.dcache.services.info.base.StateUpdate;
import org.dcache.services.info.base.StateUpdateManager;
import org.dcache.services.info.base.StringStateValue;
import org.dcache.services.info.gathers.CellMessageHandlerSkel;
import org.dcache.services.info.gathers.MessageHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SrmSpaceDetailsMsgHandler
implements MessageHandler {
    private static Logger _log = LoggerFactory.getLogger(SrmSpaceDetailsMsgHandler.class);
    private static final StatePath SPACES_PATH = StatePath.parsePath("reservations");
    private static final StatePath LINKGROUPS = new StatePath("linkgroups");
    private static final String SRM_ROLE_WILDCARD = "*";
    private final StateUpdateManager _sum;

    public SrmSpaceDetailsMsgHandler(StateUpdateManager sum) {
        this._sum = sum;
    }

    @Override
    public boolean handleMessage(Message messagePayload, long metricLifetime) {
        GetSpaceTokensMessage msg;
        Set<Space> spaces;
        if (!(messagePayload instanceof GetSpaceTokensMessage)) {
            return false;
        }
        if (_log.isInfoEnabled()) {
            _log.info("received spacetokens details msg.");
        }
        if ((spaces = (msg = (GetSpaceTokensMessage)messagePayload).getSpaceTokenSet()).size() == 0) {
            _log.info("received GetSpaceTokensMessage with no spaces listed");
            return true;
        }
        StateUpdate update = new StateUpdate();
        for (Space space : spaces) {
            StatePath thisSpacePath = SPACES_PATH.newChild(String.valueOf(space.getId()));
            if (space.getDescription() != null) {
                update.appendUpdate(thisSpacePath.newChild("description"), new StringStateValue(space.getDescription(), metricLifetime));
            }
            update.appendUpdate(thisSpacePath.newChild("access-latency"), new StringStateValue(space.getAccessLatency().toString(), metricLifetime));
            update.appendUpdate(thisSpacePath.newChild("retention-policy"), new StringStateValue(space.getRetentionPolicy().toString(), metricLifetime));
            StatePath spacePath = thisSpacePath.newChild("space");
            update.appendUpdate(spacePath.newChild("free"), new IntegerStateValue(space.getAvailableSpaceInBytes(), metricLifetime));
            update.appendUpdate(spacePath.newChild("used"), new IntegerStateValue(space.getUsedSizeInBytes(), metricLifetime));
            update.appendUpdate(spacePath.newChild("allocated"), new IntegerStateValue(space.getAllocatedSpaceInBytes(), metricLifetime));
            update.appendUpdate(spacePath.newChild("total"), new IntegerStateValue(space.getSizeInBytes(), metricLifetime));
            Date creationDate = new Date(space.getCreationTime());
            CellMessageHandlerSkel.addTimeMetrics(update, thisSpacePath.newChild("created"), creationDate, metricLifetime);
            update.appendUpdate(thisSpacePath.newChild("id"), new StringStateValue(String.valueOf(space.getId()), metricLifetime));
            update.appendUpdate(thisSpacePath.newChild("state"), new StringStateValue(space.getState().toString(), metricLifetime));
            long spaceLifetime = space.getLifetime();
            if (spaceLifetime > 0L) {
                update.appendUpdate(thisSpacePath.newChild("lifetime"), new IntegerStateValue(spaceLifetime, metricLifetime));
            }
            this.addLinkgroup(update, thisSpacePath, String.valueOf(space.getLinkGroupId()), String.valueOf(space.getId()), metricLifetime);
            this.addVoInfo(update, thisSpacePath.newChild("authorisation"), space.getVoGroup(), space.getVoRole(), metricLifetime);
        }
        this._sum.enqueueUpdate(update);
        return true;
    }

    private void addVoInfo(StateUpdate update, StatePath parentPath, String group, String role, long metricLifetime) {
        if (role != null) {
            update.appendUpdate(parentPath.newChild("role"), new StringStateValue(role, metricLifetime));
        }
        if (group != null) {
            update.appendUpdate(parentPath.newChild("group"), new StringStateValue(group, metricLifetime));
            StringBuilder fqan = new StringBuilder();
            fqan.append(group);
            if (role != null && !role.equals(SRM_ROLE_WILDCARD)) {
                fqan.append("/Role=");
                fqan.append(role);
            }
            update.appendUpdate(parentPath.newChild("FQAN"), new StringStateValue(fqan.toString(), metricLifetime));
        }
    }

    private void addLinkgroup(StateUpdate update, StatePath parentPath, String lgid, String spaceId, long metricLifetime) {
        update.appendUpdate(parentPath.newChild("linkgroupref"), new StringStateValue(lgid, metricLifetime));
        update.appendUpdate(LINKGROUPS.newChild(lgid).newChild("reservations").newChild(spaceId), new StateComposite(metricLifetime));
    }
}

