/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.services.info.gathers;

import java.util.Date;
import java.util.Random;
import org.dcache.services.info.base.StateComposite;
import org.dcache.services.info.base.StatePath;
import org.dcache.services.info.base.StateUpdate;
import org.dcache.services.info.base.StateUpdateManager;
import org.dcache.services.info.gathers.Schedulable;
import org.dcache.services.info.stateInfo.SpaceInfo;

public class PseudoPoolDga
implements Schedulable {
    private static final int NUM_SD = 4;
    private static final int SAFETY_MARGIN = 2;
    private static final long BYTES_IN_GIBIBYTE = 0x40000000L;
    private static final StatePath DEFAULT_POOLGROUP_MEMBERSHIP = StatePath.parsePath("poolgroups.default.pools");
    static final double PRECIOUS_ADD_LIKELIHOOD = 0.5;
    static final double PRECIOUS_ADD_DELTA = 0.01;
    static final double PRECIOUS_ADD_SPREAD = 0.01;
    static final double PRECIOUS_DEL_DELTA = 0.1;
    static final double PRECIOUS_DEL_SPREAD = 0.01;
    static final double PRECIOUS_DEL_SUPPRESS = 0.01;
    static final double REMOVABLE_ADD_LIKELIHOOD = 0.8;
    static final double REMOVABLE_ADD_MAX_FRAC = 0.03;
    static final double REMOVABLE_ADD_EXP = 0.05;
    static final double REMOVABLE_DEL_DELTA = 0.3;
    static final double REMOVABLE_DEL_SPREAD = 0.05;
    static final double REMOVABLE_DEL_SUPPRESS = 0.01;
    private final String _poolName;
    private final SpaceInfo _spaceInfo;
    private final StatePath _ourSpacePath;
    private StatePath _ourPgMembership;
    private final int _delay;
    private final int _spread;
    private final long _metricLifetime;
    private final long _maxDelay;
    private final Random _rnd = new Random();
    private final StateUpdateManager _sum;

    public PseudoPoolDga(StateUpdateManager sum, String poolName, int updatePeriod, long capacity) {
        this._poolName = poolName;
        this._sum = sum;
        StatePath pools = new StatePath("pools");
        this._ourSpacePath = pools.newChild(poolName).newChild("space");
        this._delay = updatePeriod;
        this._spread = (int)(0.05 * (double)updatePeriod);
        this._maxDelay = this._delay + 4 * this._spread;
        this._metricLifetime = this._maxDelay / 1000L + 2L;
        this._ourPgMembership = DEFAULT_POOLGROUP_MEMBERSHIP.newChild(poolName);
        this._spaceInfo = new SpaceInfo(capacity * 0x40000000L);
    }

    @Override
    public Date shouldNextBeTriggered() {
        long thisDelay = (long)this._delay + (long)(this._rnd.nextGaussian() * (double)this._spread);
        if (thisDelay > this._maxDelay) {
            thisDelay = this._maxDelay;
        }
        return new Date(System.currentTimeMillis() + thisDelay);
    }

    @Override
    public void trigger() {
        this.updateSpace();
        StateUpdate update = new StateUpdate();
        update.appendUpdate(this._ourPgMembership, new StateComposite(this._metricLifetime));
        this._spaceInfo.addMetrics(update, this._ourSpacePath, this._metricLifetime);
        this._sum.enqueueUpdate(update);
    }

    private void updateSpace() {
        long size;
        if ((double)this._rnd.nextFloat() < 0.5) {
            this._spaceInfo.updatePrecious((long)((double)this._spaceInfo.getTotal() * 0.01 * (1.0 + this._rnd.nextGaussian() * 0.01)));
        }
        double freeFrac = (double)this._spaceInfo.getFree() / (double)this._spaceInfo.getTotal();
        if (this._rnd.nextDouble() > 0.01 * Math.pow(freeFrac, 5.0)) {
            size = (long)((double)this._spaceInfo.getPrecious() * 0.1 * (1.0 + this._rnd.nextGaussian() * 0.01));
            this._spaceInfo.updatePrecious(-size);
        }
        if ((double)this._rnd.nextFloat() < 0.8) {
            size = (long)((double)this._spaceInfo.getTotal() * 0.03 * Math.exp(-this._rnd.nextDouble() / 0.05));
            this._spaceInfo.updateRemovable(size);
        }
        if (this._rnd.nextDouble() > 0.01 * Math.pow(freeFrac, 5.0)) {
            size = (long)((double)this._spaceInfo.getPrecious() * 0.3 * (1.0 + this._rnd.nextGaussian() * 0.05));
            this._spaceInfo.updatePrecious(-size);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._poolName + "]";
    }
}

