/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.services.info.gathers;

import diskCacheV111.vehicles.Message;
import dmg.cells.nucleus.CellEndpoint;
import dmg.cells.nucleus.CellMessage;
import dmg.cells.nucleus.CellMessageAnswerable;
import dmg.cells.nucleus.CellPath;
import dmg.cells.nucleus.NoRouteToCellException;
import dmg.cells.nucleus.SerializationException;
import dmg.cells.nucleus.UOID;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.dcache.services.info.base.StateUpdateManager;
import org.dcache.services.info.gathers.LinkgroupDetailsMsgHandler;
import org.dcache.services.info.gathers.LinkgroupListMsgHandler;
import org.dcache.services.info.gathers.MessageHandler;
import org.dcache.services.info.gathers.MessageMetadataRepository;
import org.dcache.services.info.gathers.MessageSender;
import org.dcache.services.info.gathers.SrmSpaceDetailsMsgHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageHandlerChain
implements MessageMetadataRepository<UOID>,
MessageSender,
CellMessageAnswerable {
    private static final long METADATA_FLUSH_THRESHOLD = 3600000L;
    private static final long METADATA_FLUSH_PERIOD = 600000L;
    private static final long STANDARD_TIMEOUT = 1000L;
    private static final Logger _log = LoggerFactory.getLogger(MessageHandlerChain.class);
    private List<MessageHandler> _messageHandler = new LinkedList<MessageHandler>();
    private final CellEndpoint _endpoint;
    private final StateUpdateManager _sum;
    private final Map<UOID, MessageMetadata> _msgMetadata = new HashMap<UOID, MessageMetadata>();
    private Date _nextFlushOldMetadata;

    public MessageHandlerChain(StateUpdateManager sum, CellEndpoint endpoint) {
        this._sum = sum;
        this._endpoint = endpoint;
    }

    public void addMessageHandler(MessageHandler handler) {
        _log.debug("Adding MessageHandler " + handler.getClass().getCanonicalName());
        this._messageHandler.add(handler);
    }

    public String[] listMessageHandlers() {
        int i = 0;
        String[] msgHandlers = new String[this._messageHandler.size()];
        for (MessageHandler mh : this._messageHandler) {
            msgHandlers[i++] = mh.getClass().getSimpleName();
        }
        return msgHandlers;
    }

    @Override
    public void sendMessage(long ttl, CellMessageAnswerable handler, CellPath path, String requestString) {
        if (handler == null) {
            _log.error("ignoring attempt to send string-based message without call-back");
            return;
        }
        CellMessage envelope = new CellMessage(path, (Object)requestString);
        this.sendMessage(ttl, handler, envelope);
    }

    @Override
    public void sendMessage(long ttl, CellPath path, Message message) {
        CellMessage envelope = new CellMessage(path, (Object)message);
        this.sendMessage(ttl, null, envelope);
    }

    @Override
    public void sendMessage(long ttl, CellMessageAnswerable handler, CellMessage envelope) throws SerializationException {
        this.putMetricTTL(envelope.getUOID(), ttl);
        this._endpoint.sendMessage(envelope, (CellMessageAnswerable)(handler != null ? handler : this), 1000L);
    }

    public void addDefaultHandlers() {
        this.addMessageHandler(new LinkgroupListMsgHandler(this._sum));
        this.addMessageHandler(new LinkgroupDetailsMsgHandler(this._sum));
        this.addMessageHandler(new SrmSpaceDetailsMsgHandler(this._sum));
    }

    @Override
    public boolean containsMetricTTL(UOID messageId) {
        return this._msgMetadata.containsKey(messageId);
    }

    @Override
    public long getMetricTTL(UOID messageId) {
        this.flushOldMetadata();
        if (_log.isDebugEnabled()) {
            _log.debug("Querying for metric ttl stored against message-ID " + messageId);
        }
        if (!this._msgMetadata.containsKey(messageId)) {
            throw new IllegalArgumentException("No metadata recorded for message " + messageId);
        }
        MessageMetadata metadata = this._msgMetadata.get(messageId);
        return metadata._ttl;
    }

    @Override
    public void remove(UOID messageId) {
        if (!this._msgMetadata.containsKey(messageId)) {
            throw new IllegalArgumentException("No metadata recorded for message " + messageId);
        }
        this._msgMetadata.remove(messageId);
    }

    @Override
    public void putMetricTTL(UOID messageId, long ttl) {
        if (messageId == null) {
            throw new NullPointerException("Attempting to record ttl against null messageId");
        }
        if (_log.isDebugEnabled()) {
            _log.debug("Adding metric ttl " + ttl + " against message-ID " + messageId);
        }
        this._msgMetadata.put(messageId, new MessageMetadata(ttl));
    }

    private void flushOldMetadata() {
        Date now = new Date();
        if (this._nextFlushOldMetadata != null && now.before(this._nextFlushOldMetadata)) {
            return;
        }
        Iterator<MessageMetadata> itr = this._msgMetadata.values().iterator();
        while (itr.hasNext()) {
            MessageMetadata item = itr.next();
            if (now.getTime() - item._timeSent.getTime() <= 3600000L) continue;
            itr.remove();
        }
        this._nextFlushOldMetadata = new Date(System.currentTimeMillis() + 600000L);
    }

    public void answerArrived(CellMessage request, CellMessage answer) {
        Object messagePayload = answer.getMessageObject();
        if (!(messagePayload instanceof Message)) {
            _log.debug("Received msg where payload is not instanceof Message");
            return;
        }
        if (!this.containsMetricTTL(request.getLastUOID())) {
            _log.error("Attempt to add metrics without recorded metric TTL for msg " + request);
            return;
        }
        for (MessageHandler mh : this._messageHandler) {
            if (!mh.handleMessage((Message)messagePayload, this.getMetricTTL(request.getLastUOID()))) continue;
            return;
        }
    }

    public void answerTimedOut(CellMessage request) {
        this.remove(request.getLastUOID());
        _log.info("Message timed out");
    }

    public void exceptionArrived(CellMessage request, Exception exception) {
        this.remove(request.getLastUOID());
        if (exception instanceof NoRouteToCellException) {
            _log.debug("Sending message to {} failed: {}", (Object)((NoRouteToCellException)((Object)exception)).getDestinationPath(), (Object)exception.getMessage());
        } else if (exception instanceof IllegalArgumentException) {
            _log.debug("Command failed: {}", (Object)exception.getMessage());
        } else {
            _log.error("Received remote exception: ", (Throwable)exception);
        }
    }

    private static class MessageMetadata {
        Date _timeSent = new Date();
        final long _ttl;

        MessageMetadata(long ttl) {
            this._ttl = ttl;
        }
    }
}

