/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.services.info.gathers;

import dmg.cells.nucleus.UOID;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.ServiceLoader;
import org.dcache.commons.util.NDC;
import org.dcache.services.info.base.StateExhibitor;
import org.dcache.services.info.base.StateUpdateManager;
import org.dcache.services.info.gathers.DgaFactoryService;
import org.dcache.services.info.gathers.MessageMetadataRepository;
import org.dcache.services.info.gathers.MessageSender;
import org.dcache.services.info.gathers.Schedulable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataGatheringScheduler
implements Runnable {
    private static final long FIVE_MINUTES = 300000L;
    private boolean _timeToQuit = false;
    private final List<RegisteredActivity> _activity = new ArrayList<RegisteredActivity>();
    private static Logger _logSched = LoggerFactory.getLogger(DataGatheringScheduler.class);
    private static Logger _logRa = LoggerFactory.getLogger(RegisteredActivity.class);
    private final StateUpdateManager _sum;

    public DataGatheringScheduler(StateUpdateManager sum) {
        this._sum = sum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Date now = new Date();
        _logSched.debug("DGA Scheduler thread starting.");
        List<RegisteredActivity> list = this._activity;
        synchronized (list) {
            do {
                now.setTime(System.currentTimeMillis());
                for (RegisteredActivity pa : this._activity) {
                    pa.checkAndTrigger(now);
                }
                long delay = this.getWaitTimeout();
                try {
                    this._activity.wait(delay);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            } while (!this._timeToQuit);
        }
        _logSched.debug("DGA Scheduler thread shutting down.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addActivity(Schedulable dga) {
        RegisteredActivity pa = new RegisteredActivity(dga);
        List<RegisteredActivity> list = this._activity;
        synchronized (list) {
            this._activity.add(pa);
            this._activity.notify();
        }
    }

    private RegisteredActivity findActivity(String name) {
        RegisteredActivity foundPA = null;
        for (RegisteredActivity pa : this._activity) {
            if (!pa.toString().equals(name)) continue;
            foundPA = pa;
            break;
        }
        return foundPA;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String enableActivity(String name) {
        RegisteredActivity pa = null;
        boolean haveEnabled = false;
        List<RegisteredActivity> list = this._activity;
        synchronized (list) {
            pa = this.findActivity(name);
            if (pa != null && !pa._enabled) {
                pa.enable();
                this._activity.notify();
                haveEnabled = true;
            }
        }
        return haveEnabled ? null : (pa == null ? "Unknown DGA " + name : "DGA " + name + " already enabled");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String disableActivity(String name) {
        RegisteredActivity pa = null;
        boolean haveDisabled = false;
        List<RegisteredActivity> list = this._activity;
        synchronized (list) {
            pa = this.findActivity(name);
            if (pa != null && pa._enabled) {
                pa.disable();
                this._activity.notify();
                haveDisabled = true;
            }
        }
        return haveDisabled ? null : (pa == null ? "Unknown DGA " + name : "DGA " + name + " already disabled");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String triggerActivity(String name) {
        RegisteredActivity pa = null;
        List<RegisteredActivity> list = this._activity;
        synchronized (list) {
            pa = this.findActivity(name);
            if (pa != null) {
                pa.shouldTriggerNow();
                this._activity.notify();
            }
        }
        return pa != null ? null : "Unknown DGA " + name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        _logSched.debug("Requesting DGA Scheduler to shutdown.");
        List<RegisteredActivity> list = this._activity;
        synchronized (list) {
            this._timeToQuit = true;
            this._activity.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getWaitTimeout() {
        long earliestTrig = 0L;
        List<RegisteredActivity> list = this._activity;
        synchronized (list) {
            for (RegisteredActivity thisPa : this._activity) {
                long thisTrig;
                if (!thisPa.isEnabled() || (thisTrig = thisPa.getNextTriggered()) >= earliestTrig && earliestTrig != 0L) continue;
                earliestTrig = thisTrig;
            }
        }
        long delay = 0L;
        if (earliestTrig > 0L) {
            delay = earliestTrig - System.currentTimeMillis();
            delay = delay < 1L ? 1L : delay;
        }
        return delay;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> listActivity() {
        ArrayList<String> activityList = new ArrayList<String>();
        List<RegisteredActivity> list = this._activity;
        synchronized (list) {
            for (RegisteredActivity thisRa : this._activity) {
                activityList.add(thisRa.getStatus());
            }
        }
        return activityList;
    }

    public void addActivity(StateExhibitor exhibitor, MessageSender sender, MessageMetadataRepository<UOID> msgMetaRepo) {
        ServiceLoader<DgaFactoryService> loader = ServiceLoader.load(DgaFactoryService.class);
        for (DgaFactoryService ds : loader) {
            for (Schedulable dga : ds.createDgas(exhibitor, sender, this._sum, msgMetaRepo)) {
                this.addActivity(dga);
            }
        }
    }

    private static class RegisteredActivity {
        private static final long MINIMUM_DGA_DELAY = 400L;
        private final Schedulable _dga;
        private Date _nextTriggered;
        private boolean _enabled = true;

        RegisteredActivity(Schedulable dga) {
            this._dga = dga;
            this.updateNextTrigger();
        }

        private final void updateNextTrigger() {
            Date nextTrigger = this._dga.shouldNextBeTriggered();
            if (nextTrigger == null) {
                _logRa.error("registered dga returned null Date");
                nextTrigger = new Date(System.currentTimeMillis() + 300000L);
            } else if (nextTrigger.getTime() - System.currentTimeMillis() < 400L) {
                _logRa.warn("DGA " + this._dga.toString() + " triggering too quickly (" + (nextTrigger.getTime() - System.currentTimeMillis()) + "ms): engaging safety.");
                nextTrigger = new Date(System.currentTimeMillis() + 400L);
            }
            this._nextTriggered = nextTrigger;
        }

        public void shouldTriggerNow() {
            this._nextTriggered = new Date();
        }

        boolean checkAndTrigger(Date now) {
            if (!this._enabled) {
                return false;
            }
            if (now.before(this._nextTriggered)) {
                return false;
            }
            NDC.push((String)this._dga.toString());
            this._dga.trigger();
            NDC.pop();
            this.updateNextTrigger();
            return true;
        }

        long getDelay() {
            long delay = this._nextTriggered.getTime() - System.currentTimeMillis();
            return delay > 0L ? delay : 0L;
        }

        long getNextTriggered() {
            return this._nextTriggered.getTime();
        }

        boolean isEnabled() {
            return this._enabled;
        }

        void disable() {
            this._enabled = false;
        }

        void enable() {
            if (!this._enabled) {
                this._enabled = true;
                this.updateNextTrigger();
            }
        }

        public String toString() {
            return this._dga.toString();
        }

        public String getStatus() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.toString());
            sb.append(" [");
            sb.append(this._enabled ? "enabled" : "disabled");
            if (this._enabled) {
                sb.append(String.format(", next %1$.1fs", (double)this.getDelay() / 1000.0));
            }
            sb.append("]");
            return sb.toString();
        }
    }
}

