/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.services.info.conduits;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import org.dcache.services.info.base.StateExhibitor;
import org.dcache.services.info.conduits.AbstractThreadedConduit;
import org.dcache.services.info.serialisation.XmlSerialiser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmlConduit
extends AbstractThreadedConduit {
    private static Logger _log = LoggerFactory.getLogger(XmlConduit.class);
    private static final int DEFAULT_PORT = 22112;
    public int _port = 22112;
    private ServerSocket _svr_skt = null;
    private final XmlSerialiser _xmlSerialiser;

    public XmlConduit(StateExhibitor exhibitor) {
        this._xmlSerialiser = new XmlSerialiser(exhibitor);
    }

    @Override
    public void enable() {
        try {
            this._svr_skt = new ServerSocket(this._port, 5, InetAddress.getByName(null));
        }
        catch (IOException e) {
            Thread.currentThread().interrupt();
            return;
        }
        catch (SecurityException e) {
            _log.error("security issue creating port " + this._port, (Throwable)e);
            return;
        }
        super.enable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void triggerBlockingActivityToReturn() {
        if (this._svr_skt == null) {
            return;
        }
        try {
            this._svr_skt.close();
        }
        catch (IOException e) {
            _log.error("Problem closing server socket", (Throwable)e);
        }
        finally {
            this._svr_skt = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void blockingActivity() {
        Socket skt = null;
        try {
            skt = this._svr_skt.accept();
        }
        catch (SocketException e) {
            if (this._svr_skt != null && (this._should_run || !this._svr_skt.isClosed())) {
                _log.error("accept() failed", (Throwable)e);
            }
        }
        catch (IOException e) {
            Thread.currentThread().interrupt();
            return;
        }
        catch (SecurityException e) {
            _log.error("accept() failed for security reasons", (Throwable)e);
            return;
        }
        catch (Exception e) {
            _log.error("accept() failed for an unknown reason", (Throwable)e);
            return;
        }
        if (skt != null) {
            if (_log.isInfoEnabled()) {
                _log.info("Incoming connection from " + skt.toString());
            }
            try {
                ++this._callCount;
                String xmlData = this._xmlSerialiser.serialise();
                skt.getOutputStream().write(xmlData.getBytes());
            }
            catch (IOException e) {
                _log.error("failed to write XML data", (Throwable)e);
            }
            catch (Exception e) {
                _log.error("unknown failure writing XML data", (Throwable)e);
            }
            finally {
                try {
                    skt.close();
                }
                catch (IOException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }
}

