/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.services.info.conduits;

import org.dcache.services.info.conduits.Conduit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractThreadedConduit
implements Runnable,
Conduit {
    private static Logger _log = LoggerFactory.getLogger(AbstractThreadedConduit.class);
    private Thread _thd = null;
    protected int _callCount = 0;
    volatile boolean _should_run = true;

    AbstractThreadedConduit() {
    }

    @Override
    public void enable() {
        this._callCount = 0;
        this._should_run = true;
        if (this._thd == null) {
            this._thd = new Thread((Runnable)this, this.getClass().getSimpleName() + " conduit");
            this._thd.start();
            if (_log.isInfoEnabled()) {
                _log.info("Thread \"" + this._thd.getName() + "\" started");
            }
        } else {
            _log.error("Request to start when thread is already running.");
        }
    }

    @Override
    public void disable() {
        if (this._thd == null) {
            return;
        }
        this._should_run = false;
        if (_log.isDebugEnabled()) {
            _log.debug("Signalling thread \"" + this._thd.getName() + "\" to stop");
        }
        this.triggerBlockingActivityToReturn();
        _log.debug("Waiting for thread to finish...");
        try {
            this._thd.join();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        this._thd = null;
    }

    @Override
    public boolean isEnabled() {
        return this._thd != null;
    }

    abstract void triggerBlockingActivityToReturn();

    abstract void blockingActivity();

    @Override
    public void run() {
        while (this._should_run) {
            this.blockingActivity();
        }
        if (_log.isInfoEnabled()) {
            _log.info("Thread " + this._thd.getName() + " stopped");
        }
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    @Override
    public String getInfo() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        sb.append(this.isEnabled() ? "enabled" : "disabled");
        if (this.isEnabled()) {
            sb.append(", ");
            sb.append(this._callCount);
        }
        sb.append("]");
        return sb.toString();
    }
}

