/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.services.info.base.guides;

import org.dcache.services.info.base.StateGuide;
import org.dcache.services.info.base.StatePath;

public class SubtreeStateGuide
implements StateGuide {
    private final StatePath _subtreeRoot;

    public SubtreeStateGuide(StatePath root) {
        this._subtreeRoot = root;
    }

    @Override
    public boolean isVisitable(StatePath path) {
        if (this.isRootPath(path)) {
            return true;
        }
        if (this.isRootPath(this._subtreeRoot)) {
            return true;
        }
        if (path.equalsOrHasChild(this._subtreeRoot)) {
            return true;
        }
        return this._subtreeRoot.equalsOrHasChild(path);
    }

    private boolean isRootPath(StatePath path) {
        return path == null;
    }

    public boolean isInSubtree(StatePath path) {
        return this._subtreeRoot.equalsOrHasChild(path);
    }

    public String toString() {
        return "{SubtreeStateGuide: " + this._subtreeRoot + "}";
    }
}

