/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.services.info.base;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.dcache.services.info.base.BadStatePathException;
import org.dcache.services.info.base.StateComponent;
import org.dcache.services.info.base.StateComposite;
import org.dcache.services.info.base.StatePath;
import org.dcache.services.info.base.StateTransition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StateUpdate {
    private static final Logger _log = LoggerFactory.getLogger(StateUpdate.class);
    private final List<StateUpdateInstance> _updates = new ArrayList<StateUpdateInstance>();
    private final List<StatePath> _purge = new ArrayList<StatePath>();

    public boolean hasUpdate(StatePath path, StateComponent value) {
        if (path == null || value == null) {
            return false;
        }
        for (StateUpdateInstance sui : this._updates) {
            if (!sui._path.equals(path) || !sui._newValue.equals(value)) continue;
            return true;
        }
        return false;
    }

    public boolean hasPurge(StatePath path) {
        return this._purge.contains(path);
    }

    public int count() {
        return this._updates.size();
    }

    public int countPurges() {
        return this._purge.size();
    }

    public void appendUpdate(StatePath path, StateComponent value) {
        this._updates.add(new StateUpdateInstance(path, value));
    }

    public void appendUpdateCollection(StatePath path, Collection<String> items, boolean isImmortal) {
        for (String item : items) {
            this.appendUpdate(path.newChild(item), new StateComposite(isImmortal));
        }
    }

    public void appendUpdateCollection(StatePath path, List<String> items, long lifetime) {
        for (String item : items) {
            this.appendUpdate(path.newChild(item), new StateComposite(lifetime));
        }
    }

    public void purgeUnder(StatePath path) {
        this._purge.add(path);
    }

    protected void updateTransition(StateComposite top, StateTransition transition) throws BadStatePathException {
        BadStatePathException caughtThis = null;
        _log.debug("preparing transition with " + this._purge.size() + " purge and " + this._updates.size() + " update");
        for (StatePath path : this._purge) {
            top.buildPurgeTransition(transition, null, path);
        }
        for (StateUpdateInstance update : this._updates) {
            if (_log.isDebugEnabled()) {
                _log.debug("preparing transition to alter " + update._path.toString());
            }
            try {
                top.buildTransition(null, update._path, update._newValue, transition);
            }
            catch (BadStatePathException e) {
                if (caughtThis != null) continue;
                caughtThis = e;
            }
        }
        if (caughtThis != null) {
            throw caughtThis;
        }
    }

    public String debugInfo() {
        StringBuffer sb = new StringBuffer();
        sb.append("=== StateUpdate ===\n");
        sb.append("  Number of purges: " + this._purge.size() + "\n");
        for (StatePath purgePath : this._purge) {
            sb.append("    " + purgePath + "\n");
        }
        sb.append("  Number of StateUpdates: " + this._updates.size() + "\n");
        for (StateUpdateInstance sui : this._updates) {
            sb.append("    " + sui._path + " " + sui._newValue + "\n");
        }
        return sb.toString();
    }

    private static class StateUpdateInstance {
        final StatePath _path;
        final StateComponent _newValue;

        StateUpdateInstance(StatePath path, StateComponent newValue) {
            this._path = path;
            this._newValue = newValue;
        }
    }
}

