/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.services.info.base;

import java.util.HashMap;
import java.util.Map;
import org.dcache.services.info.base.StateChangeSet;
import org.dcache.services.info.base.StatePath;

public class StateTransition {
    final Map<StatePath, StateChangeSet> _allChanges = new HashMap<StatePath, StateChangeSet>();

    protected StateChangeSet getStateChangeSet(StatePath path) {
        return this._allChanges.get(path);
    }

    protected StateChangeSet getOrCreateChangeSet(StatePath path) {
        StateChangeSet changeSet = this._allChanges.get(path);
        if (changeSet == null) {
            changeSet = new StateChangeSet();
            this._allChanges.put(path, changeSet);
        }
        return changeSet;
    }

    protected String dumpContents() {
        StringBuilder sb = new StringBuilder();
        boolean isFirst = true;
        for (Map.Entry<StatePath, StateChangeSet> entry : this._allChanges.entrySet()) {
            StateChangeSet changeSet = entry.getValue();
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append("\n");
            }
            sb.append("Path: ");
            sb.append(entry.getKey() != null ? entry.getKey() : "(null)");
            sb.append("\n");
            sb.append(changeSet.dumpContents());
        }
        return sb.toString();
    }
}

