/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.services.info.base;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.dcache.services.info.base.MetricStatePathException;
import org.dcache.services.info.base.StateChangeSet;
import org.dcache.services.info.base.StateComponent;
import org.dcache.services.info.base.StatePath;
import org.dcache.services.info.base.StatePathPredicate;
import org.dcache.services.info.base.StatePersistentMetadata;
import org.dcache.services.info.base.StateTransition;
import org.dcache.services.info.base.StateVisitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StateComposite
implements StateComponent {
    private static final Logger _log = LoggerFactory.getLogger(StateComposite.class);
    static final long DEFAULT_LIFETIME = 10L;
    private final Map<String, StateComponent> _children = new HashMap<String, StateComponent>();
    private StatePersistentMetadata _metadataRef;
    private Date _earliestChildExpiry = null;
    private Date _whenIShouldExpire;
    private boolean _isEphemeral;

    public StateComposite(long lifetime) {
        if (lifetime < 0L) {
            lifetime = 0L;
        }
        this.becomeMortal(lifetime);
        this._metadataRef = null;
    }

    public StateComposite() {
        this(false);
    }

    public StateComposite(boolean isImmortal) {
        if (isImmortal) {
            this.becomeImmortal();
        } else {
            this.becomeEphemeral();
        }
        this._metadataRef = null;
    }

    private StateComposite(StatePersistentMetadata persistentMetadata, long lifetime) {
        this.becomeMortal(lifetime);
        this._metadataRef = persistentMetadata;
    }

    protected StateComposite(StatePersistentMetadata persistentMetadata) {
        this.becomeImmortal();
        this._metadataRef = persistentMetadata;
    }

    private void updateEarliestChildExpiryDate(Date newDate) {
        if (newDate == null) {
            return;
        }
        if (this._earliestChildExpiry == null || newDate.before(this._earliestChildExpiry)) {
            this._earliestChildExpiry = newDate;
        }
    }

    @Override
    public Date getEarliestChildExpiryDate() {
        return this._earliestChildExpiry != null ? new Date(this._earliestChildExpiry.getTime()) : null;
    }

    private void updateWhenIShouldExpireDate(Date newDate) {
        if (newDate == null) {
            return;
        }
        if (this._whenIShouldExpire == null || newDate.after(this._whenIShouldExpire)) {
            this._whenIShouldExpire = newDate;
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("StateComposite <");
        sb.append(this.isMortal() ? "+" : (this.isEphemeral() ? "*" : "#"));
        sb.append("> {");
        sb.append(this._children.size());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public Date getExpiryDate() {
        return this._whenIShouldExpire != null ? new Date(this._whenIShouldExpire.getTime()) : null;
    }

    @Override
    public boolean hasExpired() {
        Date now = new Date();
        return this._whenIShouldExpire != null ? !now.before(this._whenIShouldExpire) : false;
    }

    private void becomeImmortal() {
        this._isEphemeral = false;
        this._whenIShouldExpire = null;
    }

    private void becomeEphemeral() {
        this._isEphemeral = true;
        this._whenIShouldExpire = null;
    }

    private void becomeMortal(long lifetime) {
        this._whenIShouldExpire = new Date(System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(lifetime));
    }

    @Override
    public void acceptVisitor(StatePath path, StateVisitor visitor) {
        if (_log.isDebugEnabled()) {
            _log.debug("acceptVisitor( " + (path != null ? path : "(null)") + ")");
        }
        Map<String, String> branchMetadata = this.getMetadataInfo();
        visitor.visitCompositePreDescend(path, branchMetadata);
        for (Map.Entry<String, StateComponent> mapEntry : this._children.entrySet()) {
            String childName = mapEntry.getKey();
            StateComponent child = mapEntry.getValue();
            StatePath childPath = this.buildChildPath(path, childName);
            if (!visitor.isVisitable(childPath)) continue;
            child.acceptVisitor(childPath, visitor);
        }
        visitor.visitCompositePostDescend(path, branchMetadata);
    }

    @Override
    public void acceptVisitor(StateTransition transition, StatePath ourPath, StateVisitor visitor) {
        if (_log.isDebugEnabled()) {
            _log.debug("acceptVisitor( " + (transition != null ? "not null" : "(null)") + ", " + (ourPath != null ? ourPath : "(null)") + ")");
        }
        assert (transition != null);
        Map<String, String> branchMetadata = this.getMetadataInfo();
        visitor.visitCompositePreDescend(ourPath, branchMetadata);
        StateChangeSet changeSet = transition.getStateChangeSet(ourPath);
        Map<String, StateComponent> futureChildren = this.getFutureChildren(changeSet);
        for (Map.Entry<String, StateComponent> mapEntry : futureChildren.entrySet()) {
            String childName = mapEntry.getKey();
            StateComponent child = mapEntry.getValue();
            StatePath childPath = this.buildChildPath(ourPath, childName);
            if (!visitor.isVisitable(childPath)) continue;
            child.acceptVisitor(transition, childPath, visitor);
        }
        visitor.visitCompositePostDescend(ourPath, branchMetadata);
    }

    private Map<String, StateComponent> getFutureChildren(StateChangeSet changeSet) {
        StateComponent childValue;
        if (changeSet == null) {
            return this._children;
        }
        HashMap<String, StateComponent> futureChildren = new HashMap<String, StateComponent>(this._children);
        for (String childName : changeSet.getNewChildren()) {
            childValue = changeSet.getNewChildValue(childName);
            futureChildren.put(childName, childValue);
        }
        for (String childName : changeSet.getUpdatedChildren()) {
            childValue = changeSet.getUpdatedChildValue(childName);
            if (childValue instanceof StateComposite) continue;
            futureChildren.put(childName, childValue);
        }
        for (String childName : changeSet.getRemovedChildren()) {
            futureChildren.remove(childName);
        }
        return futureChildren;
    }

    @Override
    public void applyTransition(StatePath ourPath, StateTransition transition) {
        StateChangeSet changeSet = transition.getStateChangeSet(ourPath);
        if (changeSet == null) {
            _log.warn("cannot find StateChangeSet for path " + ourPath + ". Something must have gone wrong.");
            return;
        }
        Date newExpDate = changeSet.getWhenIShouldExpireDate();
        this.updateWhenIShouldExpireDate(newExpDate);
        if (newExpDate == null) {
            _log.debug("getWhenIShouldExpireDate() returned null: no Mortal children?");
        }
        if (changeSet.haveImmortalChild()) {
            this.becomeImmortal();
        }
        for (String childName : changeSet.getRemovedChildren()) {
            if (_log.isDebugEnabled()) {
                _log.debug("removing child " + childName);
            }
            this._children.remove(childName);
        }
        for (String childName : changeSet.getUpdatedChildren()) {
            StateComponent updatedChildValue = changeSet.getUpdatedChildValue(childName);
            if (updatedChildValue == null) {
                _log.error("Attempting to update " + childName + " in " + ourPath + ", but value is null; wilfully ignoring this.");
                continue;
            }
            if (_log.isDebugEnabled()) {
                _log.debug("updating child " + childName + ", updated value " + updatedChildValue.toString());
            }
            this.addComponent(childName, updatedChildValue);
        }
        for (String childName : changeSet.getNewChildren()) {
            StateComponent newChildValue = changeSet.getNewChildValue(childName);
            if (_log.isDebugEnabled()) {
                _log.debug("adding new child " + childName + ", new value " + newChildValue.toString());
            }
            this.addComponent(childName, newChildValue);
        }
        for (String childName : changeSet.getItrChildren()) {
            StateComponent child = this._children.get(childName);
            if (child == null) {
                if (changeSet.getRemovedChildren().contains(childName)) continue;
                _log.error("Whilst in " + ourPath + ", avoided attempting to applyTransition() on missing child " + childName);
                continue;
            }
            child.applyTransition(this.buildChildPath(ourPath, childName), transition);
        }
        this.recalcEarliestChildExpiry();
    }

    private void recalcEarliestChildExpiry() {
        this._earliestChildExpiry = null;
        for (StateComponent child : this._children.values()) {
            Date earliestExpires = child.getEarliestChildExpiryDate();
            if (earliestExpires != null) {
                this.updateEarliestChildExpiryDate(earliestExpires);
            }
            if (!child.isMortal()) continue;
            this.updateEarliestChildExpiryDate(child.getExpiryDate());
        }
    }

    private StatePersistentMetadata getChildMetadata(String childName) {
        return this._metadataRef == null ? null : this._metadataRef.getChild(childName);
    }

    private Map<String, String> getMetadataInfo() {
        return this._metadataRef == null ? null : this._metadataRef.getMetadata();
    }

    private void addComponent(String childName, StateComponent newChild) {
        StateComponent existingChild = this._children.get(childName);
        if (newChild instanceof StateComposite) {
            StateComposite newComposite = (StateComposite)newChild;
            if (existingChild instanceof StateComposite) {
                StateComposite existingComposite = (StateComposite)existingChild;
                for (Map.Entry<String, StateComponent> entry : existingComposite._children.entrySet()) {
                    if (newComposite._children.containsKey(entry.getKey())) continue;
                    newComposite._children.put(entry.getKey(), entry.getValue());
                }
                newComposite.updateEarliestChildExpiryDate(existingComposite.getEarliestChildExpiryDate());
                newComposite.updateWhenIShouldExpireDate(existingComposite.getExpiryDate());
            }
        }
        this._children.put(childName, newChild);
        if (_log.isDebugEnabled()) {
            _log.debug("Child " + childName + " now " + this._children.get(childName).toString());
        }
    }

    @Override
    public void buildTransition(StatePath ourPath, StatePath newComponentPath, StateComponent newComponent, StateTransition transition) throws MetricStatePathException {
        String childName = newComponentPath.getFirstElement();
        StateChangeSet changeSet = transition.getOrCreateChangeSet(ourPath);
        if (this.isMortal() && newComponent.isMortal()) {
            Date newComponentExpiryDate = newComponent.getExpiryDate();
            changeSet.recordNewWhenIShouldExpireDate(newComponentExpiryDate);
        }
        if (newComponent.isImmortal()) {
            changeSet.recordChildIsImmortal();
        }
        changeSet.ensureChildNotRemoved(childName);
        if (newComponentPath.isSimplePath()) {
            if (this._children.containsKey(childName)) {
                changeSet.recordUpdatedChild(childName, newComponent);
            } else {
                changeSet.recordNewChild(childName, newComponent);
            }
            if (newComponent instanceof StateComposite) {
                StateComposite newComposite = (StateComposite)newComponent;
                newComposite._metadataRef = this.getChildMetadata(childName);
            }
            return;
        }
        StateComponent child = this._children.get(childName);
        if (child == null && (child = changeSet.getNewChildValue(childName)) == null) {
            child = new StateComposite(this.getChildMetadata(childName), 10L);
            changeSet.recordNewChild(childName, child);
        }
        changeSet.recordChildItr(childName);
        child.buildTransition(this.buildChildPath(ourPath, childName), newComponentPath.childPath(), newComponent, transition);
    }

    @Override
    public boolean predicateHasBeenTriggered(StatePath ourPath, StatePathPredicate predicate, StateTransition transition) {
        StateComponent child;
        StateChangeSet changeSet;
        if (_log.isDebugEnabled()) {
            _log.debug("entering (" + (ourPath != null ? ourPath.toString() : "(null)") + ", " + (predicate != null ? predicate.toString() : "(null)") + ")");
        }
        if ((changeSet = transition.getStateChangeSet(ourPath)) == null) {
            return false;
        }
        Set<String> newChildren = changeSet.getNewChildren();
        if (newChildren != null) {
            for (String newChildName : newChildren) {
                if (!predicate.topElementMatches(newChildName)) continue;
                if (predicate.isSimplePath()) {
                    return true;
                }
                child = changeSet.getNewChildValue(newChildName);
                if (!child.predicateHasBeenTriggered(this.buildChildPath(ourPath, newChildName), predicate.childPath(), transition)) continue;
                return true;
            }
        }
        for (String childName : this._children.keySet()) {
            child = this._children.get(childName);
            if (!changeSet.hasChildChanged(childName) || !predicate.topElementMatches(childName)) continue;
            if (predicate.isSimplePath()) {
                if (changeSet.childIsRemoved(childName)) {
                    return true;
                }
                StateComponent updatedChildValue = changeSet.getUpdatedChildValue(childName);
                if (updatedChildValue == null || child.equals(updatedChildValue)) continue;
                return true;
            }
            if (!child.predicateHasBeenTriggered(this.buildChildPath(ourPath, childName), predicate.childPath(), transition)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isEphemeral() {
        return this._whenIShouldExpire == null && this._isEphemeral;
    }

    @Override
    public boolean isImmortal() {
        return this._whenIShouldExpire == null && !this._isEphemeral;
    }

    @Override
    public boolean isMortal() {
        return this._whenIShouldExpire != null;
    }

    private StatePath buildChildPath(StatePath ourPath, String childName) {
        return ourPath != null ? ourPath.newChild(childName) : new StatePath(childName);
    }

    @Override
    public void buildRemovalTransition(StatePath ourPath, StateTransition transition, boolean forced) {
        Date now = new Date();
        if (_log.isDebugEnabled()) {
            _log.debug("entering buildRemovalTransition( " + ourPath + ", ..)");
        }
        for (Map.Entry<String, StateComponent> entry : this._children.entrySet()) {
            Date childExp;
            StateComponent childValue = entry.getValue();
            String childName = entry.getKey();
            boolean shouldRemoveThisChild = forced;
            boolean shouldItr = forced;
            if (childValue.hasExpired()) {
                if (_log.isDebugEnabled()) {
                    _log.debug("registering " + childName + " (in path " + ourPath + ") for removal.");
                }
                shouldItr = true;
                shouldRemoveThisChild = true;
            }
            if ((childExp = childValue.getEarliestChildExpiryDate()) != null && !now.before(childExp)) {
                shouldItr = true;
            }
            if (!shouldItr && !shouldRemoveThisChild) continue;
            StateChangeSet changeSet = transition.getOrCreateChangeSet(ourPath);
            if (shouldRemoveThisChild) {
                changeSet.recordRemovedChild(childName);
            }
            if (!shouldItr) continue;
            changeSet.recordChildItr(childName);
            childValue.buildRemovalTransition(this.buildChildPath(ourPath, childName), transition, shouldRemoveThisChild);
        }
    }

    @Override
    public void buildPurgeTransition(StateTransition transition, StatePath ourPath, StatePath remainingPath) {
        if (_log.isDebugEnabled()) {
            _log.debug("entering buildPurgeTransition( " + ourPath + ", " + remainingPath + "..)");
        }
        StateChangeSet scs = transition.getOrCreateChangeSet(ourPath);
        if (remainingPath == null) {
            this.buildRemovalTransition(ourPath, transition, true);
        } else {
            String childName = remainingPath.getFirstElement();
            if (this._children.containsKey(childName)) {
                StateComponent child = this._children.get(childName);
                StatePath childPath = this.buildChildPath(ourPath, childName);
                if (child instanceof StateComposite) {
                    scs.recordChildItr(childName);
                }
                if (remainingPath.isSimplePath()) {
                    scs.recordRemovedChild(childName);
                }
                child.buildPurgeTransition(transition, childPath, remainingPath.childPath());
            }
        }
    }

    public int hashCode() {
        return ((Object)this._children).hashCode();
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof StateComposite)) {
            return false;
        }
        StateComposite otherSc = (StateComposite)other;
        return ((Object)otherSc._children).equals(this._children);
    }
}

