/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.services.info.base;

import java.io.PrintWriter;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.dcache.services.info.base.BadStatePathException;
import org.dcache.services.info.base.PostTransitionStateExhibitor;
import org.dcache.services.info.base.StateCaretaker;
import org.dcache.services.info.base.StateComposite;
import org.dcache.services.info.base.StateExhibitor;
import org.dcache.services.info.base.StateObservatory;
import org.dcache.services.info.base.StatePathPredicate;
import org.dcache.services.info.base.StatePersistentMetadata;
import org.dcache.services.info.base.StateTransition;
import org.dcache.services.info.base.StateUpdate;
import org.dcache.services.info.base.StateUpdateManager;
import org.dcache.services.info.base.StateVisitor;
import org.dcache.services.info.base.StateWatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class State
implements StateCaretaker,
StateExhibitor,
StateObservatory {
    public static final String METADATA_BRANCH_CLASS_KEY = "branch";
    public static final String METADATA_BRANCH_IDNAME_KEY = "id";
    private static final Logger _log = LoggerFactory.getLogger(State.class);
    private final StateComposite _state;
    private final Collection<StateWatcherInfo> _watchers = new CopyOnWriteArrayList<StateWatcherInfo>();
    private final ReadWriteLock _stateRWLock = new ReentrantReadWriteLock(true);
    private final Lock _stateReadLock = this._stateRWLock.readLock();
    private final Lock _stateWriteLock = this._stateRWLock.writeLock();
    private StateUpdateManager _updateManager;

    public State() {
        StatePersistentMetadata metadata = new StatePersistentMetadata();
        metadata.addDefault();
        this._state = new StateComposite(metadata);
    }

    public void setStateUpdateManager(StateUpdateManager sum) {
        this._updateManager = sum;
    }

    @Override
    public Date getEarliestMetricExpiryDate() {
        Date earliestExpiryDate = this._state.getEarliestChildExpiryDate();
        if (_log.isDebugEnabled()) {
            if (earliestExpiryDate == null) {
                _log.debug("reporting that earliest expiry time is never");
            } else {
                long duration = (earliestExpiryDate.getTime() - System.currentTimeMillis()) / 1000L;
                _log.debug("reporting that earliest expiry time is " + duration + "s in the future");
            }
        }
        return earliestExpiryDate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processUpdate(StateUpdate update) {
        if (_log.isDebugEnabled()) {
            _log.debug("beginning to process update: \n" + update.debugInfo());
        }
        if (update == null) {
            _log.warn("processUpdate called with null StateUpdate");
            return;
        }
        if (update.countPurges() == 0 && update.count() == 0) {
            _log.warn("StateUpdate with zero updates encountered");
            return;
        }
        StateTransition transition = new StateTransition();
        try {
            this._stateReadLock.lock();
            try {
                update.updateTransition(this._state, transition);
            }
            catch (BadStatePathException e) {
                _log.error("Error updating state:", (Throwable)e);
            }
            _log.debug("checking StateWatchers");
            StateUpdate resultingUpdate = this.checkWatchers(transition);
            if (resultingUpdate != null) {
                this._updateManager.enqueueUpdate(resultingUpdate);
            }
        }
        finally {
            this._stateReadLock.unlock();
        }
        this.applyTransition(transition);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyTransition(StateTransition transition) {
        if (_log.isDebugEnabled()) {
            _log.debug("now applying following transition to state:\n\n" + transition.dumpContents());
        }
        try {
            this._stateWriteLock.lock();
            this._state.applyTransition(null, transition);
        }
        finally {
            this._stateWriteLock.unlock();
        }
    }

    @Override
    public StateUpdate checkWatchers(StateTransition transition) {
        StateUpdate update = new StateUpdate();
        State currentState = this;
        PostTransitionStateExhibitor futureState = null;
        for (StateWatcherInfo thisWatcherInfo : this._watchers) {
            StateWatcher thisWatcher = thisWatcherInfo.getWatcher();
            if (!thisWatcherInfo.isEnabled()) {
                if (!_log.isDebugEnabled()) continue;
                _log.debug("skipping disabled watcher " + thisWatcher);
                continue;
            }
            if (_log.isDebugEnabled()) {
                _log.debug("checking watcher " + thisWatcher);
            }
            boolean hasBeenTriggered = false;
            for (StatePathPredicate thisPredicate : thisWatcher.getPredicate()) {
                if (_log.isDebugEnabled()) {
                    _log.debug("checking watcher " + thisWatcher + " predicate " + thisPredicate);
                }
                if (!(hasBeenTriggered = this._state.predicateHasBeenTriggered(null, thisPredicate, transition))) continue;
                break;
            }
            if (!hasBeenTriggered) continue;
            if (_log.isInfoEnabled()) {
                _log.info("triggering watcher " + thisWatcher);
            }
            thisWatcherInfo.incrementCounter();
            if (futureState == null) {
                futureState = new PostTransitionStateExhibitor(currentState, transition);
            }
            thisWatcher.trigger(update, currentState, futureState);
        }
        return update.count() > 0 || update.countPurges() > 0 ? update : null;
    }

    @Override
    public void addStateWatcher(StateWatcher watcher) {
        this._watchers.add(new StateWatcherInfo(watcher));
    }

    @Override
    public void removeStateWatcher(StateWatcher watcher) {
        Iterator<StateWatcherInfo> itr = this._watchers.iterator();
        while (itr.hasNext()) {
            StateWatcherInfo info = itr.next();
            if (!info.getWatcher().equals(watcher)) continue;
            itr.remove();
        }
    }

    @Override
    public String[] listStateWatcher() {
        String[] watchers = new String[this._watchers.size()];
        int i = 0;
        for (StateWatcherInfo thisWatcherInfo : this._watchers) {
            watchers[i++] = thisWatcherInfo.toString();
        }
        return watchers;
    }

    @Override
    public int enableStateWatcher(String name) {
        int count = 0;
        for (StateWatcherInfo thisWatcherInfo : this._watchers) {
            if (!name.equals(thisWatcherInfo.getWatcher().toString())) continue;
            thisWatcherInfo.enable();
            ++count;
        }
        return count;
    }

    @Override
    public int disableStateWatcher(String name) {
        int count = 0;
        for (StateWatcherInfo thisWatcherInfo : this._watchers) {
            if (!name.equals(thisWatcherInfo.getWatcher().toString())) continue;
            thisWatcherInfo.disable();
            ++count;
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void removeExpiredMetrics() {
        Date expDate = this.getEarliestMetricExpiryDate();
        if (expDate == null || expDate.after(new Date())) {
            return;
        }
        _log.info("Building StateTransition for expired StateComponents");
        StateTransition transition = new StateTransition();
        try {
            this._stateReadLock.lock();
            this._state.buildRemovalTransition(null, transition, false);
            StateUpdate resultingUpdate = this.checkWatchers(transition);
            if (resultingUpdate != null) {
                this._updateManager.enqueueUpdate(resultingUpdate);
            }
        }
        finally {
            this._stateReadLock.unlock();
        }
        this.applyTransition(transition);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visitState(StateVisitor visitor) {
        if (_log.isDebugEnabled()) {
            _log.debug("visitor " + visitor.getClass().getSimpleName() + " wishing to visit current state");
        }
        try {
            long beforeLock = System.currentTimeMillis();
            if (_log.isDebugEnabled()) {
                _log.debug("visitor " + visitor.getClass().getSimpleName() + " acquiring read lock");
            }
            this._stateReadLock.lock();
            long afterLock = System.currentTimeMillis();
            if (_log.isDebugEnabled()) {
                _log.debug("visitor " + visitor.getClass().getSimpleName() + " acquired read lock (took " + (double)(afterLock - beforeLock) / 1000.0 + " ms), starting visit.");
            }
            if (visitor.isVisitable(null)) {
                this._state.acceptVisitor(null, visitor);
            }
            long afterVisit = System.currentTimeMillis();
            if (_log.isDebugEnabled()) {
                _log.debug("visitor " + visitor.getClass().getSimpleName() + " completed visit (took " + (double)(afterVisit - afterLock) / 1000.0 + " ms), releasing read lock.");
            }
        }
        finally {
            this._stateReadLock.unlock();
        }
        if (_log.isDebugEnabled()) {
            _log.debug("visitor " + visitor.getClass().getSimpleName() + " finished.");
        }
    }

    public void getInfo(PrintWriter pw) {
        pw.print(this.listStateWatcher().length);
        pw.println(" state watchers.");
        pw.print(this._updateManager.countPendingUpdates());
        pw.println(" pending updates to state.");
    }

    private static class StateWatcherInfo {
        StateWatcher _watcher;
        boolean _isEnabled = true;
        long _counter;

        StateWatcherInfo(StateWatcher watcher) {
            this._watcher = watcher;
        }

        boolean isEnabled() {
            return this._isEnabled;
        }

        void enable() {
            this._isEnabled = true;
        }

        void disable() {
            this._isEnabled = false;
        }

        void incrementCounter() {
            ++this._counter;
        }

        StateWatcher getWatcher() {
            return this._watcher;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this._watcher.toString()).append(" ");
            sb.append("(");
            sb.append(this._isEnabled ? "enabled" : "disabled");
            sb.append(", triggered: " + this._counter);
            sb.append(")");
            return sb.toString();
        }
    }
}

