/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.services.info.base;

import org.dcache.services.info.base.StatePath;
import org.dcache.services.info.base.StateValue;
import org.dcache.services.info.base.StateVisitor;

public class IntegerStateValue
extends StateValue {
    private final long _storage;

    public IntegerStateValue(long value, long duration) {
        super(duration);
        this._storage = value;
    }

    public IntegerStateValue(long value) {
        this(value, false);
    }

    public IntegerStateValue(long value, boolean isImmortal) {
        super(isImmortal);
        this._storage = value;
    }

    public String toString() {
        return Long.toString(this._storage);
    }

    @Override
    public String getTypeName() {
        return "integer";
    }

    public long getValue() {
        return this._storage;
    }

    @Override
    public void acceptVisitor(StatePath path, StateVisitor visitor) {
        visitor.visitInteger(path, this);
    }

    @Override
    public int hashCode() {
        return (int)this._storage;
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof IntegerStateValue)) {
            return false;
        }
        IntegerStateValue otherValue = (IntegerStateValue)other;
        return this._storage == otherValue._storage;
    }
}

