/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.services.info.base;

import org.dcache.services.info.base.StatePath;
import org.dcache.services.info.base.StateValue;
import org.dcache.services.info.base.StateVisitor;

public class FloatingPointStateValue
extends StateValue {
    private final double _storage;

    public FloatingPointStateValue(double value) {
        this(value, false);
    }

    public FloatingPointStateValue(double value, boolean isImmortal) {
        super(isImmortal);
        this._storage = value;
    }

    public FloatingPointStateValue(double value, long duration) {
        super(duration);
        this._storage = value;
    }

    @Override
    public String getTypeName() {
        return "float";
    }

    public String toString() {
        return Double.toString(this._storage);
    }

    @Override
    public void acceptVisitor(StatePath path, StateVisitor visitor) {
        visitor.visitFloatingPoint(path, this);
    }

    @Override
    public int hashCode() {
        Float floatVal = new Float(this._storage);
        return floatVal.hashCode();
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof FloatingPointStateValue)) {
            return false;
        }
        FloatingPointStateValue otherValue = (FloatingPointStateValue)other;
        return this._storage == otherValue._storage;
    }
}

