/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.services.info.base;

import org.dcache.services.info.base.StatePath;
import org.dcache.services.info.base.StateValue;
import org.dcache.services.info.base.StateVisitor;

public class BooleanStateValue
extends StateValue {
    private final boolean _storage;

    public BooleanStateValue(boolean value) {
        this(value, false);
    }

    public BooleanStateValue(boolean value, boolean isImmortal) {
        super(isImmortal);
        this._storage = value;
    }

    public BooleanStateValue(boolean value, long duration) {
        super(duration);
        this._storage = value;
    }

    public String toString() {
        return Boolean.toString(this._storage);
    }

    @Override
    public String getTypeName() {
        return "boolean";
    }

    @Override
    public void acceptVisitor(StatePath path, StateVisitor visitor) {
        visitor.visitBoolean(path, this);
    }

    @Override
    public int hashCode() {
        return this._storage ? 1 : 0;
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof BooleanStateValue)) {
            return false;
        }
        BooleanStateValue otherValue = (BooleanStateValue)other;
        return this._storage == otherValue._storage;
    }
}

