/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.services.httpd;

import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import dmg.cells.nucleus.CellNucleus;
import dmg.cells.nucleus.EnvironmentAware;
import dmg.protocols.kerberos.Base64;
import dmg.util.Args;
import dmg.util.CollectionFactory;
import dmg.util.HttpBasicAuthenticationException;
import dmg.util.HttpException;
import dmg.util.HttpRequest;
import dmg.util.HttpResponseEngine;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.FileNameMap;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLConnection;
import java.util.Date;
import java.util.Enumeration;
import java.util.Map;
import java.util.SortedMap;
import java.util.StringTokenizer;
import java.util.concurrent.ExecutionException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.dcache.cells.AbstractCell;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpServiceCell
extends AbstractCell
implements EnvironmentAware {
    private static final Logger _log = LoggerFactory.getLogger(HttpServiceCell.class);
    private static final Splitter PATH_SPLITTER = Splitter.on((char)'/').omitEmptyStrings();
    private final Map<String, AliasEntry> _aliasHash = Maps.newHashMap();
    private Map<String, Object> _context;
    private int _listenPort;
    private Server _jetty;
    private volatile Map<String, Object> _environment;
    private static final FileNameMap __mimeTypeMap = URLConnection.getFileNameMap();
    public String hh_ls_alias = "[<alias>]";
    public String hh_unset_alias = "<aliasName>";
    public String hh_set_alias = "<aliasName> directory|class|context <specification>";
    public String fh_set_alias = "set alias <alias>  <type> [<typeSpecific> <...>]\n    <type>         <specific> \n   directory    <fullDirectoryPath>\n   file         <fullFilePath> <arguments> <...>\n   class        <fullClassName>\n   context      [options] <context> or  <contextNameStart>*\n                  options : -overwrite=<alias> -onError=<alias>\n       predefined alias : <home> =  default for http://host:port/ \n                          <default> =  default for any type or error \n";

    public HttpServiceCell(String name, String args) throws InterruptedException, ExecutionException {
        super(name, args);
        this.doInit();
    }

    @Override
    protected void init() throws Exception {
        Args args = this.getArgs();
        if (args.argc() < 1) {
            throw new IllegalArgumentException("USAGE : ... <listenPort>");
        }
        this._context = this.getDomainContext();
        this._listenPort = Integer.parseInt(args.argv(0));
        this._jetty = new Server(this._listenPort);
        this._jetty.setHandler((Handler)new HttpServiceCellHandler());
        this._jetty.start();
    }

    @Override
    public void cleanUp() {
        try {
            this._jetty.stop();
        }
        catch (Exception e) {
            _log.error("Failed to stop Jetty: {}", (Object)e.getMessage());
        }
        this.shutdownEngines();
        super.cleanUp();
    }

    private void shutdownEngines() {
        for (AliasEntry entry : this._aliasHash.values()) {
            if (!entry.getType().equals("class")) continue;
            HttpResponseEngine engine = (HttpResponseEngine)entry.getSpecific();
            engine.shutdown();
        }
    }

    public void getInfo(PrintWriter pw) {
        for (Map.Entry<String, AliasEntry> aliasEntry : this._aliasHash.entrySet()) {
            pw.println("<<<<< " + aliasEntry.getKey() + " >>>>>>>>>");
            aliasEntry.getValue().getInfo(pw);
        }
    }

    public String ac_ls_alias_$_0_1(Args args) throws Exception {
        AliasEntry entry = null;
        if (args.argc() == 0) {
            StringBuilder sb = new StringBuilder();
            for (Map.Entry<String, AliasEntry> aliasEntry : this._aliasHash.entrySet()) {
                sb.append(aliasEntry.getKey()).append(" -> ").append(aliasEntry.getValue()).append("\n");
            }
            return sb.toString();
        }
        entry = this._aliasHash.get(args.argv(0));
        if (entry == null) {
            throw new Exception("Alias not found : " + args.argv(0));
        }
        return args.argv(0) + " -> " + entry;
    }

    public String ac_unset_alias_$_1(Args args) {
        this._aliasHash.remove(args.argv(0));
        return "Done";
    }

    public String ac_set_alias_$_3_16(Args args) throws Exception {
        String alias = args.argv(0);
        String type = args.argv(1);
        String spec = args.argv(2);
        if (type.equals("directory") || type.equals("file")) {
            File dir = new File(spec);
            if (!dir.isDirectory() && !dir.isFile()) {
                throw new Exception("Directory/File not found : " + spec);
            }
            this._aliasHash.put(alias, new AliasEntry("directory", dir, spec));
            return alias + " -> directory(" + spec + ")";
        }
        if (type.equals("context")) {
            int pos = spec.indexOf("*");
            if (pos > -1) {
                spec = spec.substring(0, pos);
            }
            AliasEntry entry = new AliasEntry("context", spec, spec);
            String tmp = args.getOpt("onError");
            if (tmp != null) {
                entry.setOnError(tmp);
            }
            if ((tmp = args.getOpt("overwrite")) != null) {
                entry.setOverwrite(tmp);
            }
            this._aliasHash.put(alias, entry);
            return alias + " -> context(" + spec + ")";
        }
        if (type.equals("class")) {
            String retMsg;
            String aliasType;
            int argcount = args.argc() - 3;
            String[] arg = new String[argcount];
            StringBuilder sb = new StringBuilder();
            sb.append("class=" + spec);
            for (int i = 0; i < argcount; ++i) {
                arg[i] = args.argv(3 + i);
                sb.append(";").append(arg[i]);
            }
            HttpResponseEngine engine = null;
            String intFailureMsg = null;
            try {
                aliasType = "class";
                engine = this.invokeHttpEngine(spec, arg);
                retMsg = alias + " -> class(" + sb.toString() + ")";
            }
            catch (ClassNotFoundException e) {
                aliasType = "badconfig";
                intFailureMsg = "failed to load class " + spec;
                retMsg = alias + " -> class(" + sb.toString() + ")  FAILED TO LOAD CLASS";
            }
            AliasEntry aliasEntry = new AliasEntry(aliasType, engine, sb.toString());
            this._aliasHash.put(alias, aliasEntry);
            if (engine == null) {
                aliasEntry.setIntFailureMsg(intFailureMsg);
            }
            return retMsg;
        }
        if (type.equals("cell")) {
            this._aliasHash.put(alias, new AliasEntry("cell", spec, spec));
            return "";
        }
        throw new Exception("Unknown type : " + type);
    }

    private HttpResponseEngine invokeHttpEngine(String className, String[] a) throws Exception {
        Class<?> c = Class.forName(className);
        Class[] argsClass = null;
        Object[] args = null;
        Constructor<?> constr = null;
        HttpResponseEngine engine = null;
        try {
            argsClass = new Class[]{CellNucleus.class, String[].class};
            constr = c.getConstructor(argsClass);
            args = new Object[]{this.getNucleus(), a};
            engine = (HttpResponseEngine)constr.newInstance(args);
        }
        catch (Exception e) {
            try {
                argsClass = new Class[]{String[].class};
                constr = c.getConstructor(argsClass);
                args = new Object[]{a};
                engine = (HttpResponseEngine)constr.newInstance(args);
            }
            catch (Exception ee) {
                argsClass = new Class[]{};
                constr = c.getConstructor(argsClass);
                args = new Object[]{};
                engine = (HttpResponseEngine)constr.newInstance(args);
            }
        }
        this.addCommandListener(engine);
        if (engine instanceof EnvironmentAware) {
            ((EnvironmentAware)engine).setEnvironment(this._environment);
        }
        engine.startup();
        return engine;
    }

    public void setEnvironment(Map<String, Object> environment) {
        this._environment = environment;
    }

    private class HtmlService
    implements HttpRequest {
        private InputStream _in;
        private OutputStream _out;
        private BufferedReader _br;
        private PrintWriter _pw;
        private HttpServletRequest _request;
        private HttpServletResponse _response;
        private Map<String, String> _map = CollectionFactory.newHashMap();
        private String[] _tokens;
        private int _tokenOffset = 1;
        private boolean _isDirectory = false;
        private String _userName;
        private String _password;
        private boolean _authDone = false;

        public void setContentType(String type) {
            this._response.setContentType(type);
        }

        public Map<String, String> getRequestAttributes() {
            return this._map;
        }

        public OutputStream getOutputStream() {
            return this._out;
        }

        public PrintWriter getPrintWriter() {
            return this._pw;
        }

        public String[] getRequestTokens() {
            return this._tokens;
        }

        public int getRequestTokenOffset() {
            return this._tokenOffset;
        }

        public boolean isDirectory() {
            return this._isDirectory;
        }

        public String getParameter(String parameter) {
            return this._request.getParameter(parameter);
        }

        private synchronized void doAuthorization() {
            if (this._authDone) {
                return;
            }
            this._authDone = true;
            String auth = this._request.getHeader("Authorization");
            if (auth == null) {
                return;
            }
            StringTokenizer st = new StringTokenizer(auth);
            if (st.countTokens() < 2) {
                return;
            }
            if (!st.nextToken().equals("Basic")) {
                return;
            }
            auth = new String(Base64.decode((String)st.nextToken()));
            _log.info("Authentication : >{}<", (Object)auth);
            st = new StringTokenizer(auth, ":");
            if (st.countTokens() < 2) {
                return;
            }
            this._userName = st.nextToken();
            this._password = st.nextToken();
        }

        public boolean isAuthenticated() {
            this.doAuthorization();
            return this._userName != null;
        }

        public String getUserName() {
            this.doAuthorization();
            return this._userName;
        }

        public String getPassword() {
            this.doAuthorization();
            return this._password;
        }

        private HtmlService(HttpServletRequest request, HttpServletResponse response) throws IOException {
            this._request = request;
            this._response = response;
            this._in = request.getInputStream();
            this._out = response.getOutputStream();
            this._br = new BufferedReader(new InputStreamReader(this._in));
            this._pw = new PrintWriter(new OutputStreamWriter(this._out));
            this.setContentType("text/html");
        }

        private String getContentTypeFor(String fileName) {
            if (fileName.endsWith(".html")) {
                return "text/html";
            }
            if (fileName.endsWith(".css")) {
                return "text/css";
            }
            return __mimeTypeMap.getContentTypeFor(fileName);
        }

        public void run() {
            try {
                Enumeration names = this._request.getHeaderNames();
                while (names.hasMoreElements()) {
                    String name = (String)names.nextElement();
                    this._map.put(name, this._request.getHeader(name));
                }
                if (!this._request.getMethod().equals("GET")) {
                    throw new HttpException(501, "Method not implemented");
                }
                this.splitUrl(this._request.getRequestURI());
                AliasEntry entry = null;
                String alias = null;
                alias = this._tokens.length == 0 ? "<home>" : this._tokens[0];
                this._tokenOffset = 1;
                try {
                    entry = (AliasEntry)HttpServiceCell.this._aliasHash.get(alias);
                    if (entry == null) {
                        throw new HttpException(404, "Alias not found : " + alias);
                    }
                    this.switchHttpType(entry);
                }
                catch (HttpException e) {
                    if (e.getErrorCode() != 404) {
                        throw e;
                    }
                    entry = (AliasEntry)HttpServiceCell.this._aliasHash.get("<default>");
                    if (entry == null) {
                        throw e;
                    }
                    this.switchHttpType(entry);
                }
                this._pw.flush();
            }
            catch (HttpException e) {
                this.printHttpException(e);
                _log.warn("Problem with {}: {}", (Object)this._request.getRequestURI(), (Object)e.getMessage());
            }
            catch (Exception e) {
                this.printHttpException(new HttpException(400, "Bad Request : " + e));
                _log.warn("Problem in HtmlService: {}", (Throwable)e);
            }
            _log.info("Finished");
        }

        private void switchHttpType(AliasEntry entry) throws Exception {
            String type = entry.getType();
            if (type.equals("badconfig")) {
                StringBuilder sb = new StringBuilder();
                sb.append("HTTP Server badly configured");
                if (entry.getIntFailureMsg() != null) {
                    sb.append(": ");
                    sb.append(entry.getIntFailureMsg());
                }
                sb.append(".");
                throw new HttpException(500, sb.toString());
            }
            if (type.equals("directory")) {
                this.sendFile((File)entry.getSpecific(), this._tokens);
            } else if (type.equals("context")) {
                String html;
                AliasEntry aliasEntry;
                String aliasString = entry.getOverwrite();
                if (aliasString != null && (aliasEntry = (AliasEntry)HttpServiceCell.this._aliasHash.get(aliasString)) != null) {
                    this.switchHttpType(aliasEntry);
                    return;
                }
                String specificName = (String)entry.getSpecific();
                if (this._tokens.length > 1 && this._tokens[1].equals("index.html")) {
                    html = this.createContextDirectory();
                } else {
                    if (this._tokens.length > 1) {
                        String contextName = this._tokens[1];
                        if (!contextName.startsWith(specificName)) {
                            throw new HttpException(403, "Forbidden");
                        }
                        specificName = contextName;
                    }
                    html = (String)HttpServiceCell.this._context.get(specificName);
                }
                if (html == null) {
                    aliasString = entry.getOnError();
                    if (aliasString == null || (aliasEntry = (AliasEntry)HttpServiceCell.this._aliasHash.get(aliasString)) == null) {
                        throw new HttpException(404, "Not found : " + specificName);
                    }
                    this.switchHttpType(aliasEntry);
                    return;
                }
                this._pw.println(html);
            } else if (type.equals("class")) {
                HttpResponseEngine engine = (HttpResponseEngine)entry.getSpecific();
                try {
                    engine.queryUrl((HttpRequest)this);
                }
                catch (HttpException e) {
                    throw e;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new HttpException(500, "HttpResponseEngine (" + engine.getClass().getCanonicalName() + ") is broken, please report this to sysadmin.");
                }
            }
        }

        private String createContextDirectory() {
            StringBuilder sb = new StringBuilder();
            sb.append("<html><title>Context directory</title>\n");
            sb.append("<body bgcolor=\"#0088dd\">\n");
            sb.append("<h1>Context Directory</h1>\n");
            sb.append("<blockquote>\n");
            sb.append("<center>\n");
            sb.append("<table border=1 cellspacing=0 cellpadding=4 width=\"%90\">\n");
            sb.append("<tr><th>Context Name</th><th>Class</th><th>Content</th></tr>\n");
            SortedMap map = CollectionFactory.newTreeMap();
            map.putAll(HttpServiceCell.this._context);
            for (Map.Entry e : map.entrySet()) {
                String key = (String)e.getKey();
                Object o = e.getValue();
                String str = o.toString();
                str = str.substring(0, Math.min(str.length(), 60)).trim();
                str = this.htmlToRegularString(str);
                sb.append("<tr><td>").append(key).append("</td><td>").append(o.getClass().getName()).append("</td><td>").append(str.length() == 0 ? "&nbsp;" : str).append("</td></tr>\n");
            }
            sb.append("</table></center>\n");
            sb.append("</blockquote>\n");
            sb.append("<hr>");
            sb.append("<address>Created : ").append(new Date()).append("</address>\n");
            sb.append("</body></html>");
            return sb.toString();
        }

        private String htmlToRegularString(String str) {
            StringBuilder sb = new StringBuilder();
            int n = str.length();
            block5: for (int i = 0; i < n; ++i) {
                char c = str.charAt(i);
                switch (c) {
                    case '<': {
                        sb.append("&lt;");
                        continue block5;
                    }
                    case '>': {
                        sb.append("&gt;");
                        continue block5;
                    }
                    case '\n': {
                        sb.append("\\n");
                        continue block5;
                    }
                    default: {
                        sb.append(c);
                    }
                }
            }
            return sb.toString();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void sendFile(File base, String[] tokens) throws Exception {
            File f;
            String filename = null;
            if (tokens.length < 2) {
                filename = "index.html";
            } else {
                StringBuilder sb = new StringBuilder();
                sb.append(tokens[1]);
                for (int i = 2; i < tokens.length; ++i) {
                    sb.append("/").append(tokens[i]);
                }
                filename = sb.toString();
            }
            File file = f = base.isFile() ? base : new File(base, filename);
            if (!f.getCanonicalFile().getAbsolutePath().startsWith(base.getCanonicalFile().getAbsolutePath())) {
                throw new HttpException(403, "Forbidden");
            }
            if (!f.isFile()) {
                throw new HttpException(404, "Not found : " + filename);
            }
            FileInputStream binary = new FileInputStream(f);
            try {
                int rc = 0;
                byte[] buffer = new byte[4096];
                this.setContentType(this.getContentTypeFor(filename));
                while ((rc = binary.read(buffer, 0, buffer.length)) > 0) {
                    this._out.write(buffer, 0, rc);
                }
            }
            finally {
                this._out.flush();
                try {
                    binary.close();
                }
                catch (IOException e) {}
            }
        }

        public void printHttpHeader(int size) {
            if (size > 0) {
                this._response.setContentLength(size);
            }
        }

        public void printHttpException(HttpException exception) {
            try {
                if (exception instanceof HttpBasicAuthenticationException) {
                    String realm = ((HttpBasicAuthenticationException)exception).getRealm();
                    this._response.setHeader("WWW-Authenticate", "Basic realm=\"" + realm + "\"");
                }
                this._response.sendError(exception.getErrorCode(), exception.getMessage());
            }
            catch (IOException e) {
                _log.warn("Failed to send reply: {}", (Object)e.getMessage());
            }
        }

        private void splitUrl(String url) throws URISyntaxException {
            String path = new URI(url).getPath();
            this._isDirectory = path.endsWith("/");
            this._tokens = (String[])Iterables.toArray((Iterable)PATH_SPLITTER.split((CharSequence)path), String.class);
        }
    }

    private static class AliasEntry {
        public static final String TYPE_CLASS = "class";
        public static final String TYPE_CELL = "cell";
        public static final String TYPE_FILE = "file";
        public static final String TYPE_DIRECTORY = "directory";
        public static final String TYPE_CONTEXT = "context";
        public static final String TYPE_BAD_CONFIG = "badconfig";
        private String _intFailureMsg = null;
        private String _type;
        private Object _obj;
        private String _spec;
        private String _onError = null;
        private String _overwrite = null;
        private Method _getInfo = null;

        public AliasEntry(String type, Object obj, String spec) {
            Class[] argClasses = new Class[]{PrintWriter.class};
            this._type = type;
            this._obj = obj;
            this._spec = spec;
            if (obj instanceof HttpResponseEngine) {
                try {
                    this._getInfo = obj.getClass().getMethod("getInfo", argClasses);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }

        public void getInfo(PrintWriter pw) {
            if (this._getInfo == null) {
                pw.println(this.toString());
                return;
            }
            Object[] args = new Object[]{pw};
            try {
                this._getInfo.invoke(this._obj, args);
            }
            catch (Exception e) {
                pw.println("Exception : " + e);
            }
        }

        public void setIntFailureMsg(String entry) {
            this._intFailureMsg = entry;
        }

        public void setOnError(String entry) {
            this._onError = entry;
        }

        public void setOverwrite(String entry) {
            this._overwrite = entry;
        }

        public String getIntFailureMsg() {
            return this._intFailureMsg;
        }

        public String getOnError() {
            return this._onError;
        }

        public String getOverwrite() {
            return this._overwrite;
        }

        public String getType() {
            return this._type;
        }

        public Object getSpecific() {
            return this._obj;
        }

        public String getSpecificString() {
            return this._spec;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this._type).append("(").append(this._spec).append(")");
            if (this._onError != null) {
                sb.append(" [onError=").append(this._onError).append("]");
            }
            if (this._overwrite != null) {
                sb.append(" [overwrite ").append(this._overwrite).append("]");
            }
            return sb.toString();
        }
    }

    public class HttpServiceCellHandler
    extends AbstractHandler {
        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException {
            new HtmlService(request, response).run();
        }
    }
}

