/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.services.hsmcleaner;

import diskCacheV111.util.OsmLocationExtractor;
import diskCacheV111.util.PnfsId;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dcache.services.hsmcleaner.Sink;
import org.dcache.services.hsmcleaner.Trash;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OSMTrash
implements Trash,
FilenameFilter {
    private static final Logger _log = LoggerFactory.getLogger(OSMTrash.class);
    private final Map<URI, PnfsId> _locations = new HashMap<URI, PnfsId>();
    private final Map<PnfsId, Integer> _ids = new HashMap<PnfsId, Integer>();
    private Sink<URI> _sink;
    private final File _directory;
    private int _minAge = 60000;

    public OSMTrash(File directory) {
        this._directory = directory;
    }

    public int getMinimumAge() {
        return this._minAge;
    }

    public void setMinimumAge(int age) {
        if (age < 0) {
            throw new IllegalArgumentException("The age must not be negative");
        }
        this._minAge = age;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void scan(Sink<URI> sink) throws InterruptedException {
        this.waitAndSetSink(sink);
        try {
            this._directory.list(this);
        }
        finally {
            this.clearSink();
        }
    }

    private synchronized void waitAndSetSink(Sink<URI> sink) throws InterruptedException {
        while (this._sink != null) {
            this.wait();
        }
        this._sink = sink;
    }

    private synchronized void clearSink() {
        this._sink = null;
        this.notifyAll();
    }

    private synchronized boolean add(PnfsId id, URI location) {
        assert (location != null);
        PnfsId old = this._locations.put(location, id);
        if (old == null) {
            Integer count = this._ids.get(id);
            if (count == null) {
                this._ids.put(id, 1);
            } else {
                this._ids.put(id, count + 1);
            }
            return true;
        }
        if (!old.equals(id)) {
            _log.error("Same location used for multible files: " + location + " is used by both " + id + " and " + old);
        }
        return false;
    }

    @Override
    public synchronized void remove(URI location) {
        PnfsId id = this._locations.remove(location);
        if (id != null) {
            int count = this._ids.get(id);
            if (count > 1) {
                this._ids.put(id, count - 1);
            } else {
                File file = new File(this._directory, id.toString());
                file.delete();
                this._ids.remove(id);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean accept(File dir, String name) {
        File file = new File(dir, name);
        try {
            long age;
            boolean isNew;
            PnfsId id = new PnfsId(name);
            OSMTrash oSMTrash = this;
            synchronized (oSMTrash) {
                isNew = !this._ids.containsKey(id) && file.exists();
            }
            if (isNew && (age = System.currentTimeMillis() - file.lastModified()) >= (long)this._minAge) {
                List<URI> locations = this.readLevel1File(file);
                for (URI location : locations) {
                    if (!this.add(id, location)) continue;
                    this._sink.push(location);
                }
            }
        }
        catch (IOException e) {
            _log.error("Failed to read trash file " + file.getName() + ": " + e.getMessage());
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<URI> readLevel1File(File file) throws IOException {
        ArrayList<URI> locations = new ArrayList<URI>();
        HashMap<Integer, String> levels = new HashMap<Integer, String>(0);
        BufferedReader in = new BufferedReader(new FileReader(file));
        try {
            String line;
            while ((line = in.readLine()) != null) {
                levels.put(1, line);
                locations.add(new OsmLocationExtractor(levels).location());
            }
        }
        finally {
            in.close();
        }
        return locations;
    }
}

